* -------------- anar_t_elast_sens ---------------------------------------

*############## CES and CET functions for anar_t ################

*#### Recalibration of CET functions for exports
$ontext

  NB: guard against elasticities being set equal to ONE by excluding
      elasticities between 0.85 and 1.15

$offtext

*## Second level CET parameters for EXPORTS by trade partner

$ontext
 Calibrate CET functions with an arbitrary number of trade partners
 AND explicitly exclude the globe because it has a homogeneous export
$offtext

* Scaling elasticities relative to those in database

 sens_elastre(c,r,elst)   = mod_elastre(c,r) * elst_sens(elst,"cet_re") ;

* Avoiding elasticities equal to ONE

 sens_elastre(c,r,elst)$(sens_elastre(c,r,elst) GT 0.85 and sens_elastre(c,r,elst) LE 1.00) = 0.85 ;
 sens_elastre(c,r,elst)$(sens_elastre(c,r,elst) GT 1.00 and sens_elastre(c,r,elst) LT 1.15) = 1.15 ;

* Setting CET parameters for EXPORTS by trade partner

 rhoe(c,r)         = ((1/sens_elastre(c,r,elst)) + 1) ;

 gammar(c,w,r)$(cer(c,w,r) AND rgn(r))
                = (PER0(c,w,r)*QER0(c,w,r)**(1-rhoe(c,r)) ) /
                SUM(wp$cer(c,wp,r), PER0(c,wp,r)*QER0(c,wp,r)**(1-rhoe(c,r)) );

 atr(c,r)$(QE0(c,r) AND rgn(r))
                = QE0(c,r)/SUM(w, gammar(c,w,r)*QER0(c,w,r)
                           **(rhoe(c,r)) )**(1/(rhoe(c,r))) ;


*## Top level CET parameters for aggregate EXPORTS

* Scaling elasticities relative to those in database

 sens_elaste(c,r,elst)   = mod_elaste(c,r) * elst_sens(elst,"cet_e") ;

* Avoiding elasticities equal to ONE

 sens_elaste(c,r,elst)$(sens_elaste(c,r,elst) GT 0.85 and sens_elaste(c,r,elst) LE 1.00) = 0.85 ;
 sens_elaste(c,r,elst)$(sens_elaste(c,r,elst) GT 1.00 and sens_elaste(c,r,elst) LT 1.15) = 1.15 ;

* Setting CET parameters for aggregate EXPORTS

 rhot(c,r)$(cd(c,r) AND ce(c,r))    = (1/sens_elaste(c,r,elst)) + 1 ;

 gamma(c,r)$(cd(c,r) AND ce(c,r))
              = 1/(1+PD0(c,r)/PE0(c,r)*(QE0(c,r)/QD0(c,r))**(rhot(c,r)-1));

* Using QXC0 = (SUM(a,SAMG(a,c,r))/PXC0(c,r))
 at(c,r)$(cd(c,r) AND ce(c,r))
              = (SUM(a,SAMG(a,c,r))/PXC0(c,r))/(gamma(c,r)*QE0(c,r)
                           **rhot(c,r) + (1-gamma(c,r))*
                       QD0(c,r)**rhot(c,r))**(1/rhot(c,r));


*## Second level CES parameters for IMPORTS by trade partner

* Scaling elasticities relative to those in database

 sens_elastrm(c,r,elst)   = mod_elastrm(c,r) * elst_sens(elst,"ces_rm") ;

* Avoiding elasticities equal to ONE

 sens_elastrm(c,r,elst)$(sens_elastrm(c,r,elst) GT 0.85 and sens_elastrm(c,r,elst) LE 1.00) = 0.85 ;
 sens_elastrm(c,r,elst)$(sens_elastrm(c,r,elst) GT 1.00 and sens_elastrm(c,r,elst) LT 1.15) = 1.15 ;

* Setting CES parameters for IMPORTS by trade partner

 rhom(c,r)         = ((1/sens_elastrm(c,r,elst)) - 1) ;

 deltar(w,c,r)$cmrl(w,c,r)
                 = (PMR0(w,c,r)*QMR0(w,c,r)**(1+rhom(c,r)) )
                    /SUM(wp$cmrl(wp,c,r), PMR0(wp,c,r)*QMR0(wp,c,r)
                     **(1+rhom(c,r)) ) ;

 acr(c,r)$QML0(c,r)   = QML0(c,r)/SUM(wp$cmrl(wp,c,r), deltar(wp,c,r)*QMR0(wp,c,r)
                                 **(-rhom(c,r)) )**(-1/rhom(c,r)) ;


*## Top level CES parameters for aggregate IMPORTS

* Scaling elasticities relative to those in database

 sens_elastm(c,r,elst)   = mod_elastm(c,r) * elst_sens(elst,"ces_m") ;

* Avoiding elasticities equal to ONE

 sens_elastm(c,r,elst)$(sens_elastm(c,r,elst) GT 0.85 and sens_elastm(c,r,elst) LE 1.00) = 0.85 ;
 sens_elastm(c,r,elst)$(sens_elastm(c,r,elst) GT 1.00 and sens_elastm(c,r,elst) LT 1.15) = 1.15 ;

* Setting CES parameters for aggregate IMPORTS

 rhoc(c,r)$(cx(c,r) AND cm(c,r))    = (1/sens_elastm(c,r,elst)) - 1 ;

 delta(c,r)$(cd(c,r) AND cm(c,r)) = (PM0(c,r)*QM0(c,r)**(1+rhoc(c,r)) )
                                     /(PM0(c,r)*QM0(c,r)**(1+rhoc(c,r))
                                     + PD0(c,r)*QD0(c,r)**(1+rhoc(c,r))) ;

 ac(c,r)$(cd(c,r) AND cm(c,r)) = QQ0(c,r)/(delta(c,r)*QM0(c,r)**(-rhoc(c,r))
                                        +(1-delta(c,r))*QD0(c,r)
                                  **(-rhoc(c,r)))**(-1/rhoc(c,r)) ;

*#### Recalibration of CES functions for production
$ontext

  NB: guard against elastcities being set equal to ONE by excluding
      elasticities between 0.85 and 1.15

$offtext

*## CES aggregation functions for Level 1 of production nest

* Scaling elasticities relative to those in database

 sens_elastx(a,r,elst)   = mod_elastx(a,r) * elst_sens(elst,"ces_x") ;

* Avoiding elasticities equal to ONE

 sens_elastx(a,r,elst)$(sens_elastx(a,r,elst) GT 0.95 and sens_elastx(a,r,elst) LE 1.00) = 0.95 ;
 sens_elastx(a,r,elst)$(sens_elastx(a,r,elst) GT 1.00 and sens_elastx(a,r,elst) LT 1.05) = 1.05 ;

* Setting CES parameters for Level 1 PRODUCTION by region

 rhox(a,r)    = (1/sens_elastx(a,r,elst)) - 1 ;

 deltax(a,r)$(QINT0(a,r))
               = (PVA0(a,r)*QVA0(a,r)**(1+rhox(a,r)) )
                   /(PVA0(a,r)*QVA0(a,r)**(1+rhox(a,r))
                      + PINT0(a,r)*QINT0(a,r)**(1+rhox(a,r))) ;

 adx0(a,r)$deltax(a,r)
           = QX0(a,r)/(deltax(a,r)*QVA0(a,r)**(-rhox(a,r))
             +(1-deltax(a,r))*QINT0(a,r)**(-rhox(a,r)))**(-1/rhox(a,r)) ;

 adxb(a,r)       = adx0(a,r) ;
 dabadx(a,r)     = 0.0 ;
 adx01(a,r)      = 0.0 ;
 
*## CES aggregation functions for Level 2 of production nest

* Scaling elasticities relative to those in database

 sens_elastva(a,r,elst)   = mod_elastva(a,r) * elst_sens(elst,"ces_va") ;

* Avoiding elasticities equal to ONE

 sens_elastva(a,r,elst)$(sens_elastva(a,r,elst) GT 0.95 and sens_elastva(a,r,elst) LE 1.00) = 0.95 ;
 sens_elastva(a,r,elst)$(sens_elastva(a,r,elst) GT 1.00 and sens_elastva(a,r,elst) LT 1.05) = 1.05 ;

* Setting CES parameters for Level 2 PRODUCTION by region

 rhova(a,r)   = (1/sens_elastva(a,r,elst)) - 1 ;
            
 deltava(ff,a,r)$[map_va_ff(ff,a) AND FD0(ff,a,r)]
            = {[WF0(ff,r)*WFDIST0(ff,a,r)]*[1+tf02(ff,a,r)]*[FD0(ff,a,r)]**[1+rhova(a,r)]}
              / SUM{ffp$map_va_ff(ffp,a),
                    [WF0(ff,r)*WFDIST0(ff,a,r)]*[1+tf02(ffp,a,r)]
                    *[FD0(ffp,a,r)]**[1+rhova(a,r)]} ;
                
 ADVA0(a,r)$SUM(ff$map_va_ff(ff,a),deltava(ff,a,r)*FD0(ff,a,r))
                   = QVA0(a,r)/(SUM(ff$map_va_ff(ff,a),deltava(ff,a,r)*FD0(ff,a,r)
                    **(-rhova(a,r))))**(-1/rhova(a,r));

 advab(a,r)      = adva0(a,r) ;
 dabadva(a,r)    = 0.0 ;
 adva01(a,r)     = 0.0 ;

* -------------- END OF anar_t_elast_sens ---------------------------------
