* ======= Experiment file ================================================
$ontext
 This file sets up and runs experiments on a model. It has a standard structure
 which is described below.

NB: 1) THE USER NEEDS TO SET (SECTION 3) AND IMPLEMENT THE SHOCKS (SECTION 5)
    2) THE USER SHOULD MAKE SURE THAT THE NAME OF THE OUTPUT FILEs - IN GDX -
       ARE THOSE DESIRED.
             DEFAULT NAMES ARE IMPOSED IN THE VARIOUS RESULT MODULES
                     - THESE CAN BE CHANGED BY THE USER.

 Structure
          1. Declare and Assign Simulation Set
          2. Define Result Parameters
          3. Setting up the sim shocks
                 3a. Declaring Parameters for Shocks
                 3b. Assigning Parameters for Shocks
          4. Setting up the Closures
                 4a. Declaring Parameters for Closure
                 4b. Assigning Parameters for Closure
          5. Runnin the experiments
                 5a. clos loop begins
                 5b. sim loop begins
                 5c. Implementing sim shocks
          6. Solve statement
          7. Storing results
          8. Terminating sim loop
          9. Terminating clos loop

The experiment code consists of a number of files; the relationships between
these files is illustrated below.

 anar_t_*.gms                                master programme file
     |
    .
     .
      .
       .
     |
     | 16. POLICY EXPERIMENTS
     |
     |<----- anar_t_expt_**.inc          Experiment files
                 |
                 |<----- anar_t_resparm.inc     Declare results params
                 |
                 |<----- anar_t_varinit2.inc    Reinitialise variables
                 |<----- anar_t_reset.inc       Reset closure variables
                 |
                 |<----- anar_t_cl***1.inc        Alternative closures
                 |<----- anar_t_cl***..inc                 .
                 |<----- anar_t_cl***..inc                 .
                 |<----- anar_t_cl***n.inc        Alternative closures
                 |
                 |
                 |<----- anar_t_resassign.inc   Assigning results params
                 |
                 |
      |
      |<----- anar_t_anal.inc         Result Analyses sub routine
      |          |
                 |
                 |<----- anar_t_reslevel.inc    Levels results saved
                 |
                 |<----- anar_t_resmacro.inc    Macroeconomic results
                 |
                 |<----- anar_t_reswelf.inc     Welfare results
                 |
                 |<----- anar_t_resstruct.inc   Structural results
                 |
                 |<----- anar_t_resindex.inc    Price index results
                 |
                 |<----- anar_t_resperc.inc     Proportionate results

$offtext

* ------- 1a. Declare Sets for Simulations --------------------------

* By including a "base case" in the SIM set a comparator is produced

SETS
* Sets for simulations

 sim          simulations
 simc(sim)    simulations actually done
 simr(simc)   simulations reported

 clos         closures
 elst         elasticities

* Sub Sets used in experiments

 cagr(c)      Agricultural Commodities
 cnat(c)      Natural Resource Commodities
 cfd(c)       Food Commodities
 cind(c)      Industrial Commodities
 cuti(c)      Utility Commodities
 cser(c)      Service Commodities

 aagr(a)      Agricultural Activities
 anat(a)      Natural Resource Activities
 afd(a)       Food Activities
 aind(a)      Industrial Activities
 auti(a)      Utility Activities
 aser(a)      Service Activities

 l(f)         Labour Factors
 ls(l)        Skilled Labour Factors
 lu(l)        Unskilled Labour Factors
 k(f)         Capital Factors
 lnd(f)       Land factors

* Sub sets used in closures

 rerfx(r)     Regions where the exchange rate is fixed
 rerfxn(r)    Regions where the external balance is fixed

 rluen(r)     Regions with Unemployed unskilled labour endogenous supply
 rluex(r)     Regions where unskilled labour fixed exogenous supply

* Set used to results flow

 rcons        set for parameters controlling results flow

* Sets delared for experiments

 rfta(r)      Regions in FTA
 rftan(r)     Regions NOT in FTA

 wfta(w)      Trade partners in FTA
 wftan(w)     Trade partners NOT in FTA

 cagrn(c)     Commodities other than agriculture

  ;

ALIAS    (cagr,cagrp),(cnat,cnatp),(cfd,cfdp),(cind,cindp),(cser,cserp),
         (aagr,aagrp),(anat,anatp),(afd,afdp),(aind,aindp),(aser,aserp),
         (l,lp),(ls,lsp),(lu,lup),(k,kp),(lnd,lndp) ;

* ------- 1b. Declare Parameters to control Simulation  -----------------

Parameter

* Parameters used to control closure flow

 closure(clos)    values that control choice of closure

* Parameters used to results flow

 res_cont(rcons)   values for parameters controlling results flow

* Sensitivity analyses data
* Trade Elasticities
 sens_elastre(c,r,elst)  Level 2 CET elasticities for sensitivity analyses
 sens_elaste(c,r,elst)   Level 1 CET elasticities for sensitivity analyses

 sens_elastrm(c,r,elst)  Level 2 CES elasticities for sensitivity analyses
 sens_elastm(c,r,elst)   Level 1 CES elasticities for sensitivity analyses


* Production elasticities

 sens_elastx(a,r,elst)   Level 1 CES elasticities for production
 sens_elastva(a,r,elst)  Level 2 CES elasticities for production

* Demand elasticities


  ;


* ------- 1c. Assign Sets and Parameters for Simulations ----------------

*---- Additional data for policy simulations

* Convert Excel workbook data to GDX here

$CALL "GDXXRW i=1_2_Expt_data\%expt_data%.xlsx o=1_2_Expt_data\expt_in.gdx INDEX=LAYOUT!A4 trace=3"
$if errorLevel 1 $abort problems with GDXXRW

* Loading sets from GDX data file

$GDXIN 1_2_Expt_data\expt_in.GDX

$LOADdc rluen rfta wfta
$LOADdc sim simc clos elst
$LOADdc rcons

$LOADdc closure res_cont

$GDXIN

* Assigning set members to simr(simc)
$ontext
    The set simr(simc) allows the user to report only a sub of the current
 simulations (simc).

    The ability to report only a selection of results can be useful in
 certain circumstances:
    1.  large models may need to implement 'large' shocks incremetally
        to get a solution (less of a problem with the new solvers);
    2.  if a large set of simulations are run the user may wish to limit
        output to simplfy exploration of the results;
    3.  a modeller may only want to share a sub set of the results with
        colleagues, clients etc., who may be less able to handle very
        large quantities of results; and
    4.  etc.

   NB: use of GDX=***** in teh command line will ensure that ALL the results
       from current simulations are exported to the file *****.gdx

   A similar set up could be used with recursive dynamic models that are
   solved annually when the user may only want to analyse results for a
   sub set of years

$offtext

* Default
 simr(simc)     = YES ;

* Example of alternative
$ontext
* First, switch off the default
 simr(simc)      = NO ;

* Second, set the simulations to be reported
 simr("base")    = YES ;
 simr("sim03")   = YES ;

$offtext



* Assigning set members by reference to other sets

 rftan(r)      = not rfta(r) ;
 wftan(w)      = not wfta(w) ;

 rluex(r)      = not rluen(r) ;



* ------- 2. Define Result Parameters ------------------------------------

* This section defines the result parameter that are used to store model
* results between experiments and sims.

* ------------------- RESULTS IN LEVELS -----------------------------------

* Declaring parameters for levels (and proportionate change) results

$SETGLOBAL res  lev_

$INCLUDE 5_analysis\anar_t_resparm.inc

$DROPGLOBAL res

* ------- 3. Setting up the sim shocks -----------------------------------

* ------- 3a. Declaring Parameters for Shocks ----------------------------

Parameter
* Standard parameters for tax instrument shocks
 TESIM(c,w,r,sim)      Export taxes on exported comm'y c from r to w
 TMSIM(w,c,r,sim)      Tariff rates on imported comm'y c from w by r
 TSSIM(c,r,sim)        Sales tax rate
 TXSIM(a,r,sim)        Indirect tax rate
 TYFSIM(f,r,sim)       Direct tax rate on factor income
 TYHSIM(h,r,sim)       Direct tax rate on households
 TFSIM(f,a,r,sim)      Tax rate on factor use

* Standard parameters for efficiency rate shocks
 ADXSIM(a,r,sim)       Shift parameter for CES production functions for QX in r
 ADVASIM(a,r,sim)      Shift parameter for CES production functions for QVA
 ADFDSIM(f,a,r,sim)    Shift parameter for factor and activity specific efficiency

* Standard parameters for factor demand and supply shocks
 FDSIM(f,a,r,sim)      Demand for factor f by activity a in r
 FSSIM(f,r,sim)        Supply of factor f in r

* Shocks data

  ;

* ------- 3b. Assigning Parameters for Shocks ----------------------------

* ------ Defining the shock parameters

*---- 1. Setting tax rate shocks

*-- Tariff rates
* assign base rates for all sims and then over write for the relevant sim below

 TMSIM(w,c,r,sim)           = TM0(w,c,r) ;

* Export tax rates

 TESIM(c,w,r,sim)           = TE0(c,w,r) ;

* Factor Use Taxes

 TFSIM(f,a,r,sim)           = TF0(f,a,r) ;

* Household Income Taxes

 TYHSIM(h,r,sim)            = TYH0(h,r) ;

* Factor Income Taxes
 TYFSIM(f,r,sim)            = TYF0(f,r) ;

* Production tax rates

 TXSIM(a,r,sim)             = TX0(a,r) ;

* Sales tax rates

 TSSIM(c,r,sim)             = TS0(c,r) ;

*---- 2. Setting efficiency rate shocks

* Top level Hicks neutral efficiency parameter
 ADXSIM(a,r,sim)            = adx0(a,r) ;

* 2.5% TFP in crops in Australia and New Zealand
 ADXSIM("acrop","anz","sim01")   = adx0("acrop","anz") * 1.025 ;

* 2.5% TFP in crops in USA and Canada
 ADXSIM("acrop","namer","sim02") = adx0("acrop","namer") * 1.025 ;

* Aggregate value added Hicks neutral efficiency parameter
 ADVASIM(a,r,sim)           = adva0(a,r) ;

* Individual factor efficiency parameter
 ADFDSIM(f,a,r,sim)         = adfd0(f,a,r) ;

*---- 3. Setting factor supply shocks
* factor supply shocks
 FSSIM(f,r,sim)             = FS0(f,r) ;

* Displaying shock parameters

Execute_Unload  'anar_t_shocks.gdx',

 TMSIM, TESIM, TFSIM, TYHSIM, TYFSIM, TXSIM, TSSIM,
 ADXSIM, ADVASIM, ADFDSIM,
 FDSIM, FSSIM

   ;

* ------- 4. Running the experiments ---------------------------------------

* ------- 4a. elst loop begins --------------------------------------------

LOOP(elst,


* ------- 4b. clos loop begins --------------------------------------------

LOOP(clos,

* First set .L values back to initial values for looping over diff closures

$INCLUDE 2_include\anar_t_varinit2.inc

* Second, free all variables that are involved in any closure rule

$INCLUDE 2_include\anar_t_reset.inc

* Third, select closure include files
*$offtext


IF(Closure(clos) = 1,

$INCLUDE 3_close\anar_t_cl_balm.inc

$ontext

                     CONDITION                                 REGIONS

     FEX        - Exchange rate fixed                           rerfx
                - KAPWOR fixed                                  rerfxn

     Investment - absorption share fixed                         All

     Government - absorption share fixed                         All
                - tax rates fixed                                All
                - CAPGOV flexible                                All

     Factors    - Land sector - mobile & full                    All
                - Capital - mobile & full                        All
                - Unskilled labour - mobile & full               All
                - Skilled labour - mobile & full                 All

     Numeraire  - CPI                                            All

$offtext

 ) ;



* ------- 4c. sim loop begins ---------------------------------------------

LOOP(simc(sim),

* ------- 4d. Implementing sim shocks -------------------------------------

*---- 1. Applying tax rate shocks

* Import duties

 tmb(w,c,r)    = TMSIM(w,c,r,simc) ;

* Export taxes

 teb(c,w,r)    = TESIM(c,w,r,simc) ;

* Factor Use taxes

 tfb(f,a,r)    = TFSIM(f,a,r,simc) ;

* Household Income taxes

 tyhb(h,r)     = TYHSIM(h,r,simc) ;

* Factor Income taxes

 tyfb(f,r)     = TYFSIM(f,r,simc) ;

* Production taxes

 txb(a,r)      = TXSIM(a,r,simc) ;

* Sales taxes

 tsb(c,r)      = TSSIM(c,r,simc) ;

*---- 2. Applying efficiency rate shocks

* Top level Hicks neutral efficiency parameter
 adxb(a,r)     = ADXSIM(a,r,simc) ;

* Aggregate value added Hicks neutral efficiency parameter
 advab(a,r)    = ADVASIM(a,r,simc) ;

* Individual factor efficiency parameter
 adfdb(f,a,r)   = ADFDSIM(f,a,r,simc) ;

*---- 3. Applying factor demand and supply shocks
* factor supply shocks
* FS.FX(f,r)     = FSSIM(f,r,simc) ;

* ------- 5. Solve statement ---------------------------------------------

 OPTION DECIMALS = 6 ;
 Options limrow=100,limcol=0;


 Solve anar_t Using MCP ;

* ------- 6. Storing results ---------------------------------------------

* Assigning levels results to the result parameters for all variables

$INCLUDE 5_analysis\anar_t_resassign.inc

* ------- 7a. Terminating sim loop ----------------------------------------

 ) ;


* ------- 7b. Terminating clos loop ----------------------------------------

 ) ;

* ------- 7c. Terminating elst loop ----------------------------------------

 ) ;

* ########### END OF EXPERIMENT FILE #####################################
