* -------------- anar_t_samgchk ------------------------------------------

$ontext
  This section checks that the model is calibrated with a balanced SAM,
by using a Macro SAM.

  The programme aborts IF
           - ROW AND COLUMN SUMS FOR ASAMG1 NOT EQUAL
           - ALL ASAMG1 CELL ENTRIES DO NOT EQUAL ASAMG0 ENTRIES

$offtext

*#### TO CHECK FOR DATA CONSISTENCY, DISPLAY CALCULATED ASAMG

 %ASAMG%("COMMDTY","ACTIVITY",r) = SUM(c,QINTD.L(c,r)*PQD.L(c,r)) ;
 %ASAMG%("COMMDTY","HHOLDS",r)   = SUM((c,h),QCD.L(c,h,r)*PQCD.L(c,r)) ;
 %ASAMG%("COMMDTY","GOVTN",r)    = SUM(c,QGD.L(c,r)*PQD.L(c,r)) ;
 %ASAMG%("COMMDTY","KAPITAL",r)  = SUM(c,QINVD.L(c,r)*PQD.L(c,r)) ;
 %ASAMG%("COMMDTY","WORLD",r)    = SUM((c,w),PWE.L(c,w,r)
                                     *QER.L(c,w,r)*ER.L(r)) ;

 %ASAMG%("ACTIVITY","COMMDTY",r) = SUM(a,PX.L(a,r)*QX.L(a,r)) ;

 %ASAMG%("VALUAD","ACTIVITY",r)  = SUM((f,a),WF.L(f,r)*WFDIST.L(f,a,r)
                                      *FD.L(f,a,r)) ;

 %ASAMG%("HHOLDS","VALUAD",r)    = SUM((h,f),hvash(h,f,r)*YFDIST.L(f,r)) ;

 %ASAMG%("TMTAX","COMMDTY",r)    = SUM((c,w),TM.L(w,c,r)
                                       *PWM.L(w,c,r)*QMR.L(w,c,r)*ER.L(r)) ;

 %ASAMG%("TETAX","COMMDTY",r)    = SUM((c,w),TE.L(c,w,r)
                                       *PWE.L(c,w,r)*ER.L(r)*QER.L(c,w,r)) ;

 %ASAMG%("TFTAX","ACTIVITY",r)   = SUM((f,a), TF.L(f,a,r)
                                    *WF.L(f,r)*WFDIST.L(f,a,r)*FD.L(f,a,r)) ;

 %ASAMG%("GOVTN","COMMDTY",r)    = SUM(c,TS.L(c,r)*PQS.L(c,r)*QQ.L(c,r))
                                  + SUM((c,h), TV.L(c,r)*PQD.L(c,r)*QCD.L(c,h,r));

 %ASAMG%("GOVTN","ACTIVITY",r)   = SUM(a,TX.L(a,r)*PX.L(a,r)*QX.L(a,r)) ;

 %ASAMG%("GOVTN","VALUAD",r)     = SUM(f,TYF.L(f,r)*(1-deprec(f,r))*YF.L(f,r)) ;
 %ASAMG%("GOVTN","HHOLDS",r)     = SUM(h,TYH.L(h,r)*YH.L(h,r)) ;
 %ASAMG%("GOVTN","TMTAX",r)      = SUM((c,w),TM.L(w,c,r)
                                       *PWM.L(w,c,r)*QMR.L(w,c,r)*ER.L(r)) ;
 %ASAMG%("GOVTN","TETAX",r)      = SUM((c,w),TE.L(c,w,r)
                                       *PWE.L(c,w,r)*ER.L(r)*QER.L(c,w,r)) ;
 %ASAMG%("GOVTN","TFTAX",r)      = SUM((f,a), TF.L(f,a,r)
                                      *WF.L(f,r)*WFDIST.L(f,a,r)*FD.L(f,a,r)) ;

 %ASAMG%("KAPITAL","VALUAD",r)   = SUM(f,deprec(f,r)*YF.L(f,r)) ;
 %ASAMG%("KAPITAL","HHOLDS",r)   = SUM(h,(YH.L(h,r)*(1-TYH.L(h,r)))
                                        *(SHH.L(h,r))) ;
 %ASAMG%("KAPITAL","GOVTN",r)    = KAPGOV.L(r) ;
 %ASAMG%("KAPITAL","WORLD",r)    = (KAPWOR.L(r)*ER.L(r)) ;

 %ASAMG%("MARGS","COMMDTY",r)    = SUM((c,w),PT.L(c,r)*QT.L(w,c,r)*ER.L(r)) ;

 %ASAMG%("WORLD","COMMDTY",r)    = SUM((c,w),PWMFOB.L(w,c,r)
                                      *QMR.L(w,c,r)*ER.L(r)) ;

 %ASAMG%("WORLD","MARGS",r)      = SUM((c,w),PT.L(c,r)*QT.L(w,c,r)*ER.L(r)) ;

 %ASAMG%("TOTALS",ssnp,r)        = SUM(ssn,%ASAMG%(ssn,ssnp,r)) ;
 %ASAMG%(ssn,"TOTALS",r)         = SUM(ssnp,%ASAMG%(ssn,ssnp,r)) ;


*-------- Checking that a balanced and equal ASAMG is produced

 %ASAMG%_CHK(ss,ssp,r)$ASAMG0(ss,ssp,r) = %ASAMG%(ss,ssp,r)/ASAMG0(ss,ssp,r) ;

 CHECK_%ASAMG%(r) = SUM(ssn,((%ASAMG%(ssn,"totals",r)-%ASAMG%("totals",ssn,r)))) ;

* DIFF%ASAMG%(ss,ssp,r)  = ASAMG0(ss,ssp,r) - %ASAMG%(ss,ssp,r) ;
* KT 9 June
* this check won't work when generalize samgchk
* because with numeraire check, need to multiply ASAMG0 against numerchk

 DIFF%ASAMG%(ss,ssp,r) =  [ASAMG0(ss,ssp,r) * numerchk_samchk] - %ASAMG%(ss,ssp,r) ;


 DIFF%ASAMG%(ss,ssp,r)$(ABS(DIFF%ASAMG%(ss,ssp,r)
                            lt (10*mod_cont("toldiffsam")))) = 0.0 ;

 DIFF%ASAMG%("totals","totals",r)   = 0.0 ;

 CNT%ASAMG%(r)  = SUM((ssn,ssnp)$DIFF%ASAMG%(ssn,ssnp,r), 1) ;

*###### CHECKING THE MICRO SAMG FOR ALL REGIONS ###################

*#### GENERATE NEW GLOBAL SAMG FOR EACH EXPERIMENT
$ontext
  This section checks that the model is calibrated with a balanced SAM,
by using a Micro SAM.

  The programme aborts IF
           - ALL SAMG1 CELL ENTRIES DO NOT EQUAL SAMG ENTRIES

  The data are stored as SAMG. For ALL regions the model uses a SAM that has
the following structure of potentially active submatrices: X marks
submatrices active in the database and model.

       1     2     3     4     5     6     7     8     9     10    11    12
    � COM � ACT � FAC � HOU � TM  � TE  � ITX � YTX � GOV � KAP � MAR � ROW
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
COM �  0  �  X  �  0  �  X  �  0  �  0  �  0  �  0  �  X  �  X  �  0  �  X
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
ACT �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
FAC �  0  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
HOU �  0  �  0  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
TM  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
TE  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
ITX �  X  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
YTX �  0  �  0  �  X  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
GOV �  0  �  0  �  0  �  0  �  X  �  X  �  X  �  X  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
KAP �  0  �  0  �  X  �  X  �  0  �  0  �  0  �  0  �  X  �  0  �  0  �  X
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
MAR �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
ROW �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  X  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----

$offtext

* -------- Commodity Accounts ---------

 %SAMG%(c,a,r)       = ioqint(c,a,r) * ioqintqx(a,r) * QX.L(a,r) * PQD.L(c,r) ;

 %SAMG%(c,h,r)       = QCD.L(c,h,r) * PQCD.L(c,r) ;

 %SAMG%(c,g_t,r)  = QGD.L(c,r) * PQD.L(c,r) ;

 %SAMG%(c,i_is,r)   = QINVD.L(c,r) * PQD.L(c,r) ;

 %SAMG%(c,w,r)       = QER.L(c,w,r) * PWE.L(c,w,r) * ER.L(r) ;

* -------- Activity Accounts ----------

 %SAMG%(a,c,r)       = ioqxcqx(a,c,r) * PXC.L(c,r) * QX.L(a,r) ;

* -------- Factor Accounts ------------

 %SAMG%(f,a,r)       = FD.L(f,a,r) * WF.L(f,r) * WFDIST.L(f,a,r) ;

* -------- Household Accounts ---------

 %SAMG%(h,f,r)       = hvash(h,f,r) * YFDIST.L(f,r) ;

* -------- Tariff Accounts ------------

 %SAMG%(tmr,c,r)     = SUM(w$MAP_TMR_W(tmr,w),
                       TM.L(w,c,r) * PWM.L(w,c,r) * QMR.L(w,c,r) * ER.L(r)) ;

* -------- Export Duty Accounts -------

 %SAMG%(ter,c,r)     = SUM(w$MAP_TER_W(ter,w),
                       TE.L(c,w,r) * PWE.L(c,w,r) * ER.L(r) * QER.L(c,w,r)) ;

* -------- Indirect Tax Accounts ------

 %SAMG%(t_TS,c,r) = TS.L(c,r) * PQS.L(c,r) * QQ.L(c,r) ;

 %SAMG%(t_TV,c,r) = SUM(h, TV.L(c,r) * PQD.L(c,r) * QCD.L(c,h,r)) ;

 %SAMG%(tff,a,r)      = SUM(f$MAP_TFF_F(tff,f),
                       TF.L(f,a,r) * WF.L(f,r) * WFDIST.L(f,a,r) * FD.L(f,a,r)) ;

 %SAMG%(t_TX,a,r) = TX.L(a,r) * PX.L(a,r) * QX.L(a,r) ;

* -------- Direct Tax Accounts --------

 %SAMG%(t_TD,f,r)  = TYF.L(f,r) * (1-deprec(f,r)) * YF.L(f,r) ;

 %SAMG%(t_TD,h,r)  = TYH.L(h,r) * YH.L(h,r) ;

* -------- Government Accounts --------

 %SAMG%(g_t,tmr,r)  = SUM(c,%SAMG%(tmr,c,r)) ;

 %SAMG%(g_t,ter,r)  = SUM(c,%SAMG%(ter,c,r)) ;

 %SAMG%(g_t,tff,r)  = SUM(a,%SAMG%(tff,a,r)) ;

 %SAMG%(g_t,t_TS,r)
                      = SUM(c,%SAMG%(t_TS,c,r)) ;
 %SAMG%(g_t,t_TV,r)
                      = SUM(c,%SAMG%(t_TV,c,r)) ;

 %SAMG%(g_t,t_TX,r)
                      = SUM(a,%SAMG%(t_TX,a,r)) ;

 %SAMG%(g_t,t_TD,r)
                      = SUM(f,%SAMG%(t_TD,f,r))
                        + SUM(h,%SAMG%(t_TD,h,r)) ;

* -------- Trade Margin Accounts ------

 %SAMG%(owatpmarg,cp,r)   = SUM(w$map_marg_w(owatpmarg,w),
*                           PT.L("ctrdt",r) * QMR.L(w,cp,r)
                           QMR.L(w,cp,r) *
                            SUM(c$ct(c,r), PT.L(c,r) * margcor(w,c,cp,r))) ;

*                           PT.L("cserv",r) * QMR.L(w,cp,r)
*                             * margcor(w,"cserv",cp,r)) ;

* -------- Trade Accounts -------------

 %SAMG%(w,c,r)           = PWMFOB.L(w,c,r) * QMR.L(w,c,r) * ER.L(r) ;

 %SAMG%(w_glb,owatpmarg,r)
                        = SUM(c,%SAMG%(owatpmarg,c,r)) ;


* -------- Capital Accounts -----------

 %SAMG%(i_is,f,r)       = deprec(f,r) * YF.L(f,r) ;

 %SAMG%(i_is,wgn,r)     = SUM(c,%SAMG%(wgn,c,r)) - SUM(c,%SAMG%(c,wgn,r)) ;

 %SAMG%(i_is,w_glb,r)  = SUM((owatpmarg,c),%SAMG%(owatpmarg,c,r)) - SUM(c,%SAMG%(c,w_glb,r)) ;

 %SAMG%(i_is,h_h,r)  = SUM(h,(YH.L(h,r)*(1-TYH.L(h,r)))*(SHH.L(h,r))) ;

 %SAMG%(i_is,g_t,r)  = KAPGOV.L(r) ;


* -------- Account Totals -------------

 %SAMG%("TOTAL",sacnp,r)        = SUM(sacn,%SAMG%(sacn,sacnp,r)) ;
 %SAMG%(sacn,"TOTAL",r)         = SUM(sacnp,%SAMG%(sacn,sacnp,r)) ;

* -------- Checks on SAMG1 ------------

 %ASAMG%_CHK(ss,ssp,r)$ASAMG0(ss,ssp,r) = %ASAMG%(ss,ssp,r)/ASAMG0(ss,ssp,r) ;

 %SAMG%_CHK(sac,r) = (ABS(%SAMG%(sac,t_tot,r)-%SAMG%(t_tot,sac,r))) ;

 %SAMG%_CHK(sac,r)$(ABS(%SAMG%_CHK(sac,r) lt mod_cont("toldiffsam")))
                 = 0.0 ;

 CHECK_%SAMG%(r)   = SUM(sacn,((%SAMG%(sacn,t_tot,r)-%SAMG%(t_tot,sacn,r)))) ;

* Use absolute values

 DIFF%SAMG%(sac,sacp,r)  = ABS(SAMG(sac,sacp,r)) - ABS(%SAMG%(sac,sacp,r)) ;

 DIFF%SAMG%(sac,sacp,r)$(ABS(DIFF%SAMG%(sac,sacp,r) lt mod_cont("toldiffsam")))
                        = 0.0 ;

 DIFF%SAMG%(t_tot,t_tot,r)   = 0.0 ;

 perDIFF%SAMG%(sac,sacp,r)$SAMG(sac,sacp,r)
                        =  (DIFF%SAMG%(sac,sacp,r)/SAMG(sac,sacp,r)) * 100 ;

 CNT%SAMG%(r)  = SUM((sacn,sacnp)$DIFF%SAMG%(sacn,sacnp,r), 1) ;

*---- Display and Abort Statements

 OPTION decimals = 6 ;

DISPLAY CHECK_%ASAMG% ;

Display %ASAMG%_CHK, DIFF%ASAMG%, CNT%ASAMG%
        %SAMG%_CHK, DIFF%SAMG%, perDIFF%SAMG%, CNT%SAMG% ;

* CHECK_%ASAMG%(r) = SUM(ssn,((%ASAMG%(ssn,"totals",r)-%ASAMG%("totals",ssn,r)))) ;

 ABORT $(SUM(r,CHECK_%ASAMG%(r) GT 0.000005))
         "%ASAMG%: ROW AND COLUMN SUMS FOR %ASAMG% NOT EQUAL" ;

 ABORT$(SUM(r,CNT%ASAMG%(r) GT 0.0))
         "COUNT OF %ASAMG% CELL ENTRIES DO NOT EQUAL ASAMG0 ENTRIES" ;

*$ontext
 ABORT $(SUM(r,CHECK_%SAMG%(r) GT 0.000005))
         "%SAMG%: ROW AND COLUMN SUMS FOR %SAMG% NOT EQUAL" ;
         
 ABORT$(SUM(r,CNT%SAMG%(r) GT 0.0))
         "COUNT OF %SAMG% CELL ENTRIES DO NOT EQUAL SAMG0 ENTRIES" ;

*$offtext
         
 OPTION decimals = 3 ;

* -------------- END OF anar_t_samgchk -----------------------------------
