$TITLE The ANARRES Multi Country GTAP Based CGE Model version t_8 final
$OFFUPPER
$ONEMPTY

*$onsymlist

$ontext

On Dollar Control Directives see Chapter 10 GAMS manual

*$TITLE - inserts a user chosen title on the page header (max 80 characters)
*$OFFUPPER - ensures echo print is case consistent with *.gms file
*$ONEMPTY - allows declarations without assignment
*$ontext and $offtext - allow blocks of comments
*$offlisting - suppresses the echo print of the input file
*$onsymxref  - switches on the symbol reference map
*$onsymlist - switches on the symbol listing map

$offtext

*################ GENERAL INFORMATION ####################################
$ontext

This programme is a version of the ANARRES_t model calibrated using GTAP 8 data.

ANARRES and ANARRES_t were developed by
                   Scott McDonald (cgemod)
                  
         Scott McDonald              
         cgemod                      
         email: scott@cgemod.org.uk         

Copyright (c) 2024 Scott McDonald
         
This version was last checked Oct 2024
  
  This version of ANARRES_t has been developed for use on the Global CGE
Modelling Course offered by cgemod.

  It is provided in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  This version can be used by all former participants of the Global CGE
Modelling Course for academic research and/or consultancy.

  If you are using this programme by agreement you must acknowledge the
source and not claim authorship. In addition, unless the model's authors
have been involved with the research you should not in any way imply their
involvement.

  You must not provide copies of this model to any third party. Rather you
should direct third parties to the source (www.cgemod.org) to ensure they
have the latest version.

  Altered versions must be clearly distinguished from the original.

NB 1: Unless you make substantial changes to the behavioural relationships
      in the model it is NOT acceptable to rename the model.

NB 2: If you do make changes to the behavioural relationships these should be
      fully documented and the model origins should be acknowledged.

NB 3: Using the GLOBE model with a different aggregation of the database
      and/or different elasticities etc., is NOT a behavioural change.

  The appropriate references are:
  
McDonald, S., (2023).
     'ANARRES: A SAM Based Global CGE Model' (www.cgemod.org.uk/  )

McDonald, S. and Thierfelder, K., (2020). 'Globe_3: A SAM Based Global
                CGE Model', mimeo.

McDonald, S. and Thierfelder, K., (2020). 'Globe_CC: A SAM Based Global
                CGE Model', mimeo.

McDonald, S. and Thierfelder, K., (2004). 'Deriving a Global Social
         Accounting Matrix from GTAP version 5 Data', Global Trade
         Analysis Project Technical Paper 23, Center for Global
         Trade Analysis: Purdue University.

McDonald, S., (2005). 'Deriving Reduced Form Social Accounting Matrices
         from a GTAP based Global Social Accounting Matrix', mimeo.

  If you find these conditions unacceptable you should delete the GLOBE
programme and all related files from your PC, etc., immediately and
no copy should be kept.

GLOBE 3 was developed by
                   Scott McDonald (cgemod)
                   Karen Thierfelder (US Naval Academy)

   Scott McDonald                      Karen Thierfelder
   cgemod                              Dept of Economics
   14 Moncrieffe Road                  US Naval Academy
   Sheffield, UK                       Annapolis, Maryland, USA
   email: jrs.mcdonald@gmail.com       email: thier@usna.edu
          scott@cgemod.org.uk                 karen.thierfelder@gmail.com
                       
Copyright (c) 2020 Scott McDonald and Karen Thierfelder.

The original version of GLOBE was developed by
                       Scott McDonald (cgemod)
                       Karen Thierfelder (US Naval Academy)
                       with Sherman Robinson (University of Sussex)

 Scott McDonald         Karen Thierfelder     Sherman Robinson
 cgemod                 Dept of Economics     Dept of Economics
 14 Moncrieffe Road     US Naval Academy      School of Social Sciences
 Sheffield              Annapolis             University of Sussex
 UK                     Maryland, USA         Brighton, BN1 9SN, UK

Copyright (c) 2006 Scott McDonald, Karen Thierfelder and Sherman Robinson.

$offtext
*##################### Model Input Data Selection ###########################
$ontext

$offtext

*~~~~~~ Model Data

*~~~ Excel Data File
$SETGLOBAL  mod_xls_data     data_4_4_3_anar_t_8_G1


*~~~ GDX Data File
$SETGLOBAL  mod__gdx_data    samg_4_4_3_anar_t_8

*################ WORK TO DO ON THIS VERSION ############################
$ontext

$offtext
*##################### 1. MODEL DESCRIPTION #############################

* ------ DESCRIPTION OF BASIC MODEL

$INCLUDE 2_include/anar_t_descrip.inc

* ------ SCHEMATIC OUTLINE OF PROGRAMME
$ontext

The model code consists of a number of files; the relationships between
these files are illustrated below.

 anar_t.gms                                master programme file
     |
     |<----- anar_t_descrip.inc     model data & behaviour description
     |<----- anar_t_convent.inc     conventions used in model code
     |
     | 2. Model Origins
     |
     | 3. PARAMETER AND VARIABLE LISTINGS
     |
     |<----- anar_t_list.inc        alphabetic listing
     |
     | 4. SET AND DATA PARAMETER DECLARATION
     |
     |<----- dat_C_F_R.inc              data include file
             |
             |<-- data_C_F_R.xls   Excel file with Sets and some elasts
             |
             |<-- samg_C_F_R.gdx   GDX file with data and some elasticities
             |
     |<----- samgadj_C_F_R.inc          SAMG adjustment file
     |
     | 5. SET AND DATA ASSIGNMENT
     |
     | 6. DATA DIAGNOSTICS
     |
     |<----- anar_t_diagnost.inc    data diagnostics file
     |
     | 7. PARAMETER CALIBRATION
     |
     |<----- anar_t_parmcalib.inc   Parameter declaration
     |                                         and calibration file
     |
     | 8. VARIABLE DECLARATION
     |
     | 9. VARIABLE INITIALISATION
     |
     |<----- anar_t_varinit.inc     Variable initialisation file
     |
     | 10. SOCIAL ACCOUNTING MATRIX
     |
     |<----- anar_t_asamg1.inc      MacroSAM check on calibration
     |<----- anar_t_samg1.inc       MicroSAM check on calibration
     |
     |10b. Structural Tables
     |
     |<----- structab1.gms             Descriptive structural tables
     |
     | 11. EQUATION DECLARATION
     |
     | 12. EQUATIONS
     |
     | 13. MODEL CLOSURE
     |
     |<----- anar_t_bclose.inc      Base model closure
     |
     | 14. MODEL & SOLVE STATEMENTS
     |
     | 15. SOCIAL ACCOUNTING MATRIX
     |
     |<----- anar_t_asamg2.inc      Macro SAM check on model
     |<----- anar_t_samg2.inc       Micro SAM check on model
     |
     | 16. POLICY EXPERIMENTS
     |
     |<----- anar_t_expt_**.inc       Experiment files
             |
             |<----- anar_t_resparm.inc     Declare results params
             |
             |<----- anar_t_varinit2.inc    Reinitialise variables
             |<----- anar_t_reset.inc       Reset closure variables
             |
             |<----- anar_t_cl***1.inc        Alternative closures
             |<----- anar_t_cl***..inc                 .
             |<----- anar_t_cl***..inc                 .
             |<----- anar_t_cl***n.inc        Alternative closures
             |
             |
             |<----- anar_t_resassign.inc   Assigning results params
             |
             |
     |
     |<----- anar_t_1_anal.inc         Result Analyses sub routine
     |       |
             |
             |<----- anar_t_reslevel.inc    Levels results saved
             |
             |<----- anar_t_resmacro.inc    Macroeconomic results
             |
             |<----- anar_t_reswelf.inc     Welfare results
             |
             |<----- anar_t_resstruct.inc   Structural results
             |
             |<----- anar_t_resindex.inc    Price index results
             |
             |<----- anar_t_resperc.inc     Proportionate results

$offtext

*############### 2. MODEL ORIGINS #######################################
$ontext

Model structure derives from
Dervis et al (1984) 'General Equilibrium Models....'

SAM approach derives from Pyatt (1988)
'SAM Approach to Modelling'

Programme organisation - data followed by model
see Brooke et al (1992) 'GAMS: A Users Guide' Chapter 3

Code structure originally derives from
USDA Model by Robinson et al (1990) AND
Devarajan et al(1994) Getting the Model Right. Chapter 3 'Cameroon Model'.

$offtext

*############### 3. PARAMETER AND VARIABLE LISTINGS #####################

$INCLUDE 2_include/anar_t_list.inc

*############### 4. SET AND DATA PARAMETER DECLARATION #####################

SETS
 sac(*)          SAM accounts

 c(sac)          commodity accounts
 cagr(c)         Agricultural commodities
 cnat(c)         Natural resource commodities
 cfd(c)          Food commodities
 cind(c)         Industrial commodities
 ccns(c)         Construction commodities
 cuti(c)         Utility commodities
 cser(c)         Service commodities
 cagg            Aggregate commodity groups

 a(sac)          activity accounts
 aagr(a)         Agricultural activities
 anat(a)         Natural resource activities
 afd(a)          Food activities
 aind(a)         Industrial activities
 acns(a)         Construction activities
 auti(a)         Utility activities
 aser(a)         Service activities
 aagg            Aggregate activity groups

 ff(sac)         Natural and aggregate factor accounts
 f(ff)           natural factor accounts
 fag(ff)         natural factor accounts
 l(f)            Labour Factors
 ls(l)           Skilled Labour Factors
 lu(l)           Unskilled Labour Factors
 k(f)            Capital Factors
 lnd(f)          Land factors

 tmr(sac)        tariff accounts
 ter(sac)        export susidy accounts
 tff(sac)        factor tax account

 h(sac)          household accounts
 g(sac)          government accounts
 i(sac)          investment accounts
 owatpmarg(sac)  Trade and transportation margin services

 w(sac)          Rest of world trade partners
 wagg            Aggregate region groups
 wgn(w)          Rest of world without Globe

 r               SAM regions
 ragg            Aggregate region groups
 rgn(r)          SAM Regions without Globe
 ref(r)          Reference region

* unemployment

 uef(f,r)        Unemployed factors by region

* Sets to control aspects of model structure

 aqx(a,r)        Activities and regions with CES fn at Level 1
 aqxn(a,r)       Activities and regions with Leontief fn at Level 1

 aleon(a)        activities with Leontief top level prodn function
 rleon(r)        regions with Leontief top level prodn function

* Declaring mapping sets

 map_w_tmr(w,tmr) Tariff mapping
 map_tmr_w(tmr,w) Tariff mapping reverse

 map_w_ter(w,ter) Export tax mapping
 map_ter_w(ter,w) Export tax mapping reverse

 map_c_w_marg(c,w,owatpmarg) Trade margin mapping of owatpmarg to ct2 and w

 map_marg_w(owatpmarg,w) Trade margin mapping of w to owatpmarg

 map_r_w(r,w)      Region to trade partner mapping
 map_w_r(w,r)      Region to trade partner mapping

 map_f_tff(f,tff) Factor taxes to factors
 map_tff_f(tff,f) Factor taxes to factors reverse

 map_aagg_a(aagg,a) Mapping from activies to aggregate activities
 map_cagg_c(cagg,c) Mapping from commodities to aggregate commodities

 map_wagg_w(wagg,w) Mapping from regions to aggregate regions
 map_ragg_r(ragg,r) Mapping from regions to aggregate regions
 

* Maps for production nesting  production nest ID across regions 

 map_va_ff(ff,a)      Mapping for arguments in Value added level nest
 map_fagg_ff(ff,ff,a) Mapping for arguments in nests below value added level

* Declaring other sets

 SACN(SAC)       SAM accounts excluding TOTAL

* Macro SAMG sets
 ss              ASAM categories
 ssn(ss)         ASAM categories excluding TOTALS

* Declaring SETS that will be assigned from the data

* Margin commodities
 ct(c,r)         trade margin commodities
 ctn(c,r)        non trade margin commodities

 ct2(c)          trade margin commodities
 ctn2(c)         non trade margin commodities

* Export commodities
 ce(c,r)         export commodities
 cen(c,r)        Non-export commodities

 cer(c,w,r)      export commodities by region
 cern(c,w,r)     Non-export commodities by region

* Import commodities
 cm(c,r)         imported commodities
 cmn(c,r)        non-imported commodities

 cmr(w,c,r)      imported commodities by region
 cmrn(w,c,r)     non-imported commodities by region

 cmrs(w,c,r)     small shares imported commodities by region
 cmrsn(w,c,r)    non-small shares imported commodities by region

 cms(c,r)        commodities with small shares

 cmrl(w,c,r)     large shares imported commodities by region
 cmrln(w,c,r)    non-large shares imported commodities by region

 cml(c,r)        commodities with large shares

* Production
 acx(a,r)        activities purchased domestically
 acxn(a,r)       activities NOT purchased domestically

 cx(c,r)         commodities produced domestically
 cxn(c,r)        commodities NOT produced domestically AND imported

 cd(c,r)         commodities produced and demanded domestically
 cdn(c,r)        commodities NOT produced and demanded domestically

 cintd(c,r)      commodities with intermediate demand by region
 cintdn(c,r)     commodities without intermediate demand by region

* Set used to control model flow

 fcons           set for parameters controlling program flow
 mcons           set for parameters controlling model content

            ;

 ALIAS(sac,sacp,sacpp), (sacn,sacnp) ;
 ALIAS(c,cp), (a,ap), (ff,ffp,ffpp), (f,fp), (l,lp), (ls,lsp), (lu,lup), (k,kp), (lnd,lndp),
      (h,hp),(tmr,tmrp), (ter,terp), (tff,tffp),
      (g,gp), (i,ip), (owatpmarg,owatpmargp),
      (w,wp), (wgn,wgnp) ;
 ALIAS(r,rp), (ref,refp) ;

*#### DECLARING PARAMETERS FOR ALL MODEL DATA

PARAMETER
 SAMG(sac,sacp,r)   the GTAP SAM database
 FACTUSE(f,a,r)     Factor use by activity

* Unemployment rates

* un_rate(r,f)       Unemployment rates

* Elasticities from Excel Workbook

 ELASTM(c,r)        Elasticities for Armington CES functions
 ELASTE(c,r)        Elasticities for CET functions

 ELASTRM(c,r)       Elasticities for Armington CES over regions Level 3
 ELASTRE(c,r)       Elasticities for CET over regions Level 3

 ELASTX(a,r)        Elasticities for CES Production function level 1
 ELASTVA(a,r)       Elasticities for CES Production function level 2
 ELASTFD(ff,a,r)    Elasticities for CES Production function level 4

 ELASTF(r,h)        Frisch parameters for LES demand system
 ELASTY(c,h,r)      Income elasticities of demand for LES demand system

* Elastcities from GTAP database via aggregation programme

 ELASTMG(c,r)       Elasticities for Armington CES functions
 ELASTRMG(c,r)      Elasticities for Armington CES over regions
 ELASTVAG(a,r)      Elasticities for CES Production function level 2

* Parameters derived from basic data and used in calibration

 IMPMARG(w,c,cp,r)  Margins of type c paid by comm'y cp on r's imports from region w

* Parameters used to control model flow

 flow_cont(fcons)   values for parameters controlling program flow
 mod_cont(mcons)    values for parameters controlling model content

* Other parameters

 samscal            SAM scaling factor
 numerchk           numeraire check value

     ;

*############### 5. SET AND DATA ASSIGNMENT #################################

* Select data set here

$INCLUDE 1_1_Model_data/anar_t_dataload.inc

*## Declaring and Assigning Sets that a fixed

SET
 ss         macroeconomic SAM sets /

 COMMDTY       Commodity accounts
 ACTIVITY      Activity accounts
 VALUAD        Value Added accounts
 HHOLDS        Household accounts
 TMTAX         Import duty accounts
 TETAX         Export tax accounts
 TFTAX         Factor tax accounts
 GOVTN         Government accounts
 KAPITAL       Kapital accounts
 MARGS         Margin accounts
 WORLD         Trade accounts
 TOTALS        Accounts totals

   / ;

 ALIAS(ss,ssp), (ssn,ssnp) ;

*## Defining SETS by exclusions from previously defined SETS

*## ASAMG Accounts excluding totals

 ssn(ss)       = YES ;
 ssn("totals") = NO ;

*## ASSIGN SUBSETS BASED ON DATA

*-- Margin commodities
 ct(c,r)$(SAMG(c,"wglo",r))          = YES ;
 ctn(c,r)                            = NOT ct(c,r) ;

 ct2(c)$(SUM(r,SAMG(c,"wglo",r)))    = YES ;
 ctn2(c)                             = NOT ct2(c) ;

*-- Export commodities
 ce(c,r)$(SUM(w, SAMG(c,w,r)) )      = YES ;
 cen(c,r)                            = NOT ce(c,r) ;

 cer(c,w,r)$(SAMG(c,w,r))            = YES ;
 cern(c,w,r)                         = NOT cer(c,w,r) ;

*-- Import commodities
 cm(c,r)$(SUM(w, SAMG(w,c,r)) )      = YES;
 cmn(c,r)                            = not cm(c,r) ;

 cmr(w,c,r)$(SAMG(w,c,r))            = YES;
 cmrn(w,c,r)                         = not cmr(w,c,r) ;

Parameter
 imprtsh(w,c,r)   import trade shares
  ;

 imprtsh(w,c,r)$(SUM(wp,SAMG(wp,c,r))) = SAMG(w,c,r)/SUM(wp,SAMG(wp,c,r)) ;

Display  imprtsh ;

 cmrs(w,c,r)$(cmr(w,c,r) AND (imprtsh(w,c,r) LT mod_cont("smimpsh")))
                                     = YES ;
 cmrsn(w,c,r)                        = NOT cmrs(w,c,r) ;

 cms(c,r)$(SUM(w,cmrs(w,c,r)))       = YES ;

 cmrl(w,c,r)$(cmr(w,c,r) AND (imprtsh(w,c,r) GE mod_cont("smimpsh")))
                                     = YES ;
 cmrln(w,c,r)                        = NOT cmrl(w,c,r) ;

 cml(c,r)$(SUM(w,cmrl(w,c,r)))       = YES ;

Display cmrs, cmrsn, cms, cmrl, cmrln, cml ;

Parameter
 cmrsCNT      Count of small shares imported commodities by region
 cmrlCNT      Count of large shares imported commodities by region
 cmrCNT       Count of activity import transactions
  ;

Set
 cmrchk(w,c,r)  ;
 cmrchk(w,c,r)$(NOT cmrs(w,c,r) and NOT cmrl(w,c,r) and NOT cmr(w,c,r)) = YES  ;

 cmrsCNT  = SUM((w,c,r)$cmrs(w,c,r), 1) ;
 cmrlCNT  = SUM((w,c,r)$cmrl(w,c,r), 1) ;
 cmrCNT   = SUM((w,c,r)$cmr(w,c,r), 1) ;

Display cmrchk, cmrsCNT, cmrlCNT, cmrCNT ;

*-- Production
 acx(a,r)$(SUM(c, SAMG(a,c,r)))      = YES ;
 acxn(a,r)                           = not acx(a,r) ;

* NB aqx(a,r) and aqxn(a,r) are assigned in dat_c_f_r.inc file

 cx(c,r)$(SUM(a, SAMG(a,c,r)))       = YES ;
 cxn(c,r)                            = not cx(c,r) ;

 cd(c,r)$(SUM(a,SAMG(a,c,r)) GT
    (SUM(w,SAMG(c,w,r)) -  SUM(w, SUM(ter$map_w_ter(w,ter), SAMG(ter,c,r)))) )
                                     = YES ;
 cdn(c,r)                            = not cd(c,r) ;

 cintd(c,r)$(SUM(a,SAMG(c,a,r)))     = YES;
 cintdn(c,r)                         = not cintd(c,r) ;

 ALIAS(ct2,ct2p) ;

* Parameters derived from basic data and used in calibration

 IMPMARG(w,ct2,c,r)      = SUM(owatpmarg$map_c_w_marg(ct2,w,owatpmarg),
                                  SAMG(owatpmarg,c,r)) ;

*######################## END OF DATA ENTRY ##############################

*##################### 6. DATA DIAGNOSTICS ###############################

$INCLUDE 2_include/anar_t_diagnost.inc

*################## 7. PARAMETER CALIBRATION #############################

$INCLUDE 2_include/anar_t_parmcalib.inc

*################## END PARAMETER CALIBRATION ############################

*################## END PARAMETER CALIBRATION ############################

*############### 8. VARIABLE DECLARATION #################################
* NOTE the default specification of variables as FREE

 Free Variables

* #### Exchange Rate Block

 ER(r)          Exchange rate (domestic per world unit)

* ######## TRADE BLOCK

* #### Exports Block

 PER(c,w,r)     Domestic price of exports of comm'y to regions and aggregates
 PE(c,r)        Domestic price of exports by commodity c
 PWE(c,w,r)     World price of exports of commodity c from region r in dollars

 PD(c,r)        Consumer price for domestic supply of commodity c

 QER(c,w,r)     Exports of comm'y c to regions and aggregates
 QE(c,r)        Domestic output exported by commodity c
 QD(c,r)        Domestic demand for commodity c

* #### Imports Block

 PMR(w,c,r)     Domestic price of imports of comm'y from regions and aggregates
 PM(c,r)        Domestic price of competitive imports of commodity c
 PML(c,r)       Dom price of imports of comm'y c from region with small shares
 PMS(c,r)       Dom price of imports of comm'y c from region with large shares
 PWM(w,c,r)     CIF price of competitive imports of commodity c from region w
 PWMFOB(w,c,r)  FOB price of competitive imports of commodity c from region w

 PT(c,r)        Price of imported transport services (same price to imports from all regions)

 QQ(c,r)        Supply of composite commodity c
 QM(c,r)        Imports of commodity c
 QML(c,r)       Supply of composite import from large share regions
 QMS(c,r)       Supply of composite import from large share regions
 QMR(w,c,r)     Imports of comm'y c from regions and aggregates

* trade margin quantity
 QT(w,c,r)      Quantity of margin services for total imports from region w

* ######## COMMODITY PRICE BLOCK

 PQS(c,r)       Supply price of composite commodity c
 PQD(c,r)       Consumer price of composite commodity c
 PQCD(c,r)      Purchaser price of composite commodity c household final demand
 PXC(c,r)       Producer price of composite domestic output

* ######## NUMERAIRE PRICE BLOCK

 CPI(r)         Consumer price index - Region numeraires
 PPI(r)         Producer (domestic) price index - Region numeraires
 ERPI           Exchange rate index - Global numeraire

* ######## PRODUCTION BLOCK

 PX(a,r)        Composite price of output by activity a

* CES aggregation functions for Level 1 of production nest

 PVA(a,r)       Value added price for activity a in r
 PINT(a,r)      Price of aggregate intermediate input

 ADX(a,r)       Shift parameter for CES production functions for QX in r
 ADXADJ(r)      Scaling Factor for Shift parameter on CES functions for QX
 DADX(r)        Partial scaling factor for Shift parameter on CES functions for QX

 QX(a,r)        Domestic production by activity a in r
 QVA(a,r)       Quantity of aggregate value added for level 1 production

* Leontief aggregation functions for Level 1 of production nest

 QINT(a,r)      Agg quantity of intermediates used by activity a in r

* CES aggregation functions for Level 2 of production nest

 ADVA(a,r)      Shift parameter for CES production functions for QVA
 ADVAADJ(r)     Scaling Factor for Shift parameter on CES functions for QVA
 DADVA(r)       Partial scaling factor for Shift parameter on CES functions for QVA

 ADFD(ff,a,r)   Shift parameter for factor and activity specific efficiency L2
 ADFDfADJ(f)    Factor Scaling Factor for flow parameter on ADFD
 ADFDaADJ(a)    Activity Scaling Factor for flow parameter on ADFD
 ADFDrADJ(r)    Region Scaling Factor for flow parameter on ADFD
 
 ADFAG(ff,a,r)  Shift parameter for factor and activity specific efficiency L3

 WF(ff,r)       Price of factor f in r
 WFDIST(ff,a,r) Sectoral proportion for factor prices in r
 WFA(ff,a,r)    Sectoral proportion for factor prices in r
 FD(ff,a,r)     Demand for factor f by activity a in r
 FS(ff,r)       Supply of factor f in r

* Intermediate Input Demand

 QINTD(c,r)     Demand for intermediate inputs by commodity in r

* Commodity Output

 QXC(c,r)       Domestic production by commodity c in r

* Activity Output


* ######## FACTOR BLOCK

 YF(f,r)        Income to factor f
 YFDIST(f,r)    Factor income for distribution after depreciation

* ######## HOUSEHOLD BLOCK
* ## Household Income

 YH(h,r)        Income to household h

* Household Expenditure

 HEXP(h,r)      Household consumption expenditure
 QCD(c,h,r)     Household consumption by commodity c

* ######## GOVERNMENT BLOCK

* #### Government Income Block

* ## Government Taxes

 MTAX(r)        Import tariff revenue
 ETAX(r)        Export tax revenue
 STAX(r)        Sales tax revenue
 VTAX(r)        Value added tax revenue
 ITAX(r)        Indirect tax revenue
 FYTAX(r)       Factor income tax revenue
 HTAX(r)        Household income tax revenue
 FTAX(r)        Factor use tax revenue

 TEADJ(r)       Export subsidy Scaling Factor
 TMADJ(r)       Tarrif rate Scaling Factor
 TSADJ(r)       Sales tax rate scaling factor
 TVADJ(r)       Value added tax rate scaling factor
 TXADJ(r)       Indirect Tax Scaling Factor
 TYFADJ(r)      Factor Income Tax Scaling Factor
 TYHADJ(r)      Income Tax Scaling Factor
 TFADJ(r)       Factor Use Tax Scaling Factor

 DTE(r)         Uniform adjustment to Export taxes
 DTM(r)         Uniform adjustment to Tariff rates
 DTS(r)         Uniform adjustment to sales tax
 DTV(r)         Uniform adjustment to value added tax
 DTX(r)         Uniform adjustment to indirect tax
 DTYF(r)        Uniform adjustment to direct tax on factors
 DTYH(r)        Uniform adjustment to direct tax on households
 DTF(r)         Uniform adjustment to factor use tax by activity

 TE(c,w,r)      Export taxes on exported comm'y c from r to w
 TM(w,c,r)      Tariff rates on imported comm'y c from w by r
 TS(c,r)        Sales tax rate
 TV(c,r)        Value added tax rate
 TX(a,r)        Indirect tax rate
 TYF(f,r)       Direct tax rate on factor income
 TYH(h,r)       Direct tax rate on households
 TF(ff,a,r)      Tax rate on factor use

* ## Government Income

 YG(r)          Government income

* #### Government Expenditure Block

 QGD(c,r)       Government consumption demand by commodity c
 QGDADJ(r)      Government consumption demand scaling factor
 EG(r)          Expenditure by government

* ######## KAPITAL BLOCK

* ## Savings Block

 SHH(h,r)       Household savings
 SADJ(r)        Savings rate scaling factor
 DSHH(r)        Partial household savings rate scaling factor
 TOTSAV(r)      Total savings

* ## Investment Block

 QINVD(c,r)     Investment demand by commodity c
 INVEST(r)      Total investment expenditure
 IADJ(r)        Investment scaling factor

* ######## MARKET CLEARING BLOCK

* ##### Account Closure

 KAPGOV(r)       Government Savings
 KAPWOR(r)       Current account balance
 KAPREG(w,r)     Bilateral current account balance

* #### Absorption Closure

 VFDOMD(r)       Value of final domestic demand
 INVESTSH(r)     Value share of investment in total final dom demand
 VGDSH(r)        Value share of Govt consump in total final dom demand

* #### GLOBE Closure


* ##### Slack

 WALRAS(r)       Slack variable for Walras's Law
 KAPWOR_SL       Slack variable for global system
 GLB_SL          Slack variable for Globe

  ;

$ontext
 If the model is correctly specified WALRAS, KAPWOR_SL and GLB_SL
 ALL equal zero. Hence the values of these slacks are important checks.
 See Devarajan et al (1994) Getting the Model Right
$offtext
*############### 9. VARIABLE INITIALISATION ##############################
$ontext
  This section initialises the values of the model variables by setting
them equal to the base values for the variables, as set in the
parameter calibration file.
$offtext

$INCLUDE 2_include/anar_t_varinit.inc

*############### 10. SOCIAL ACCOUNTING MATRIX ############################

*#### TO CHECK FOR CONSISTENCY, DISPLAY CALCULATED ASAM
$ontext
  This section checks that the model is calibrated with a balanced SAM.
  The macro SAMG is always checked but the micro SAMG would normally
only be checked when first setting up a new version.

  ASAMG1_CHK checks that the model is calibrated with a balanced SAM,
by using a Macro SAM.

  The programme aborts IF
           - ROW AND COLUMN SUMS FOR ASAMG1 NOT EQUAL
           - ALL ASAMG1 CELL ENTRIES DO NOT EQUAL ASAMG0 ENTRIES

  SAMG1_CHK checks that the model is calibrated with a balanced SAM,
by using a Micro SAM.

  The programme aborts IF
           - ALL SAMG1 CELL ENTRIES DO NOT EQUAL SAMG0 ENTRIES
$offtext

Parameter
*------ Macro SAM -----------
 ASAMG1(ss,ss,r)      Aggregate SAM for calibration check

 ASAMG1_CHK(ss,ss,r)  Ratio of ASAMG1 to ASAMG0 should be 1
 CHECK_ASAMG1(r)      Differences in Row and Column totals of ASAMG1
 DIFFASAMG1(ss,ss,r)  Differences between ASAMG and ASAMG1
 CNTASAMG1(r)         Count of non zero entries in DIFFASAMG1

*------ Micro SAM -----------
 SAMG1(sac,sacp,r)        Post calibration Global SAM

 SAMG1_CHK(sac,r)         Check on row and column totals
 CHECK_SAMG1(r)           Differences in Row and Column totals of SAMG1
 DIFFSAMG1(sac,sacp,r)    Differences between SAMG and SAMG1
 perDIFFSAMG1(sac,sacp,r) Percentage differences between SAMG and SAMG1
 CNTSAMG1(r)              Count of non zero entries in DIFFSAMG1

*------ NUMERCHK Setting for SAMG tests

 numerchk_samchk      Numeraire value for use in SAMGCHK

    ;
*------ Macro and Micro SAMG1 -----------

$SETGLOBAL ASAMG  ASAMG1
$SETGLOBAL SAMG   SAMG1

 numerchk_samchk = 1.0 ;

$INCLUDE 2_include/anar_t_samgchk.inc

$DROPGLOBAL ASAMG
$DROPGLOBAL SAMG

*############### 11. STRUCTURAL TABLES ##################################

$INCLUDE 2_include/anar_t_struct.inc

*############### 12. EQUATION DECLARATION ###############################

EQUATIONS

* ######## TRADE BLOCK

* #### Exports Block

 PEDEF(c,r)       Domestic price of exports by commodity c
 PERDEF2(c,w,r)   Domestic price of exports of comm'y to region w
 PERDEFHG(c,w,r)  Price assignment for homog export good
                  
 CET(c,r)         CET function for domestic production
 ESUPPLY(c,r)     Export supply function (FOC)
                  
 CETALT(c,r)      Special cases of the CET function
 TSHIP(c,r)       Transshipments of imports to exports no domestic production
                  
 CETLEV2(c,w,r)   Export supply to aggregate region wm level 2 of CET nest
                  
 CETREQG(c,r)     Export supply for Globe homogeneous good

* #### Imports Block

 PMDEF(c,r)       Dom price of competitive imports of commodity c
 PMLDEF(c,r)      Dom price of imports of comm'y c from region with small shares
 PMSDEF(c,r)      Dom price of imports of comm'y c from region with large shares
 PMRDEF2(w,c,r)   Dom price of imports of comm'y c from region w level 2
 PWMDEF(w,c,r)    CIF price of competitive imports of comm'y c from region w

 ARMINGTON(c,r)   Composite commodity aggregation function
 COSTMIN(c,r)     Cost minimisation for composite commodity (FOC)

 ARMALT(c,r)      Special cases of Armington

 QMSEQ(c,r)       Composite commodity aggn fn for region with small shares
 QMLEQ(c,r)       Composite commodity aggn fn for region with large shares
 QMREQ(w,c,r)     Import demand from region w with small share
 ARMLEV2(w,c,r)   Import demand from aggregate region wm level 2 of CES nest

* trade margin quantity

 QTEQ(w,c,r)     Imports transport margins to support imports from region w

* ######## COMMODITY PRICE BLOCK

 PQSDEF(c,r)     Supply price of composite commodity c
 PQDDEF(c,r)     Consumer price of composite commodity c
 PQCDDEF(c,r)    Purchaser price of composite commodity c private final demand
 PXCDEF(c,r)     Producer price for composite domestic output

* ######## NUMERAIRE PRICE BLOCK

 CPIDEF(r)       Consumer price index - Region numeraires
 PPIDEF(r)       Producer (domestic) price index - Region numeraires
 ERPIDEF         Exchange rate index - Global numeraire

* ######## PRODUCTION BLOCK

 PXDEF(a,r)      Composite price of output by activity a in region r

 WFADEF(ff,a,r)  Activity specific prices for factors ff in region r
 
* CES aggregation functions for Level 1 of production nest

 PVADEF(a,r)     Value added price for activity a in r level 1
 PINTDEF(a,r)    Agg intermed input price for activity a in r level 1

 ADXEQ(a,r)      Shift parameter for CES production functions for QX
 QXPRODFN(a,r)   Production function for QX in activity a in r level 1
 QXFOC(a,r)      FOC for production function for QX of a in r level 1

* Leontief aggregation functions for Level 1 of production nest

 QINTDEF(a,r)    Leontief intermediate aggregation for Level 1
 QVADEF(a,r)     Leontief value added aggregation for Level 1

* CES aggregation functions for Level 2 of production nest

 ADVAEQ(a,r)     Shift parameter for CES production functions for QVA
* ADFDEQ(ff,a,r)   Shift parameter for flow of factor services
 QVAPRODFN(a,r)  Production function for QVA in activity a in r level 2
 QVAFOC(ff,a,r)   FOC Production function for QVA level 2
 
* CES aggregation functions for Level 3 of production nest

* ADFAGEQ(ff,a,r)   Shift parameter for CES production functions for FD

 FDPRODFN(ff,a,r)  Production function for aggregate labour at Level 3
 FDFOC(ff,ff,a,r)  FOC for aggregate labour at Level 3


* Intermediate Input Demand

 QINTDEQ(c,r)    Intermediate input demand by commodity in region r

* Commodity Output

 COMOUT(c,r)     Domestic commodity production in region r

* Activity Output

* ######## FACTOR BLOCK

 YFEQ(f,r)       Factor incomes
 YFDISTEQ(f,r)   Factor income for distribution after depreciation

* ######## HOUSEHOLD BLOCK
* ## Household Income

 YHEQ(h,r)       Household incomes

* Household Expenditure

 HEXPEQ(h,r)     Household consumption expenditure
 QCDEQ(c,h,r)    LES Household commodity consumption

* ######## GOVERNMENT BLOCK

* #### Government Income Block

* ## Government Tax Rates

 TEDEF(c,w,r)    Export taxes on exports of comm'y c by r to w
 TMDEF(w,c,r)    Tariff rates on imports of comm'y c from w by r
 TSDEF(c,r)      Sales tax rates
 TVDEF(c,r)      Value added tax rates
 TXDEF(a,r)      Indirect tax rates
 TYFDEF(f,r)     Factor income tax rates
 TYHDEF(h,r)     Household income tax rates
 TFDEF(ff,a,r)   Factor use tax rates paid by activities

* ## Government Tax Revenues

 MTAXEQ(r)       Import tariff taxes
 ETAXEQ(r)       Export tax revenue
 STAXEQ(r)       Sales tax revenue
 VTAXEQ(r)       Value added tax revenue
 ITAXEQ(r)       Indirect taxes on activities
 FYTAXEQ(r)      Direct taxes in factor incomes
 HTAXEQ(r)       Direct taxes on household income
 FTAXEQ(r)       Factor use tax revenue

* ## Government Income

 YGEQ(r)         Government income

* #### Government Expenditure Block

 QGDEQ(c,r)      Government commodity consumption
 EGEQ(r)         Government expenditure

* ######## KAPITAL BLOCK

* ## Savings Block

 SHHDEF(h,r)     Household savings
 TOTSAVEQ(r)     Total Savings

* ## Investment Block

 QINVDEQ(c,r)    Investment demand in quantities
 INVESTEQ(r)     Investment expenditure

* ######## MARKET CLEARING BLOCK

* ##### Account Closure

* ## Factor Accounts

 FMEQUIL(f,r)    Factor market equilibrium

* ## Domestic Commodity Accounts

 QEQUIL(c,r)     Commodity market equilibrium

* ## Government Savings

 KAPGOVEQ(r)     Government equilibrium

* ## Commodity Trade Accounts

 KAPEQUIL(r)     Current account balance (foreign trade equilibrium)
 KAPEQUIL2(r)    Current account balance (foreign trade equilibrium) for globe
 KAPREQUIL(w,r)  Bilateral current account balance for non-globe regions
 KAPREQUIL2(w,r) Bilateral current account balance with globe

 TRCONP(w,c,r)   Trade consistency equation for world prices
 TRCONQ(w,c,r)   Trade consistency equation for quantities

* ## Globe and Margin Trade Accounts

 COMTRADE(c,r)   Commodity trade balance for globe transactions
 GLOBEQUIL(c,r)  Globe trade quantity consistency
 PTDEF(c,r)      Price consistency equation for globe transactions

* #### Absorption Closure

 VFDOMDEQ(r)     Value of final domestic demand
 INVESTSHEQ(r)   Value share of investment in total final dom demand
 VGDSHEQ(r)      Value share of Govt consump in total final dom demand

* ##### Slack

 WALRASEQ(r)     Savings and Investment equilibrium
 SYSEQUIL        System Walras constraint on trade flows

 ;
 

*############### 13. EQUATIONS ##########################################

* ######## TRADE BLOCK

* #### Exports Block

 PEDEF(c,r)$(ce(c,r) AND rgn(r))..
             PE(c,r) =E= SUM(w, PER(c,w,r)*QER(c,w,r) )/QE(c,r)  ;


 PE.FX(c,r)$(NOT ce(c,r))         = 0 ;

 PERDEF2(c,w,r)$cer(c,w,r)..
          PER(c,w,r) =E= PWE(c,w,r)*(1 - TE(c,w,r))*ER(r) ;

 PERDEFHG(c,w,r)$((ct2(c) AND NOT rgn(r) AND wgn(w)) )..
          PER(c,w,r) =E= PE(c,r) ;

 PER.FX(c,w,r)$(NOT cer(c,w,r))   = 0 ;

* For some c there are no exports hence only implement for ce(c)

 CET(c,r)$(cd(c,r) AND ce(c,r) AND rgn(r))..
            QXC(c,r) =E= at(c,r)*(gamma(c,r)*QE(c,r)**rhot(c,r) +
                          (1-gamma(c,r))*QD(c,r)**rhot(c,r))
                              **(1/rhot(c,r)) ;

 QD.FX(c,r)$(NOT cd(c,r))                 = 0.0 ;

 ESUPPLY(c,r)$(cd(c,r) AND ce(c,r) AND rgn(r))..
             QE(c,r) =E= QD(c,r)*((PE(c,r)/PD(c,r))*((1-gamma(c,r))
                                 /gamma(c,r)))**(1/(rhot(c,r)-1)) ;

 QE.FX(c,r)$(NOT ce(c,r))         = 0 ;

$ontext
For c with no exports, all domestic production is for domestic supply OR
for c with no domestic, sales all domestic production is for export OR
for homogeneous export - domestic good
$offtext

 CETALT(c,r)$((cd(c,r) AND cen(c,r) AND rgn(r))
               OR (cdn(c,r) AND ce(c,r) AND rgn(r)) ) ..
            QXC(c,r) =E= QD(c,r) + QE(c,r) ;

 TSHIP(c,r)$(ct2(c) and NOT rgn(r))..
             QE(c,r) =E= QM(c,r) ;

* Level 2 NEST: CET over exports to aggregate regions

 CETLEV2(c,w,r)$(cer(c,w,r) AND rgn(r) )..
        QER(c,w,r) =E= QE(c,r)* ( PER(c,w,r)
                          /( PE(c,r)*gammar(c,w,r)*atr(c,r)**rhoe(c,r)))
                            **(1/(rhoe(c,r)-1))  ;

 QER.FX(c,w,r)$(NOT cer(c,w,r))   = 0 ;

* Note, GLOBE has a homogeneous export good

 CETREQG(c,r)$(ct2(c) and NOT rgn(r))..
            QE(c,r) =E= SUM(w, QER(c,w,r)) ;

* #### Imports

 PMLDEF(c,r)$cml(c,r)..
           PML(c,r) =E= SUM(w$cmrl(w,c,r), PMR(w,c,r)*QMR(w,c,r))/QML(c,r) ;

 PML.FX(c,r)$(NOT cml(c,r))       = 0.0 ;

 PMSDEF(c,r)$cms(c,r)..
           PMS(c,r) =E= SUM(w,ioqmrqms(w,c,r)*PMR(w,c,r)) ;

 PMS.FX(c,r)$(NOT cms(c,r)) = 0.0 ;

* For some c there are no imports hence only implement for cm(c)

 PMDEF(c,r)$cm(c,r)..
    PM(c,r)*QM(c,r) =E= (PML(c,r)*QML(c,r)) + (PMS(c,r)*QMS(c,r)) ;

 PM.FX(c,r)$(NOT cm(c,r)) = 0.0 ;

 PMRDEF2(w,c,r)$cmr(w,c,r)..
         PMR(w,c,r) =E= PWM(w,c,r)*(1 + TM(w,c,r))*ER(r) ;

 PMR.FX(w,c,r)$(NOT cmr(w,c,r))   = 0.0 ;

 PWMDEF(w,c,r)$cmr(w,c,r)..
         PWM(w,c,r) =E= PWMFOB(w,c,r) +
                       SUM(cp$ct(cp,r),margcor(w,cp,c,r)*PT(cp,r)) ;

* Level 1: CES over aggregate imports and domestic good
$ontext
For some c there are no imports hence only implement for cm(c)
for some c there are no imports or domestic production
hence only implement for cx(c) AND cm(c)
$offtext

 ARMINGTON(c,r)$(cx(c,r) AND cm(c,r) and rgn(r))..
            QQ(c,r) =E= ac(c,r)*(delta(c,r)*QM(c,r)**(-rhoc(c,r))
                          + (1-delta(c,r))*QD(c,r)**(-rhoc(c,r)))
                                   **(-1/rhoc(c,r)) ;

 QM.FX(c,r)$(NOT cm(c,r)) = 0.0 ;

 COSTMIN(c,r)$(cx(c,r) AND cm(c,r)AND rgn(r))..
            QM(c,r) =E= QD(c,r)*((PD(c,r)/PM(c,r))*(delta(c,r)/
                           (1-delta(c,r))))**(1/(1+rhoc(c,r))) ;

 PD.FX(c,r)$(NOT cd(c,r) )  = 0.0 ;

* For c with no imports domestic supply equals domestic production

 ARMALT(c,r)$((cx(c,r) AND cmn(c,r) AND rgn(r))
               OR (cxn(c,r) AND cm(c,r) AND rgn(r)))..
            QQ(c,r) =E= QD(c,r) + QM(c,r) ;

* Leontief Aggregation at Level 2

 QMSEQ(c,r)$cms(c,r)..  QMS(c,r) =E= ioqmsqm(c,r) * QM(c,r) ;

 QMS.FX(c,r)$(NOT cms(c,r)) = 0.0 ;

 QMLEQ(c,r)$cml(c,r)..  QML(c,r) =E= ioqmlqm(c,r) * QM(c,r) ;

 QML.FX(c,r)$(NOT cml(c,r)) = 0.0 ;

* Leontief Aggregation at Level 3

 QMREQ(w,c,r)$cmrs(w,c,r)..  QMR(w,c,r) =E= ioqmrqms(w,c,r) * QMS(c,r) ;

* CES Aggregation at Level 3

 ARMLEV2(w,c,r)$cmrl(w,c,r)..
        QMR(w,c,r) =E= QML(c,r)*((PMR(w,c,r)*acr(c,r)**rhom(c,r))
                           /(PML(c,r)*deltar(w,c,r)))**(-1/(rhom(c,r)+1)) ;

 QMR.FX(w,c,r)$(NOT cmr(w,c,r))  = 0.0 ;

* trade margin quantity

 QTEQ(w,c,r)$(ct2(c) AND rgn(r))..
          QT(w,c,r) =E= SUM(cp, QMR(w,cp,r)*margcor(w,c,cp,r)) ;

 QT.FX(w,c,r)$ctn(c,r)  = 0.0 ;

* ######## COMMODITY PRICE BLOCK

 PQDDEF(c,r)$((cd(c,r) OR cm(c,r)) AND rgn(r))..
           PQD(c,r) =E= PQS(c,r) * (1 + TS(c,r)) ;

 PQD.FX(c,r)$(NOT cd(c,r) and NOT cm(c,r))  = 0.0;

 PQCDDEF(c,r)$(cd(c,r) OR cm(c,r) AND rgn(r))..
           PQCD(c,r) =E= PQD(c,r) * (1 + TV(c,r) ) ;

 PQCD.FX(c,r)$(NOT cd(c,r) and NOT cm(c,r)) = 0.0;

 PQSDEF(c,r)$((cd(c,r) OR cm(c,r)) AND rgn(r))..
   PQS(c,r)*QQ(c,r) =E= (PD(c,r)*QD(c,r))+(PM(c,r)*QM(c,r)) ;

 PXCDEF(c,r)$(cx(c,r) AND rgn(r))..
  PXC(c,r)*QXC(c,r) =E= (PD(c,r)*QD(c,r)) + (PE(c,r)*QE(c,r))$ce(c,r) ;

 PXC.FX(c,r)$(NOT cx(c,r))                = 0.0 ;

* ######## NUMERAIRE PRICE BLOCK

 CPIDEF(r)$rgn(r)..
             CPI(r) =E= SUM(c,comtotsh(c,r)*PQCD(c,r)) ;

 CPI.FX(g_glb)  = 0.0 ;

 PPIDEF(r)$rgn(r)..
             PPI(r) =E= SUM(c,vddtotsh(c,r)*PD(c,r)) ;

 PPI.FX(g_glb)   = 0.0 ;

 ERPIDEF..     ERPI =E= SUM(ref,tradtotsh(ref)*ER(ref)) ;

* ######## PRODUCTION BLOCK

 PXDEF(a,r)$rgn(r)..
            PX(a,r) =E= SUM(c,ioqxcqx(a,c,r)*PXC(c,r)) ;

 PX.FX(a,r)$(NOT QX0(a,r)) = 0.0 ;
 
 WFADEF(ff,a,r)$[WFDIST0(ff,a,r) and rgn(r)]..
                  WFA(ff,a,r) =E= WF(ff,r) * WFDIST(ff,a,r) ;

* CES aggregation functions for Level 1 of production nest

 PVADEF(a,r)$rgn(r)..
  PX(a,r)*[1-TX(a,r)]*QX(a,r)
                    =E= (PVA(a,r)*QVA(a,r)) + (PINT(a,r)*QINT(a,r)) ;

 PVA.FX(a,r)$(NOT QX0(a,r)) = 0.0 ;

 PINTDEF(a,r)$rgn(r)..
          PINT(a,r) =E= SUM(c,ioqint(c,a,r) * PQD(c,r)) ;

 ADXEQ(a,r)$rgn(r)..
           ADX(a,r) =E= ((adxb(a,r) + dabadx(a,r)) * ADXADJ(r))
                                      + (DADX(r) * adx01(a,r)) ;
                                      
 ADX.FX(a,g_glb)  = 1.0 ;

 QXPRODFN(a,r)$(aqx(a,r) AND rgn(r) AND QX0(a,r))..
                 QX(a,r) =E= ADX(a,r)*(deltax(a,r)*QVA(a,r)**(-rhox(a,r))
                              + (1-deltax(a,r))*QINT(a,r)**(-rhox(a,r)))
                              **(-1/rhox(a,r)) ;

 QX.FX(a,r)$(NOT QX0(a,r)) = 0.0 ;

 QXFOC(a,r)$(aqx(a,r) AND rgn(r) AND QVA0(a,r))..
                QVA(a,r) =E= QINT(a,r)*((PINT(a,r)/PVA(a,r))*(deltax(a,r)/
                               (1-deltax(a,r))))**(1/(1+rhox(a,r))) ;

 QVA.FX(a,r)$(NOT QVA0(a,r)) = 0.0 ;

* Leontief aggregation functions for Level 1 of production nest

 QINTDEF(a,r)$(aqxn(a,r) AND rgn(r) AND QINT0(a,r))..
               QINT(a,r) =E= ioqintqx(a,r) * QX(a,r) ;

 QINT.FX(a,r)$(NOT QINT0(a,r)) = 0.0 ;

 QVADEF(a,r)$(aqxn(a,r) AND rgn(r))..
                QVA(a,r) =E= ioqvaqx(a,r) * QX(a,r) ;
                
* CES aggregation functions for Level 2 of production nest

 ADVAEQ(a,r)$rgn(r).. ADVA(a,r) =E= ((advab(a,r) + dabadva(a,r)) * ADVAADJ(r))
                                      + (DADVA(r) * adva01(a,r)) ;
                                      
 ADVA.FX(a,g_glb) = 1 ;

 QVAPRODFN(a,r)$[rhova(a,r) AND rgn(r) AND SUM(ff, deltava(ff,a,r))]..
                QVA(a,r) =E= ADVA(a,r)*{SUM(ff$[map_va_ff(ff,a) AND deltava(ff,a,r)],
                              deltava(ff,a,r)
                               *(ADFD(ff,a,r)*FD(ff,a,r))**(-rhova(a,r)) )}
                                 **(-1/rhova(a,r)) ;

 QVA.FX(a,g_glb)  = 0 ;

 QVAFOC(ff,a,r)$[map_va_ff(ff,a) AND deltava(ff,a,r) AND rgn(r)]..
  WFA(ff,a,r)*(1 + TF(ff,a,r)) =E= PVA(a,r)*QVA(a,r)
                                *{SUM[ffp$deltava(ffp,a,r),deltava(ffp,a,r)
                                *[ADFD(ffp,a,r)*FD(ffp,a,r)]**(-rhova(a,r))]}**(-1)
                                *deltava(ff,a,r)*ADFD(ff,a,r)**(-rhova(a,r))
                                 *FD(ff,a,r)**(-rhova(a,r)-1) ;

$ontext
 ADFDEQ(f,a,r)$rgn(r)..
             ADFD(f,a,r) =E= ((adfdb(f,a,r) + dadfd(f,a,r))
                                  * ADFDfADJ(f) * ADFDaADJ(a) * ADFDrADJ(r)) ;

 ADFD.FX(f,a,g_glb) = 1 ;
 
$offtext
 
* CES aggregation functions for LEVEL 3 of production nest below QVA
$ontext
 ADFAGEQ(ff,a,r)$[fag(ff) and rgn(r)]..
           ADFAG(ff,a,r) =E=  {[adfagb(ff,a,r) + dadfag(ff,a,r)]
                                * [ADFAGfADJ(ff) * ADFAGaADJ(a) * ADFAGrADJ(r)]}
                                   + [dadfag_G(ff,a,r)*ADFAG_G]  ;

 ADFAG.FX(ff,a,r)$[NOT fag(ff)]  = ADFAG0(ff,a,r) ;
 
$offtext

 FDPRODFN(ff,a,r)$[SUM[ffp,map_fagg_ff(ff,ffp,a)] AND rgn(r)]..
        FD(ff,a,r) =E= ADFAG(ff,a,r)
                     *{SUM[ffp${map_fagg_ff(ff,ffp,a) AND deltafd(ff,ffp,a,r)},
                           deltafd(ff,ffp,a,r) *FD(ffp,a,r)**(-rhofd(ff,a,r))]}
                              **[-1/rhofd(ff,a,r)] ;

 FD.FX(f,a,r)$(NOT SAMG(f,a,r)) = 0.0 ;

* fix for aggregate factors
 FD.FX(ff,a,r)$(NOT FD0(ff,a,r)) = 0.0 ;

* FOC for input ffpp used to produce aggregate input ffp by activity a
* NOTE ffpp can consist of natural or aggregate factors

 FDFOC(ff,ffp,a,r)$[map_fagg_ff(ff,ffp,a) AND deltafd(ff,ffp,a,r) AND rgn(r)]..

  WFA(ffp,a,r)*[1 + TF(ffp,a,r)]
           =E= {WFA(ff,a,r) *[1 + TF(ff,a,r)] * FD(ff,a,r)}
                            *{SUM[ffpp${map_fagg_ff(ff,ffpp,a) AND deltafd(ff,ffpp,a,r)},
                               deltafd(ff,ffpp,a,r)*FD(ffpp,a,r)**(-rhofd(ff,a,r))]}
                               **(-1)*deltafd(ff,ffp,a,r)*FD(ffp,a,r)**[-rhofd(ff,a,r)-1] ;
                               
* WF.FX(ff)$fag(ff)      = WF0(ff) * mod_cont("numerchk") ;
* WF.FX(ff,r)$fag(ff)      = WF0(ff,r) ;

*############################################################################

* Intermediate Input Demand

 QINTDEQ(c,r)$(rgn(r) AND cintd(c,r))..
              QINTD(c,r) =E= SUM(a,ioqint(c,a,r)*QINT(a,r)) ;

* Commodity Output

 COMOUT(c,r)$rgn(r)..       QXC(c,r) =E= SUM(a,ioqxcqx(a,c,r)*QX(a,r)) ;

 QXC.FX(c,r)$cxn(c,r) = 0.0 ;

* Activity Output


* ######## FACTOR BLOCK

 YFEQ(f,r)$rgn(r)..      YF(f,r) =E= SUM(a,WF(f,r)*WFDIST(f,a,r)*FD(f,a,r)) ;

 YFDISTEQ(f,r)$rgn(r)..   YFDIST(f,r) =E= (YF(f,r) - (deprec(f,r)*YF(f,r)))
                                       *(1-TYF(f,r)) ;

* ######## HOUSEHOLD BLOCK
* ## Household Income

 YHEQ(h,r)$rgn(r)..        YH(h,r) =E= SUM(f, hvash(h,f,r) * YFDIST(f,r)) ;

* Household Expenditure

 HEXPEQ(h,r)$rgn(r)..    HEXP(h,r) =E= (YH(h,r) * (1-TYH(h,r)))
                                        * (1-SHH(h,r)) ;

* LES utility function

 QCDEQ(c,h,r)$rgn(r)..
  PQCD(c,r)*QCD(c,h,r) =E= (PQCD(c,r) * qcdconst(c,h,r))
                          + beta(c,h,r)
                          *(HEXP(h,r)-SUM(cp,PQCD(cp,r)*qcdconst(cp,h,r))) ;

 QCD.FX(c,h,r)$(NOT SAMG(c,h,r)) = 0.0 ;

* ######## GOVERNMENT BLOCK

* #### Government Income Block

* ## Government Tax Rates

 TEDEF(c,w,r)$cer(c,w,r)..
                     TE(c,w,r) =E= ((teb(c,w,r) + dabte(c,w,r))* TEADJ(r))
                                      + (DTE(r)*te01(c,w,r)) ;

 TE.FX(c,w,r)$(NOT cer(c,w,r))  = 0.0 ;

 TMDEF(w,c,r)$cmr(w,c,r)..
                     TM(w,c,r) =E= ((tmb(w,c,r) + dabtm(w,c,r))* TMADJ(r))
                                      + (DTM(r)*tm01(w,c,r)) ;

 TM.FX(w,c,r)$(NOT cmr(w,c,r))  = 0.0 ;

 TSDEF(c,r)$((cd(c,r) OR cm(c,r)) AND rgn(r))..
                       TS(c,r) =E= ((tsb(c,r) + dabts(c,r))* TSADJ(r))
                                      + (DTS(r)*ts01(c,r)) ;

 TS.FX(c,r)$(NOT cd(c,r) and NOT cm(c,r)) = 0.0 ;

 TVDEF(c,r)$((cd(c,r) OR cm(c,r)) AND rgn(r))..
                       TV(c,r) =E= ((tvb(c,r) + dabtv(c,r))* TVADJ(r))
                                      + (DTV(r)*tv01(c,r)) ;

 TV.FX(c,r)$(NOT cd(c,r) and NOT cm(c,r)) = 0.0 ;

 TXDEF(a,r)$rgn(r)..
                       TX(a,r) =E= ((txb(a,r) + dabtx(a,r))* TXADJ(r))
                                      + (DTX(r)*tx01(a,r)) ;

 TX.FX(a,r)$(NOT QX0(a,r))  = 0.0 ;

 TYFDEF(f,r)$rgn(r)..
                      TYF(f,r) =E= ((tyfb(f,r) + dabtyf(f,r))* TYFADJ(r))
                                      + (DTYF(r)*tyf01(f,r)) ;

 TYHDEF(h,r)$rgn(r)..
                      TYH(h,r) =E= ((tyhb(h,r) + dabtyh(h,r))* TYHADJ(r))
                                      + (DTYH(r)*tyh01(h,r)) ;

 TFDEF(f,a,r)$rgn(r)..
                     TF(f,a,r) =E= ((tfb(f,a,r) + dabtf(f,a,r))* TFADJ(r))
                                      + (DTF(r)*tf01(f,a,r)) ;

 TF.FX(fag,a,r)  = 0.0 ;

* ## Government Tax Revenues

 MTAXEQ(r)$rgn(r)..      MTAX(r) =E= SUM((c,w), TM(w,c,r)
                                        *PWM(w,c,r)*ER(r)*QMR(w,c,r)) ;

 MTAX.FX("glo")   = 0.0 ;

 ETAXEQ(r)$rgn(r)..      ETAX(r) =E= SUM((c,w), TE(c,w,r)
                                        *PWE(c,w,r)*ER(r)*QER(c,w,r)) ;

 ETAX.FX("glo")   = 0.0 ;

 STAXEQ(r)$rgn(r)..      STAX(r) =E= SUM(c,TS(c,r)*PQS(c,r)
                                      * (QINTD(c,r) + SUM(h,QCD(c,h,r))
                                      + QGD(c,r) + QINVD(c,r))) ;

 STAX.FX("glo")   = 0.0 ;

 VTAXEQ(r)$rgn(r)..      VTAX(r) =E= SUM((c,h),TV(c,r)*PQD(c,r)*QCD(c,h,r)) ;

 VTAX.FX("glo")    = 0.0 ;

 ITAXEQ(r)$rgn(r)..       ITAX(r) =E= SUM(a,TX(a,r)*PX(a,r)*QX(a,r)) ;

 ITAX.FX("glo")    = 0.0 ;

 FYTAXEQ(r)$rgn(r)..      FYTAX(r) =E= SUM(f,TYF(f,r)
                                       *(YF(f,r) - (deprec(f,r)*YF(f,r)))) ;

 FYTAX.FX("glo")   = 0.0 ;

 HTAXEQ(r)$rgn(r)..       HTAX(r) =E=  SUM(h,TYH(h,r)*YH(h,r)) ;

 HTAX.FX("glo")    = 0.0 ;

 FTAXEQ(r)$rgn(r)..       FTAX(r) =E= SUM((f,a),
                             TF(f,a,r)*WF(f,r)*WFDIST(f,a,r)*FD(f,a,r)) ;

 FTAX.FX("glo")    = 0.0 ;

* ## Government Income

 YGEQ(r)$rgn(r)..          YG(r) =E= MTAX(r) + ETAX(r)
                                   + STAX(r) + VTAX(r) + ITAX(r)
                                   + FYTAX(r) + HTAX(r) + FTAX(r) ;

* #### Government Expenditure Block

 QGDEQ(c,r)$(qgdconst(c,r) AND rgn(r))..
                         QGD(c,r) =E= QGDADJ(r) * qgdconst(c,r) ;

 QGD.FX(c,r)$(NOT qgdconst(c,r))          = 0.0 ;

 EGEQ(r)$rgn(r)..            EG(r) =E= SUM(c,QGD(c,r)*PQD(c,r)) ;

* ######## KAPITAL BLOCK

* ## Savings Block

 SHHDEF(h,r)$rgn(r)..   SHH(h,r) =E= ((shhb(h,r) + dabshh(h,r)) * SADJ(r))
                                  + (DSHH(r) * shh01(h,r)) ;
                                  
 SHH.FX(h,"glo")     = 0.0 ;

 TOTSAVEQ(r)$rgn(r)..   TOTSAV(r) =E= SUM(h,YH(h,r)*(1-TYH(h,r)) * SHH(h,r))
                                     + SUM(f,deprec(f,r)*YF(f,r))
                                     + KAPGOV(r)
                                     + (KAPWOR(r)*ER(r)) ;

 TOTSAV.FX("glo") = 0.0 ;

* ## Investment Block

 QINVDEQ(c,r)$(qinvdconst(c,r) AND rgn(r))..
                          QINVD(c,r) =E= IADJ(r)*qinvdconst(c,r) ;

 QINVD.FX(c,r)$(NOT qinvdconst(c,r)) = 0.0 ;

 INVESTEQ(r)$rgn(r)..       INVEST(r) =E= SUM(c,PQD(c,r)*QINVD(c,r)) ;

 INVEST.FX("glo") = 0.0 ;

* ######## MARKET CLEARING BLOCK

* ##### Account Closures

* ## Factor Accounts

 FMEQUIL(f,r)$rgn(r)..      FS(f,r) =E= SUM(a,FD(f,a,r)) ;

 FD.FX(f,a,r)$(NOT SAMG(f,a,r))     = 0.0 ;

* ## Domestic Commodity Accounts

 QEQUIL(c,r)$((cd(c,r) or cm(c,r)) AND rgn(r))..
               QQ(c,r) =E= QINTD(c,r) + SUM(h,QCD(c,h,r))
                           + QGD(c,r) + QINVD(c,r) ;

 QQ.FX(c,r)$(NOT cd(c,r) and NOT cm(c,r)) = 0.0 ;

* ## Government Savings

 KAPGOVEQ(r)$rgn(r)..       KAPGOV(r) =E= YG(r) - EG(r) ;

 KAPGOV.FX("glo")  = 0.0 ;

* ## Commodity Trade Accounts

 KAPREQUIL(w,r)$wgn(w)..
         KAPREG(w,r) =E= SUM(c, PWMFOB(w,c,r)*QMR(w,c,r))
                                - SUM(c, PWE(c,w,r)*QER(c,w,r)) ;

 KAPREQUIL2(w,r)$(NOT wgn(w))..
            KAPREG(w,r) =E= SUM((c,wp), PT(c,r)*QT(wp,c,r))
                                 - SUM(c,PWE(c,w,r)*QER(c,w,r)) ;

 KAPEQUIL(r)..            KAPWOR(r) =E= SUM(w, KAPREG(w,r)) ;

* ## Commodity Trade Accounts

 TRCONP(w,c,r)$cmr(w,c,r)..
             PWMFOB(w,c,r)  =E=
                  SUM((rp,wp)$(map_r_w(rp,w) and map_w_r(wp,r)),PWE(c,wp,rp)) ;

 PWMFOB.FX(w,c,r)$(NOT cmr(w,c,r))  = 0.0 ;

 TRCONQ(w,c,r)$(cmr(w,c,r) )..
             QMR(w,c,r)  =E=
                 SUM((rp,wp)$(map_r_w(rp,w) and map_w_r(wp,r)), QER(c,wp,rp)) ;

* ## Globe and Margin Trade Accounts

 COMTRADE(c,r)$(ct2(c) and not rgn(r))..
        SUM(w, PWM(w,c,r)*QMR(w,c,r)) =E=
                             SUM(w, PWE(c,w,r)*QER(c,w,r)) + GLB_SL ;

 GLOBEQUIL(c,r)$(ct2(c) AND rgn(r))..
             SUM(w, QT(w,c,r)) =E= SUM(wp$map_w_r(wp,r),  QER(c,wp,"glo")) ;

 PTDEF(c,r)$(ct2(c) AND rgn(r))..
             PT(c,r) =E= SUM(wp$map_w_r(wp,r),  PWE(c,wp,"glo")) ;

 PT.FX(c,"glo")                           = PT0(c,"glo") ;

* #### Absorption Closure

 VFDOMDEQ(r)$rgn(r)..  VFDOMD(r)  =E= SUM(c, PQCD(c,r) *  SUM[h,QCD(c,h,r)])
                           + SUM(c,PQD(c,r) * [QGD(c,r) + QINVD(c,r)]) ;

 INVESTSHEQ(r)$rgn(r)..
       INVESTSH(r) * VFDOMD(r) =E= INVEST(r) ;

 VGDSHEQ(r)$rgn(r)..
          VGDSH(r) * VFDOMD(r) =E= SUM(c,PQD(c,r) * QGD(c,r)) ;

* ##### Slack

 WALRASEQ(r)$rgn(r)..       TOTSAV(r) =E= INVEST(r) + WALRAS(r) ;

 SYSEQUIL..                 KAPWOR_SL =E= SUM(rgn, KAPWOR(rgn)) ;
 
*############### 14. MODEL CLOSURE ######################################

$ontext

The core model uses a basic balanced macroeconomic closure.

This design feature assumes that ALL closure changes are implemented
in the model experiment files

$offtext

$INCLUDE 3_close/anar_t_cl_base.inc

*############### 15. MODEL & SOLVE STATEMENTS ###########################

$ontext

limrow - number of rows for each equation block in the *.lst file (default 3)
limcol - number of columns for each equation block in the *.lst file (default 3)
iterlim - limit on iterations (default 1000)
nlp - non-linear programming
MINOS5 - MINOS5 solver
CONOPT - CONOPT Solver
CONOPT2 - CONOPT2 Solver

$offtext

 OPTION DECIMALS = 6 ;

 Options limrow=10000,limcol=0;

* option iterlim = 25000 ;

 option MCP           = PATH ;

*--- Model Definition Statements ---

 Model anar_t /

* ######## TRADE BLOCK

* #### Exports Block
 PEDEF.PE
 PERDEF2
 PERDEFHG
 CET
 ESUPPLY
 CETALT
 TSHIP
 CETLEV2
 CETREQG
* #### Imports Block
 PMDEF.PM
 PMLDEF
 PMSDEF
 PWMDEF.PWM
 PMRDEF2
 ARMINGTON
 COSTMIN
 ARMALT
 QMSEQ
 QMLEQ
 QMREQ
 ARMLEV2
* trade margin quantity
 QTEQ.QT
* ######## COMMODITY PRICE BLOCK
 PQSDEF.PQS
 PQDDEF.PQD
 PQCDDEF.PQCD
 PXCDEF.PXC
* ######## NUMERAIRE PRICE BLOCK
 CPIDEF
 PPIDEF
 ERPIDEF
* ######## PRODUCTION BLOCK
 PXDEF.PX
 WFADEF
 PVADEF
 PINTDEF
 ADXEQ
 QXPRODFN.QX
 QXFOC
 FDPRODFN
 FDFOC
 QINTDEF.QINT
 QVADEF.QVA
 ADVAEQ.ADVA
* ADFDEQ
 QVAPRODFN
 QVAFOC
 QINTDEQ.QINTD
 COMOUT.QXC
* ######## FACTOR BLOCK
 YFEQ.YF
 YFDISTEQ.YFDIST
* ######## HOUSEHOLD BLOCK
 YHEQ.YH
 HEXPEQ.HEXP
 QCDEQ.QCD
* ######## GOVERNMENT BLOCK
* ## Government Taxes
 TEDEF.TE
 TMDEF.TM
 TSDEF.TS
 TVDEF.TV
 TXDEF.TX
 TYFDEF.TYF
 TYHDEF.TYH
 TFDEF.TF
 MTAXEQ
 ETAXEQ
 STAXEQ
 VTAXEQ
 ITAXEQ
 FYTAXEQ
 HTAXEQ
 FTAXEQ
* ## Government Income
 YGEQ.YG
* #### Government Expenditure Block
 QGDEQ.QGD
 EGEQ
* ######## KAPITAL BLOCK
* ## Savings Block
 SHHDEF
 TOTSAVEQ.TOTSAV
* ## Investment Block
 QINVDEQ.QINVD
 INVESTEQ.INVEST
* ######## MARKET CLEARING BLOCK
* ##### Account Closure
 FMEQUIL
 QEQUIL.QQ
 KAPGOVEQ
 KAPEQUIL
 KAPREQUIL
 KAPREQUIL2
 COMTRADE
 TRCONP
 TRCONQ
 GLOBEQUIL
 PTDEF
* #### Absorption Closure
 VFDOMDEQ
 INVESTSHEQ
 VGDSHEQ
* ##### Slack
 WALRASEQ.WALRAS
 SYSEQUIL
             / ;

*--- Model Conditioning Statements ---
$ontext
    Various arguments for selected variables in the model are fixed when
 they can only take ZERO values,
  i.e., fixed using *.FX(*,*,*) and/or *.FX(*,*,*)$(**)
    The conditions that constrain these variables are linked to the equations
 that determine the values those variables.
$offtext

  anar_t.HOLDFIXED = 1 ;
  anar_t.TOLINFREP = 0.001 ;

Solve anar_t Using MCP ;

*############### 16. SOCIAL ACCOUNTING MATRIX ###########################

*#### TO CHECK FOR CONSISTENCY, DISPLAY CALCULATED ASAM
$ontext
  This section checks that the model solution produces a balanced SAM.
  The macro SAMG is always checked but the micro SAMG would normally
only be checked when first setting up a new version.

  glb_t_asamg2.inc checks that the model is calibrated with a balanced SAM,
by using a Macro SAM.

  The programme aborts IF
           - ROW AND COLUMN SUMS FOR ASAMG1 NOT EQUAL
           - ALL ASAMG2 CELL ENTRIES DO NOT EQUAL ASAMG1 ENTRIES

  glb1_samg2.inc checks that the model is calibrated with a balanced SAM,
by using a Micro SAM.

  The programme aborts IF
           - ALL SAMG2 CELL ENTRIES DO NOT EQUAL SAMG1 ENTRIES
$offtext

*------ Micro SAM -----------
Parameter

*------ Macro SAM -----------
 ASAMG2(ss,ss,r)      Aggregate SAM for base run check

 ASAMG2_CHK(ss,ss,r)  Ratio of ASAMG2 to ASAMG0 should be 1
 CHECK_ASAMG2(r)      Differences in Row and Column totals of ASAMG2
 DIFFASAMG2(ss,ss,r)  Differences between ASAMG1 and ASAMG2
 CNTASAMG2(r)         Count of non zero entries in DIFFASAMG2

*------ Micro SAM -----------
 SAMG2(sac,sacp,r)        Post calibration Global SAM

 SAMG2_CHK(sac,r)         Check on row and column totals
 CHECK_SAMG2(r)           Differences in Row and Column totals of SAMG2
 DIFFSAMG2(sac,sacp,r)    Differences between SAMG0 and SAMG2
 perDIFFSAMG2(sac,sacp,r) Percentage differences between SAMG0 and SAMG2
 CNTSAMG2(r)              Count of non zero entries in DIFFSAMG2

    ;

*------ Macro and Micro SAMG2 -----------

$SETGLOBAL ASAMG  ASAMG2
$SETGLOBAL SAMG   SAMG2

 numerchk_samchk = numerchk ;

$INCLUDE  2_include/anar_t_samgchk.inc

$DROPGLOBAL ASAMG
$DROPGLOBAL SAMG

*############### 17. POLICY EXPERIMENTS ##################################
*$ontext
*#### SETTINGS FOR EXPERIMENT AND RESULTS FILES
* Set dimensions for the results analysis files

$SETGLOBAL res_dimen      sim

* Set experiment name for results

$SETGLOBAL expt_res       trade

* Set experiment data

$SETGLOBAL expt_data      data_anar_t_expt_G1_2_sol

* Set experiment File

$INCLUDE 4_expts/anar_t_expt_G1_2_sol.inc

*$offText

*##################### 18. RESULTS ANALYSES FILE #########################

$ontext
The various files for the analysis of results can be called here or by using
programme analyse.gms to carry out the same actions using results stored
in GDX

EACH COMPONENT IS INDEPENDENT, i.e., each component only makes use of the
levels results that are generated in the experiment INCLUDE file.

Hence only the modules that generate results of the required
characteristics needs to be run. The choice of which module is run is
controlled by setting the appropriate 1/0 elements in the flow_cont
parameter in the worksheet 'controls'. Each module writes out the results
to a GDX file with a default name - these names can be changed in the
INCLUDE files.

If the analyses are conducted using analyse.gms then the levels results
that are produced by the simulations module must be written out to GDX.
analyse.gms uses these results plus the file moddat0.gdx to carry out the
analyses.

$offtext

$ontext 
$INCLUDE 5_analysis\anar_t_anal.inc

$offText

*##################### THE END #########################
