$TITLE Aggregation Programme for GLOBE Database for ANARRES_t Mode
$OFFUPPER
$ONEMPTY

*$onsymlist

*################ GENERAL INFORMATION ####################################
$ontext

This programme is for aggregtion of a special version of the GLOBE 1 database

This is a version was developed by Scott McDonald (cgemod)

         Scott McDonald                 
         cgemod
         14 Moncrieffe Road,
         Sheffield, S7 1HR
         email:                         
         jrs.mcdonald@gmail.com         
         scott@cgemod.org.uk            

Copyright (c) 2019 Scott McDonald

  This version has been developed for use on the Global CGE
Modelling Course offered by cgemod.

* This version last revised Jan 2019

$offtext
*##################### CODE DEVELOPMENT NOTES ###########################
$ontext


$offtext
*###################### ASSIGN DATA FILES #############################

* Data file for sets and aggregation

$SETGLOBAL  agg_schem     data_samagg_anar_t_8_12_5_9

* Aggregated Data output GDX File

$SETGLOBAL  data_out      data_anar_t_12_5_9

*###################### SET DECLARATION #############################


* read in sets for base data

SETS
* Sets for the UNAGGREGATED database SAM_anar_t_8

 s              SAM accounts

 cc(s)          Composite Commodities
 aa(s)          Activities
 ff(s)          Factors

 tmmtax(s)      Trade taxes
 teetax(s)      Export taxes
 fftax(s)       Taxes on Factors

 otppmarg(s)    All trade and transport costs
 ww(s)          Rest of the World

 ii(s)          Investment

 kk             Regions

* Declaring SETS that will be assigned from the data


* Declaring other sets

 sn(s)         SAM accounts excluding total
*      row(ss)         SAM accounts excluding TOTAL

* Sets for the AGGREGATED database

 sac              SAM accounts

 c(sac)          Composite Commodities
 a(sac)          Activities
 f(sac)          Factors
 h(sac)          Household
 g(sac)          Government accounts

 tmr(sac)        Trade taxes
 ter(sac)        Export taxes
 tff(sac)        Taxes on Factors

 owatpmarg(sac)  All trade and transport costs
 w(sac)          Rest of the World

 i(sac)          Investment

 r               Regions

 rn(r)           Regions excluding GLOBE

* Declaring other sets

 sacn(sac)         SAM accounts excluding total

* Mapping settings

 map_sac_s(sac,s)    Mapping to sac from s
 map_r_kk(r,kk)      Mapping to r from k

  ;

* Setting up ALIASES

ALIAS (sac,sacp), (sacn,sacnp),
      (cc,ccp), (aa,aap), (ff,ffp),
      (tmmtax,tmmtaxp), (teetax,teetaxp), (fftax,fftaxp),
      (otppmarg,otppmargp),
      (ww,wwp), (kk,kkp)
  ;

ALIAS (s,sp), (sn,snp),
      (c,cp), (a,ap), (f,fp),
      (tmr,tmrp), (ter,terp), (tff,tffp),
      (owatpmarg,owatpmargp),
      (w,wp), (r,rp), (rn,rnp)
  ;

SET
 sm         macroeconomic SAM sets /

 COMMDTY       Commodity accounts
 ACTIVITY      Activity accounts
 VALUAD        Value Added accounts
 HHOLDS        Household accounts
 TMTAX         Import duty accounts
 TETAX         Export tax accounts
 TFTAX         Factor tax accounts
 GOVTN         Government accounts
 KAPITAL       Kapital accounts
 MARGS         Margin accounts
 WORLD         Trade accounts
 TOTALS        Accounts totals

   /

 smn(sm)       ASAMG categories excluding TOTALS

 ;

*## ASAMG Accounts excluding totals
 smn(sm)       = YES ;
 smn("totals") = NO ;

 ALIAS(sm,smp), (smn,smnp) ;


Parameters

*##### Base Data

* Transactions
 SAM_anar_t_8(s,s,kk)     UNAggregate SAM for regions k

* Elasticities from GTAP using Region specific weights
$ontext
  The GTAP model and GTAPPAGG uses global weights so the elasticities
are identical for ALL regions, i.e., they are not indexed on r
$offtext
 ESUBD2(s,kk)        LOADED Armington CES for domestic_imported allocation
 ESUBM2(s,kk)        LOADED Armington CES for regional allocation of imports
 ESUBVA2(s,kk)       LOADED CES between primary factors in production

* Other data

 fsk(kk)             UNAggregated capital stocks
 pop(kk)             UNAggregated  population stocks

*##### Aggregated data
* Transactions
 SAMG(sac,sac,r)     Aggregate SAM derived

* Checks on AGGREGATED SAM
 SAMGCHK(sac,r)      Check on account totals parameter by region
 CNTSAMG(r)          Count of differences in account totals by region

* Checks that MAKE Matrix is diagonal
 CHK_MAKE_c(sac,r)   Check on commodities in MAKE
 CHK_MAKE_a(sac,r)   Check on activities in MAKE

* ---- Checks on Mappings
* Checks that BEFORE and AFTER MACRO SAMs are identical
 ASAMG_in(sm,sm,kk)  Macro SAM loaded
 ASAMG_out(sm,sm,r)  Macro SAM loaded


* Checks that each s and kk are only mapped to one sac and r
 chk_map_s(s)        Checking on mapping to sac from s
 chk_map_kk(kk)      Checking on mapping to r from kk


* Elasticities
 ESUBD(sac,r)        MODEL Armington CES for domestic_imported allocation
 ESUBM(sac,r)        MODEL Armington CES for regional allocation of imports
 ESUBVA(sac,r)       MODEL CES between primary factors in production

* Other data

 FS_K(r)             Aggregated capital stocks
 popn(r)             Aggregated  population stocks

  ;

*############### 5. SET AND DATA ASSIGNMENT #################################


*#### 1. DATA  ENTRY SECTION ########

*---- 1a. Excel workbook sets and data converted to gdx here

* Convert Excel workbook data to GDX here

$CALL "GDXXRW i=Agg_sets\%agg_schem%.xlsx o=Agg_sets\data_in.gdx INDEX=LAYOUT!A4 trace=3"
$if errorLevel 1 $abort problems with GDXXRW

*---- 1b. All sets from excel are assigned here

$GDXIN Agg_sets\data_in.GDX

* LOAD sets AGGREGATED database
$LOADdc sac
$LOADdc c a f h g tmr ter tff owatpmarg w i
$LOADdc r

* LOAD for UNAGGREGATED database
$LOADdc s
$LOADdc cc aa ff tmmtax teetax fftax otppmarg ww
$LOADdc kk

* LOAD Mapping settings

$LOADdc map_sac_s
$LOADdc map_r_kk

$GDXIN

*---- 1c. All transactions and elasticity from database are assigned here
$ontext
 Read in GTAP data and elasticities from GDX file. Data are read for
all regions as SAMG. In SAMG(*,*,*), the third index refers to the
country SAM.
 In the GLB_t model, parameters, variables, and eqn. the order of the
indices is based on the SAM for each region the third index
identifying the 'region'.

$offtext

* Data are read in from a *.gdx file

$GDXIN G_data\sam_anar_t_proj_v8.gdx

$LOADdc SAM_anar_t_8 = SAM_GLB_t_8
$LOADdc ESUBD2 ESUBM2 ESUBVA2

$GDXIN

*## SAMG Accounts excluding totals
 sn(s)          = YES ;
 sn("total")    = NO ;

 sacn(sac)      = YES ;
 sacn("total")  = NO ;

 rn(r)          = YES ;
 rn("glo")      = NO ;


*######################## END OF DATA ENTRY ##############################

*################### Testing Aggregation Mapping #########################

*--- Checks that BEFORE and AFTER MACRO SAMs are identical

* Calculate Macro SAMG for inout SAMG

 ASAMG_in("COMMDTY","ACTIVITY",kk) = SUM((cc,aa),SAM_anar_t_8(cc,aa,kk)) ;
 ASAMG_in("COMMDTY","HHOLDS",kk)   = SUM(cc,SAM_anar_t_8(cc,"hous",kk)) ;
 ASAMG_in("COMMDTY","GOVTN",kk)    = SUM(cc,SAM_anar_t_8(cc,"govt",kk)) ;
 ASAMG_in("COMMDTY","KAPITAL",kk)  = SUM(cc,SAM_anar_t_8(cc,"i_s",kk)) ;
 ASAMG_in("COMMDTY","WORLD",kk)    = SUM((cc,ww),SAM_anar_t_8(cc,ww,kk)) ;

 ASAMG_in("ACTIVITY","COMMDTY",kk) = SUM((aa,cc),SAM_anar_t_8(aa,cc,kk)) ;

 ASAMG_in("VALUAD","ACTIVITY",kk)  = SUM((ff,aa),SAM_anar_t_8(ff,aa,kk)) ;

 ASAMG_in("HHOLDS","VALUAD",kk)    = SUM(ff,SAM_anar_t_8("hous",ff,kk)) ;

 ASAMG_in("TMTAX","COMMDTY",kk)    = SUM((tmmtax,cc),SAM_anar_t_8(tmmtax,cc,kk)) ;
 ASAMG_in("TETAX","COMMDTY",kk)    = SUM((teetax,cc),SAM_anar_t_8(teetax,cc,kk)) ;
 ASAMG_in("TFTAX","ACTIVITY",kk)   = SUM((fftax,aa),SAM_anar_t_8(fftax,aa,kk)) ;

 ASAMG_in("GOVTN","COMMDTY",kk)    = SUM(cc,SAM_anar_t_8("govt",cc,kk)) ;
 ASAMG_in("GOVTN","ACTIVITY",kk)   = SUM(aa,SAM_anar_t_8("govt",aa,kk)) ;
 ASAMG_in("GOVTN","VALUAD",kk)     = SUM(ff,SAM_anar_t_8("govt",ff,kk)) ;
 ASAMG_in("GOVTN","HHOLDS",kk)     = SAM_anar_t_8("govt","hous",kk) ;
 ASAMG_in("GOVTN","TMTAX",kk)      = SUM(tmmtax,SAM_anar_t_8("govt",tmmtax,kk)) ;
 ASAMG_in("GOVTN","TETAX",kk)      = SUM(teetax,SAM_anar_t_8("govt",teetax,kk)) ;
 ASAMG_in("GOVTN","TFTAX",kk)      = SUM(fftax,SAM_anar_t_8("govt",fftax,kk)) ;

 ASAMG_in("KAPITAL","VALUAD",kk)   = SUM(ff,SAM_anar_t_8("i_s",ff,kk)) ;
 ASAMG_in("KAPITAL","HHOLDS",kk)   = SAM_anar_t_8("i_s","hous",kk) ;
 ASAMG_in("KAPITAL","GOVTN",kk)    = SAM_anar_t_8("i_s","govt",kk) ;
 ASAMG_in("KAPITAL","WORLD",kk)    = SUM(ww,SAM_anar_t_8("i_s",ww,kk)) ;

 ASAMG_in("MARGS","COMMDTY",kk)    = SUM((otppmarg,cc),SAM_anar_t_8(otppmarg,cc,kk)) ;

 ASAMG_in("WORLD","COMMDTY",kk)    = SUM((ww,cc),SAM_anar_t_8(ww,cc,kk)) ;

 ASAMG_in("WORLD","MARGS",kk)      = SUM((ww,otppmarg),SAM_anar_t_8(ww,otppmarg,kk)) ;

 ASAMG_in("TOTALS",smnp,kk)        = SUM(smn,ASAMG_in(smn,smnp,kk)) ;
 ASAMG_in(smn,"TOTALS",kk)         = SUM(smnp,ASAMG_in(smn,smnp,kk)) ;


*-------- Checking that a balanced and equal ASAMG is produced
PARAMETER

 ASAMG_inCHK(kk)       Differences in Row and Column totals of ASAMG_in

 ;

 ASAMG_inCHK(kk) = SUM(smn,((ASAMG_in(smn,"totals",kk)
                           - ASAMG_in("totals",smn,kk)))) ;

 OPTION decimals = 6 ;

Display ASAMG_inCHK ;

 ABORT $(SUM(kk,ASAMG_inCHK(kk) GT 0.000005))
         "ASAMG_in: ROW AND COLUMN SUMS FOR ASAMG_in NOT EQUAL" ;

* Checks that each s and kk are only mapped to one sac and r

 chk_map_s(s)     = SUM[sac$map_sac_s(sac,s), 1] ;
 loop(s,
  ABORT$(chk_map_s(s) gt 1)
   "## Error in map_sac_s. Account allocated to more than one aggregate ##",
   map_sac_s ;
*End loop
 ) ;

 chk_map_kk(kk)   = SUM[r$map_r_kk(r,kk), 1] ;
 loop(kk,
  ABORT$(chk_map_kk(kk) gt 1)
   "## Error in chk_map_kk. Account allocated to more than one aggregate ##",
   chk_map_kk ;
*End loop
 ) ;


*################### SAM AGGREGATION ############################

*---------- AGGREGATION ASSIGNMENT -----------------------------

 SAMG(sac,sacp,r)   = SUM((s,sp,kk)
                          $(map_sac_s(sac,s)
                          $map_sac_s(sacp,sp)
                          $map_r_kk(r,kk)),
                          SAM_anar_t_8(s,sp,kk)) ;



* -------- Account Totals -------------

 SAMG("total",sacnp,r)        = SUM(sacn,SAMG(sacn,sacnp,r)) ;
 SAMG(sacn,"total",r)         = SUM(sacnp,SAMG(sacn,sacnp,r)) ;

*#### Rounding the New SAM to 6 Decimal Places
* The GTAP database only records data to 6 decimal places

 SAMG(sac,sacp,r)      = ROUND( SAMG(sac,sacp,r),6) ;

* -------- Checks on SAMG2 ------------

 SAMGCHK(sac,r) = (ABS(SAMG(sac,"total",r)-SAMG("total",sac,r))) ;

 SAMGCHK(sac,r)$(ABS(SAMGCHK(sac,r) lt 0.000000000))  = 0.0 ;

 CNTSAMG(r)  = SUM((sac)$SAMGCHK(sac,r), 1) ;

Display SAMGCHK, CNTSAMG ;

 ABORT$(SUM(r,CNTSAMG(r) GT 0.0))
         "ALL ROW AND COLUMN TOTALS NOT EQUAL" ;

* Calculate Macro SAMG for inout SAMG

* ASAMG_out(sm,sm,r)  Macro SAM loaded

 ASAMG_out("COMMDTY","ACTIVITY",r) = SUM((c,a),SAMG(c,a,r)) ;
 ASAMG_out("COMMDTY","HHOLDS",r)   = SUM(c,SAMG(c,"hous",r)) ;
 ASAMG_out("COMMDTY","GOVTN",r)    = SUM(c,SAMG(c,"govt",r)) ;
 ASAMG_out("COMMDTY","KAPITAL",r)  = SUM(c,SAMG(c,"i_s",r)) ;
 ASAMG_out("COMMDTY","WORLD",r)    = SUM((c,w),SAMG(c,w,r)) ;

 ASAMG_out("ACTIVITY","COMMDTY",r) = SUM((a,c),SAMG(a,c,r)) ;

 ASAMG_out("VALUAD","ACTIVITY",r)  = SUM((f,a),SAMG(f,a,r)) ;

 ASAMG_out("HHOLDS","VALUAD",r)    = SUM(f,SAMG("hous",f,r)) ;

 ASAMG_out("TMTAX","COMMDTY",r)    = SUM((tmr,c),SAMG(tmr,c,r)) ;
 ASAMG_out("TETAX","COMMDTY",r)    = SUM((ter,c),SAMG(ter,c,r)) ;
 ASAMG_out("TFTAX","ACTIVITY",r)   = SUM((tff,a),SAMG(tff,a,r)) ;

 ASAMG_out("GOVTN","COMMDTY",r)    = SUM(c,SAMG("govt",c,r)) ;
 ASAMG_out("GOVTN","ACTIVITY",r)   = SUM(a,SAMG("govt",a,r)) ;
 ASAMG_out("GOVTN","VALUAD",r)     = SUM(f,SAMG("govt",f,r)) ;
 ASAMG_out("GOVTN","HHOLDS",r)     = SAMG("govt","hous",r) ;
 ASAMG_out("GOVTN","TMTAX",r)      = SUM(tmr,SAMG("govt",tmr,r)) ;
 ASAMG_out("GOVTN","TETAX",r)      = SUM(ter,SAMG("govt",ter,r)) ;
 ASAMG_out("GOVTN","TFTAX",r)      = SUM(tff,SAMG("govt",tff,r)) ;

 ASAMG_out("KAPITAL","VALUAD",r)   = SUM(f,SAMG("i_s",f,r)) ;
 ASAMG_out("KAPITAL","HHOLDS",r)   = SAMG("i_s","hous",r) ;
 ASAMG_out("KAPITAL","GOVTN",r)    = SAMG("i_s","govt",r) ;
 ASAMG_out("KAPITAL","WORLD",r)    = SUM(w,SAMG("i_s",w,r)) ;

 ASAMG_out("MARGS","COMMDTY",r)    = SUM((owatpmarg,c),SAMG(owatpmarg,c,r)) ;

 ASAMG_out("WORLD","COMMDTY",r)    = SUM((w,c),SAMG(w,c,r)) ;

 ASAMG_out("WORLD","MARGS",r)      = SUM((w,owatpmarg),SAMG(w,owatpmarg,r)) ;

 ASAMG_out("TOTALS",smnp,r)        = SUM(smn,ASAMG_out(smn,smnp,r)) ;
 ASAMG_out(smn,"TOTALS",r)         = SUM(smnp,ASAMG_out(smn,smnp,r)) ;

*-------- Checking that a balanced and equal ASAMG is produced
PARAMETER

 ASAMG_outCHK(r)       Differences in Row and Column totals of ASAMG_in
 CNTASAMG1(r)          Count of non zero entries in DIFFASAMG1

 ;

 ASAMG_outCHK(r) = SUM(smn,((ASAMG_out(smn,"totals",r)
                           - ASAMG_out("totals",smn,r)))) ;

 OPTION decimals = 6 ;

Display ASAMG_outCHK ;

 ABORT $(SUM(r,ASAMG_outCHK(r) GT 0.000005))
         "ASAMG_out: ROW AND COLUMN SUMS FOR ASAMG_out NOT EQUAL" ;

*--- Checks that BEFORE and AFTER MACRO SAMs are identical

PARAMETER

 ASAMG_diff(sm,sm,r)   Differences between ASAMG_in and ASAMG_out
 CNTASAMG_diff(r)      Count of Differences between ASAMG_in and ASAMG_out

 ;

 ASAMG_diff(sm,smp,r)  =  ASAMG_out(sm,smp,r)
                           - SUM[kk$map_r_kk(r,kk),ASAMG_in(sm,smp,kk)] ;


 ASAMG_diff(sm,smp,r)$(ABS( ASAMG_diff(sm,smp,r) lt 0.0000000 )) = 0.0 ;

 ASAMG_diff(sm,smp,r)   = 0.0 ;

 CNTASAMG_diff(r)  = SUM((smn,smnp)$ASAMG_diff(smn,smnp,r), 1) ;

 OPTION decimals = 6 ;

Display CNTASAMG_diff ;

 ABORT$(SUM(r,CNTASAMG_diff(r) GT 0.0))
         "ALL ASAMG_in CELL ENTRIES DO NOT EQUAL ASAMG_out ENTRIES" ;

* ------ Checks that MAKE Matrix is diagonal

* MAKE matrix checked as diagonal by commodities and activities
$ontext
 This checks works by
  For CHK_MAKE_c and CHK_MAKE_a
 1. counting the number of non zero elements in row and column of the
      MAKE matrix for all regions bar GLOBE
 2. dividing the count by the number elements in set c or a
 3. subtracting ONE

  Then aborting if CHK_MAKE_c OR CHK_MAKE_a NOT EQUAL to zero

$offtext

 CHK_MAKE_c(c,rn)    = [SUM(ap$SAMG(c,ap,rn), 1)
                       /{SUM[cp$SUM((a,rnp),SAMG(cp,a,rnp)), 1]}] - 1.00 ;

 CHK_MAKE_a(a,rn)    = [SUM(cp$SAMG(cp,a,rn), 1)
                      /{SUM[ap$SUM((c,rnp),SAMG(c,ap,rnp)), 1]}] - 1.00 ;

 ABORT$(SUM((c,rn),CHK_MAKE_c(c,rn) NE 0.0))
         "MAKE matrix not square by commodities" ;

 ABORT$(SUM((a,rn),CHK_MAKE_a(a,rn) NE 0.0))
         "MAKE matrix not square by activities" ;

*#################### ELASTICITIES ####################
*$ontext
SET
      kk2(kk)         SET KK less glo
       r2(r)           SET r less glo

 ;

 kk2(kk)        = YES ;
 kk2("glo")     = NO ;

 r2(r)          = YES ;
 r2("glo")      = NO ;

*$offtext
Sets
* Mapping sets for elasticities

 map_ww_tmmtax(ww,tmmtax)   mapping to ww from tmr /

   #ww:#tmmtax
  /

 map_ww_otppmarg(ww,otppmarg)   mapping to ww from otppmarg /

   #ww:#otppmarg
  /

 map_ff_fftax(ff,fftax)    mapping to ff from fftax /
   #ff:#fftax
  /

 ;


PARAMETER

* Aggregtation values for weighting elastcities

 TOTSUPP(s,kk)      total supply at BP

 IMPSUPP(s,kk)      import supply at BP

 FACTDEM(s,kk)      factor demand inclusinve of factir use taxes

   ;

*##### ESUBD
* Weights on ESUBD

 TOTSUPP(cc,kk) = [SUM(aa,SAM_anar_t_8(aa,cc,kk))]  +
                  {SUM(ww, [SAM_anar_t_8(ww,cc,kk)
                      + SUM(tmmtax$map_ww_tmmtax(ww,tmmtax),
                          SAM_anar_t_8(tmmtax,cc,kk))
                      + SUM(otppmarg$map_ww_otppmarg(ww,otppmarg),
                          SAM_anar_t_8(otppmarg,cc,kk))])} ;

 ESUBD(c,r)$r2(r)  = [SUM{kk$map_r_kk(r,kk),(SUM[cc$map_sac_s(c,cc),
                                      {TOTSUPP(cc,kk) * ESUBD2(cc,kk)}])}]
                          /(SUM{kk$map_r_kk(r,kk),
                              (SUM[cc$map_sac_s(c,cc),TOTSUPP(cc,kk)])}) ;

*##### ESUBM
* Weights on ESUBM

 IMPSUPP(cc,kk) = {SUM(ww, [SAM_anar_t_8(ww,cc,kk)
                      + SUM(tmmtax$map_ww_tmmtax(ww,tmmtax),
                          SAM_anar_t_8(tmmtax,cc,kk))
                      + SUM(otppmarg$map_ww_otppmarg(ww,otppmarg),
                          SAM_anar_t_8(otppmarg,cc,kk))])} ;

 ESUBM(c,r)$r2(r)  = [SUM{kk$map_r_kk(r,kk),(SUM[cc$map_sac_s(c, cc),
                                      {IMPSUPP(cc,kk) * ESUBM2(cc,kk)}])}]
                          /(SUM{kk$map_r_kk(r,kk),
                              (SUM[cc$map_sac_s(c,cc),IMPSUPP(cc,kk)])}) ;



*##### ESUBVA
* Weights on ESUBVA

 FACTDEM(aa,kk)  = SUM{ff,[SAM_anar_t_8(ff,aa,kk) +
                      SUM(fftax$map_ff_fftax(ff,fftax),SAM_anar_t_8(fftax,aa,kk))]} ;

 ESUBVA(a,r)$r2(r)  = [SUM{kk$map_r_kk(r,kk),(SUM[aa$map_sac_s(a,aa),
                                      {FACTDEM(aa,kk) * ESUBVA2(aa,kk)}])}]
                          /(SUM{kk$map_r_kk(r,kk),
                              (SUM[aa$map_sac_s(a,aa),FACTDEM(aa,kk)])}) ;
                              
*#################### CAPITAL STOCK DATA ####################

* Loading parameters

$GDXIN G_data\sam_anar_t_proj_v8.gdx

$LOAD fsk

$GDXIN


 FS_K(r)       = SUM(kk$map_r_kk(r,kk), fsk(kk)) ;

*#################### POPULATION DATA ####################

* Loading parameters

$GDXIN G_data\sam_anar_t_proj_v8.gdx

$LOAD pop

$GDXIN

 popn(r)       = SUM(kk$map_r_kk(r,kk), pop(kk)) ;
 
*#################### DATA PREPARATION FOR EXPORT ####################

* ~~~~ Elasticities

Parameter
 elastm(c,r)       Aggregate Import elasticities
 elastrm(c,r)      Regional Import elasticities
 
 elaste(c,r)       Aggregate Export elasticities
 elastre(c,r)      Regional Export elasticities
 
 elastx(a,r)       Activity QX elasticities
 elastva(a,r)      Activity QVA elasticities
 
 frisch(r,h)       Frisch parameters
 elasty(c,h,r)     Income elasticities of demand
 
 ;
 
 elastm(c,r)      = ESUBD(c,r) ;
 elastrm(c,r)     = ESUBM(c,r) ;
                  
 elaste(c,r)      = ESUBD(c,r) ;
 elastre(c,r)     = ESUBM(c,r) ;
                  
 elastx(a,r)      = ESUBVA(a,r) * 0.75 ;
 elastva(a,r)     = ESUBVA(a,r) ;
                  
 frisch(r,h)      = -1.00 ;
 elasty(c,h,r)    = 1.00 ;
 
* ~~~~ Margin Commodities

Set
 ct2(c)     Margin commodities
 wagg       Aggregate regions
 ragg       Aggregate regions
 
  ;

 ct2(c)$(SUM(r,SAMG(c,"wglo",r)))    = YES ;
  
* ~~~~ Mapping Sets

*#################### EXPORT OF RESULT FILES ####################

*#######  Export new aggregation to GDX ###################

*## Writing out the NEW SAMs to GDX

* This writes all the SAM data to GDX

* NB THE COMMON COMPONENT AT THE BOTTOM TO UNLOAD SETS TO GDX

Execute_Unload  'output\%data_out%.gdx',
* Aggregate SAM
SAMG
* Aggregated GTAP Elasticities
ESUBD
ESUBM
ESUBVA
* Aggregate capital stocks
FS_K
* Aggregated populations
popn
* common instruction for unloading sets to GDX
sac
c
ct2
a
f
h

tmr
ter
tff
g
i
w
owatpmarg
r

* Additional data

elastm
elastrm     
elaste
elastre
elastx    
elastva   
frisch    
elasty    

  ;
  
  
*#################### EXPORT DATA FOR MODEL EXCEL ####################

* Writing out the sets
* SAM set
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=sac Rng=sets!A5 rdim=1"
* region set                              
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=sets!D5 rdim=1"
                                          
* reference set                           
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=sets!G5 rdim=1"
                                          
* SAM major sub sets
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=c Rng=sets!I5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=a Rng=sets!R5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=f Rng=sets!AA5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=h Rng=sets!AG5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=tmr Rng=sets!AH5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=ter Rng=sets!AI5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=tff Rng=sets!AJ5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=g Rng=sets!AK5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=i Rng=sets!AL5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=owatpmarg Rng=sets!AM5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=sets!AN5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=sets!AO5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=sets!AP5 rdim=1"

* Mapping set write out
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!A5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=tmr Rng=maps!B5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!E5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=tmr Rng=maps!D5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!G5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=ter Rng=maps!H5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=ter Rng=maps!J5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!K5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=maps!M5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!N5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!P5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=maps!Q5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=f Rng=maps!S5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=tff Rng=maps!T5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=tff Rng=maps!V5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=f Rng=maps!W5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=ct2 Rng=maps!Y5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!Z5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=owatpmarg Rng=maps!AA5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=owatpmarg Rng=maps!AC5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!AD5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!AF5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=w Rng=maps!AG5 rdim=1"

Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=maps!AI5 rdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx set=r Rng=maps!AJ5 rdim=1"

*~~~~~~ Writing out the elasticities derived from GTAP

* Factor Substitution Elasticities
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elastva Rng=actelastva!B5 rdim=1 cdim=1"
* CES elasticities between domestic and imported
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elastm Rng=comelastm!B5 rdim=1 cdim=1"
* CES elasticities between imports by source regions
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elastrm Rng=comelastrm!B5 rdim=1 cdim=1"

*~~~~~~ Writing out MEANINGLESS elasticities TO DIMEMSION the workbook
* Export CET elasticities
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elaste Rng=comelaste!B5 rdim=1 cdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elastre Rng=comelastre!B5 rdim=1 cdim=1"
* Production elasticities
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elastx Rng=actelastx!B5 rdim=1 cdim=1"
* LES elasticities
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=frisch Rng=frischelast!B5 rdim=1 cdim=1"
Execute "GDXXRW i=output\%data_out%.gdx o=output\%data_out%.xlsx par=elasty Rng=incelast!B5 rdim=2 cdim=1"



*############################## THE END ############################

