* -------------- anar_t variable initialisation -------------------------
$ontext

  Variable initialisation is important for 'helping' the solver and
for resetting variable values to the base values of the model.

  Where practical the general principle used in this file is to define
the initial values from model equations. This serves as an extra check
on model calibration.

  An alternative version of this file ***_varinit2.inc defines the
initial values using the base (***0) values for variables.

$offtext

*## INITIAL VALUES OF VARIABLES FROM PARAMETER SPECIFICATION

* ######## NORMALISED PRICE BLOCK
 PER.L(c,w,r)   = PER0(c,w,r) ;
 PE.L(c,r)      = PE0(c,r) ;

 PD.L(c,r)      = PD0(c,r) ;
 PMR.L(w,c,r)   = PMR0(w,c,r) ;
 PM.L(c,r)      = PM0(c,r) ;
 PML.L(c,r)     = PML0(c,r) ;
 PMS.L(c,r)     = PMS0(c,r) ;

 PX.L(a,r)      = PX0(a,r) ;

 PXC.L(c,r)     = PXC0(c,r) ;

 PQS.L(c,r)     = PQS0(c,r) ;

 PT.L(c,r)      = PT0(c,r) ;

 ER.L(r)        = ER0(r) ;

* ######## TRADE BLOCK

* #### Exports Block

 PWE.L(c,w,r)   = PWE0(c,w,r) ;

 QD.L(c,r)      = (SUM(a,SAMG(a,c,r)/PD.L(c,r))) - QE0(c,r) ;

* level 1
* QE.L(c,r)$ce(c,r) = atr(c,r)*SUM(wm,
*                     gammar(c,wm,r)*QER0(c,wm,r)**(rhoe(c,r)) )**(1/rhoe(c,r)) ;

 QE.L(c,r)$ce(c,r) = QE0(c,r) ;

* QER.L(c,wm,r)$cer2(c,wm,r)
*              =  atr2(c,wm,r)*SUM(w$map_wm_w(wm,w),
*                     gammar(c,w,r)*QER0(c,w,r)**(rhoe2(c,wm,r)) )
*                      **(1/rhoe2(c,wm,r)) ;

 QER.L(c,w,r) = QER0(c,w,r) ;

* #### Imports Block

 PWMFOB.L(w,c,r)= PWMFOB0(w,c,r) ;
 PWM.L(w,c,r)   = PWMFOB.L(w,c,r)
                       + SUM(cp$ct(cp,r),margcor(w,cp,c,r)*PT.L(cp,r)) ;

 QQ.L(c,r)      = QQ0(c,r) ;

 QM.L(c,r)$(cd(c,r) AND cm(c,r))
              = QD.L(c,r)*((PD.L(c,r)/PM.L(c,r))
                        *(delta(c,r)/(1-delta(c,r))))**(1/(1+rhoc(c,r))) ;

* level 1
 QM.L(c,r)$cm(c,r) = acr(c,r)*SUM(w,
                     deltar(w,c,r)*QMR0(w,c,r)**(-rhom(c,r)) )**(-1/rhom(c,r)) ;
$Ontext
* KT, for small shares, deltar is zero because it is calibrated for QML

 QM.L(c,r)$PM0(c,r)       = SUM(w, PMR.L(w,c,r)*QMR.L(w,c,r))/PM.L(c,r) ;

 QMS.L(c,r)$cms(c,r) = ioqmsqm(c,r) * QM.L(c,r) ;

 QML.L(c,r)$cml(c,r) = ioqmlqm(c,r) * QM.L(c,r) ;


* Leontief Aggregation at Level 3

 QMR.L(w,c,r)$cmrs(w,c,r) = ioqmrqms(w,c,r) * QMS.L(c,r) ;
$offtext

* CES Aggregation at Level 3
* KT
* QMR.L(w,c,r)$cmrl(w,c,r)
*               = QML.L(c,r)*((PMR.L(w,c,r)*acr(c,r)**rhom(c,r))
*                           /(PML.L(c,r)*deltar(w,c,r)))**(-1/(rhom(c,r)+1)) ;

 QMR.L(w,c,r) = QMR0(w,c,r) ;

* KT, for small shares, deltar is zero because it is calibrated for QML

 QM.L(c,r)$PM0(c,r)       = SUM(w, PMR.L(w,c,r)*QMR.L(w,c,r))/PM.L(c,r) ;

 QMS.L(c,r)$cms(c,r) = ioqmsqm(c,r) * QM.L(c,r) ;

 QML.L(c,r)$cml(c,r) = ioqmlqm(c,r) * QM.L(c,r) ;

* Leontief Aggregation at Level 3

 QMR.L(w,c,r)$cmrs(w,c,r) = ioqmrqms(w,c,r) * QMS.L(c,r) ;



* trade margin quantity

 QT.L(w,c,r)$ct(c,r)
                = SUM(cp, QMR.L(w,cp,r)*margcor(w,c,cp,r)) ;

* ######## COMMODITY PRICE BLOCK

* PQD.L(c,r)     = PQS.L(c,r) * (1 + ts0(c,r)) ;
 PQD.L(c,r)     = PQD0(c,r) ;
 PQCD.L(c,r)    = PQD.L(c,r) * (1 + [TVADJ0(r) * tv0(c,r)]) ;

* ######## NUMERAIRE PRICE BLOCK

 CPI.L(r)       = CPI0(r) ;
 PPI.L(r)       = PPI0(r) ;

 ERPI.L         = ERPI0 ;

* ######## PRODUCTION BLOCK

* CES aggregation functions for Level 1 of production nest

 PVA.L(a,r)    = PVA0(a,r) ;

 PINT.L(a,r)   = SUM(c,ioqint(c,a,r) * PQD.L(c,r)) ;

 QX.L(a,r)$PX.L(a,r)     = SAMG("TOTAL",a,r)/PX.L(a,r) ;

 ADXADJ.L(r)  = ADXADJ0(r) ;
 DADX.L(r)    = DADX0(r) ;

 ADX.L(a,r)   = ((adx0(a,r) + dabadx(a,r)) * ADXADJ.L(r))
                                      + (DADX.L(r) * adx01(a,r)) ;

* Leontief aggregation functions for Level 1 of production nest

 QINT.L(a,r)$rgn(r)  = SUM(c,SAMG(c,a,r)/PQD.L(c,r)) ;

 QVA.L(a,r)   = QVA0(a,r) ;

* CES aggregation functions for Level 2 of production nest

 ADVAADJ.L(r) = ADVAADJ0(r) ;
 DADVA.L(r)   = DADVA0(r) ;

 ADVA.L(a,r)  = ((adva0(a,r) + dabadva(a,r)) * ADVAADJ.L(r))
                                      + (DADVA.L(r) * adva01(a,r)) ;

 ADFD.L(ff,a,r) = adfd0(ff,a,r) ;

 FD.L(ff,a,r)  = FD0(ff,a,r) ;

 FS.L(ff,r)    = SUM(a,FD.L(ff,a,r)) ;

 WF.L(f,r)$FS.L(f,r)                = SUM(a,SAMG(f,a,r))/FS.L(f,r) ;

 WFDIST.L(f,a,r)$FD.L(f,a,r)        = (SAMG(f,a,r)/FD.L(f,a,r))/WF.L(f,r) ;

 WFDIST.L(f,a,r)$(FD.L(f,a,r) EQ 0) = 0.0 ;
 
* Aggregate factor prices

 WF.L(fag,r)       = WF0(fag,r) ;
 WFDIST.L(fag,a,r) = WFDIST0(fag,a,r) ;

 WFA.L(fag,a,r)  = WF.L(fag,r) * WFDIST.L(fag,a,r) ;
 
* Intermediate Input Demand

 QINTD.L(c,r)   = SUM(a,ioqx(c,a,r)*QX.L(a,r)) ;

* Commodity Output

 QXC.L(c,r)     = SUM(a,ioqxcqx(a,c,r)*QX.L(a,r)) ;

* ######## FACTOR BLOCK

 YF.L(f,r)      = SUM(a,WF.L(f,r)*WFDIST.L(f,a,r)*FD.L(f,a,r)) ;

 YFDIST.L(f,r)  = (YF.L(f,r) - (deprec(f,r)*YF.L(f,r))) * (1-TYF0(f,r)) ;

* ######## HOUSEHOLD BLOCK
* ## Household Income

 YH.L(h,r)      = SUM(f,hvash(h,f,r)*YFDIST.L(f,r)) ;

* Household Expenditure

 HEXP.L(h,r)    = (YH.L(h,r)*(1-TYH0(h,r)))*(1-(SHH0(h,r))) ;

 QCD.L(c,h,r)$PQD.L(c,r)      = (comhav(c,h,r)*HEXP.L(h,r))/PQD.L(c,r) ;

* ######## GOVERNMENT BLOCK

* #### Government Income Block

* ## Government Taxes

 TMADJ.L(r)     = TMADJ0(r) ;
 TEADJ.L(r)     = TEADJ0(r) ;
 TSADJ.L(r)     = TSADJ0(r) ;
 TVADJ.L(r)     = TVADJ0(r) ;
 TXADJ.L(r)     = TXADJ0(r) ;
 TYFADJ.L(r)    = TYFADJ0(r) ;
 TYHADJ.L(r)    = TYHADJ0(r) ;
 TFADJ.L(r)     = TFADJ0(r) ;

 DTE.L(r)       = DTE0(r) ;
 DTM.L(r)       = DTM0(r) ;
 DTS.L(r)       = DTS0(r) ;
 DTV.L(r)       = DTV0(r) ;
 DTX.L(r)       = DTX0(r) ;
 DTYF.L(r)      = DTYF0(r) ;
 DTYH.L(r)      = DTYH0(r) ;
 DTF.L(r)       = DTF0(r) ;

 TS.L(c,r)      = ((tsb(c,r) + dabts(c,r))* TSADJ.L(r))
                       + (DTS.L(r)*ts01(c,r)) ;

 TV.L(c,r)      = ((tvb(c,r) + dabtv(c,r))* TVADJ.L(r))
                       + (DTV.L(r)*tv01(c,r)) ;

 STAX.L(r)      = SUM(c,TS.L(c,r)*PQS.L(c,r)*QQ.L(c,r)) ;

 VTAX.L(r)      = SUM((c,h),TV.L(c,r)*PQD.L(c,r)*QCD.L(c,h,r)) ;

 TM.L(w,c,r)    = ((tmb(w,c,r) + dabtm(w,c,r))* TMADJ.L(r))
                     + (DTM.L(r)*tm01(w,c,r)) ;

 MTAX.L(r)      = SUM((c,w), TM.L(w,c,r)*PWM.L(w,c,r)
                             *ER.L(r)*QMR.L(w,c,r)) ;

 TE.L(c,w,r)    = ((teb(c,w,r) + dabte(c,w,r))* TEADJ.L(r))
                     + (DTE.L(r)*te01(c,w,r)) ;

 ETAX.L(r)      = SUM((c,w), TE.L(c,w,r)*PWE.L(c,w,r)
                             *ER.L(r)*QER.L(c,w,r)) ;

 TX.L(a,r)      = ((txb(a,r) + dabtx(a,r))* TXADJ.L(r))
                    + (DTX.L(r)*tx01(a,r)) ;

 ITAX.L(r)      = SUM(a,TX.L(a,r)*PX.L(a,r)*QX.L(a,r)) ;

 TYF.L(f,r)     = ((tyfb(f,r) + dabtyf(f,r))* TYFADJ.L(r))
                      + (DTYF.L(r)*tyf01(f,r)) ;

 FYTAX.L(r)     = SUM(f,TYF.L(f,r) *(YF.L(f,r) - (deprec(f,r)*YF.L(f,r)))) ;

 TYH.L(h,r)     = ((tyhb(h,r) + dabtyh(h,r))* TYHADJ.L(r))
                       + (DTYH.L(r)*tyh01(h,r)) ;

 HTAX.L(r)      = SUM(h,TYH.L(h,r)*YH.L(h,r)) ;

 TF.L(f,a,r)    = ((tfb(f,a,r) + dabtf(f,a,r))* TFADJ.L(r))
                             + (DTF.L(r)*tf01(f,a,r)) ;

 FTAX.L(r)      = SUM((f,a), TF.L(f,a,r)*WF.L(f,r)
                              *WFDIST.L(f,a,r)*FD.L(f,a,r)) ;


* ## Government Income

 YG.L(r)        = MTAX.L(r) + ETAX.L(r) + STAX.L(r) + VTAX.L(r) + ITAX.L(r)
                  + FYTAX.L(r) + HTAX.L(r) + FTAX.L(r);

* #### Government Expenditure Block

 QGDADJ.L(r)    = QGDADJ0(r) ;

 QGD.L(c,r)     = QGDADJ.L(r)*qgdconst(c,r) ;

 EG.L(r)        = SUM(c,QGD.L(c,r)*PQD.L(c,r)) ;

* ######## KAPITAL BLOCK

* ## Savings Block

 SADJ.L(r)      = SADJ0(r) ;

 DSHH.L(r)      = DSHH0(r) ;

 SHH.L(h,r)     = ((shh0(h,r) + dabshh(h,r)) * SADJ.L(r))
                                  + (DSHH.L(r) * shh01(h,r)) ;

 TOTSAV.L(r)    = SUM(h,YH.L(h,r)*(1-TYH.L(h,r))*(SHH.L(h,r)))
                      + SUM(f,deprec(f,r)*YF.L(f,r))
                      + KAPGOV0(r)
                      + (KAPWOR0(r)*ER.L(r)) ;

* ## Investment Block

 IADJ.L(r)      = IADJ0(r) ;

 QINVD.L(c,r)   = (IADJ.L(r)*qinvdconst(c,r)) ;

 INVEST.L(r)    = TOTSAV.L(r) ;

* ######## MARKET CLEARING BLOCK

* ##### Account Closure

 KAPGOV.L(r)    = KAPGOV0(r) ;

 KAPREG.L(w,r)$wgn(w)  = SUM(c,PWMFOB.L(w,c,r)*QMR.L(w,c,r))
                        - SUM(c,PWE.L(c,w,r)*QER.L(c,w,r)) ;

 KAPREG.L(w,r)$(NOT wgn(w))   = SUM((wp,c), PT.L(c,r)*QT.L(wp,c,r))
                        - SUM(c,PWE.L(c,w,r)*QER.L(c,w,r)) ;

 KAPWOR.L(r)     = SUM(w, KAPREG.L(w,r)) ;

* #### Absorption Closure

 VFDOMD.L(r)   = SUM(c, PQD.L(c,r) *
                       (SUM(h,QCD.L(c,h,r)) + QGD.L(c,r) + QINVD.L(c,r))) ;

 INVESTSH.L(r)$VFDOMD.L(r)  = INVEST.L(r)/VFDOMD.L(r) ;

 VGDSH.L(r)$VFDOMD.L(r) = SUM(c,PQD.L(c,r) * QGD.L(c,r))/VFDOMD.L(r) ;


* #### GLOBE Closure


* ##### Slack

 WALRAS.L(r)    = WALRAS0(r) ;

 KAPWOR_SL.L    = KAPWOR_SL0 ;

 GLB_SL.L   = GLB_SL0 ;

* ------ VARIOUS CHECKS FOR CALIBRATION OF PARAMETERS

 OPTION decimals = 6 ;
*## FOR IMPORTS-DOMESTIC COMPOSITE

* VARIABALE DECLARATION
* VARIABALE INITIALISATION

 PARAMETER PWECHK(c,w,r)
           QERCHK(c,w,r)     ;
 PWECHK(c,w,r) = PWE.L(c,w,r) - PWE0(c,w,r) ;
 QERCHK(c,w,r) = QER.L(c,w,r) - QER0(c,w,r) ;

DISPLAY PWECHK,QERCHK;

PARAMETER
 COMTAXM(r)   M Taxes
 COMTAXE(r)   E Taxes
 COMTAXS(r)   S Taxes
 COMTAXT(r)   Total Com Taxes
   ;

 COMTAXM(r) = SUM((c,w),TM.L(w,c,r)
                    *PWM.L(w,c,r)*QMR.L(w,c,r)*ER.L(r)) ;

 COMTAXE(r) = SUM((c,w),TE.L(c,w,r)
                    *PWE.L(c,w,r)*ER.L(r)*QER.L(c,w,r)) ;

 COMTAXS(r) = SUM(c,TS.L(c,r)
                    *PQS.L(c,r)*QQ.L(c,r)) ;

 COMTAXT(r) = SUM((c,w),TM.L(w,c,r)
                     *PWM.L(w,c,r)*QMR.L(w,c,r)*ER.L(r))
                + SUM((c,w),TE.L(c,w,r)
                     *PWE.L(c,w,r)*ER.L(r)*QER.L(c,w,r))
                + SUM(c,TS.L(c,r)
                     *PQS.L(c,r)*QQ.L(c,r)) ;

DISPLAY COMTAXM, COMTAXE, COMTAXS, COMTAXT ;

 OPTION decimals = 3 ;

* -------------- end of anar_t variable initialisation ------------------
