* -------------- anar_t calculate and write out various indices -----------


*--------- WEIGHTS for PRICE INDICES -------------

* Domestic price weights

 wt_pd(c,r)$rgn(r)   = [PD0(c,r)*QD0(c,r)]/SUM[cp, PD0(cp,r)*QD0(cp,r)] ;
            
 wt_pqs(c,r)$rgn(r)  = [PQS0(c,r)*QQ0(c,r)]/SUM[cp, PQS0(cp,r)*QQ0(cp,r)] ;
 wt_pqd(c,r)$rgn(r)  = [PQD0(c,r)*QQ0(c,r)]/SUM[cp, PQD0(cp,r)*QQ0(cp,r)] ;
 wt_pqcd(c,r)$rgn(r) = [SUM(h,PQCD0(c,r)*QCD0(c,h,r))]/SUM[(cp,hp), PQCD0(cp,r)*QCD0(cp,hp,r)] ;

* Production price weights

 wt_pxc(c,r)$rgn(r)  = [PXC0(c,r)*QXC0(c,r)]/SUM[cp, PXC0(cp,r)*QXC0(cp,r)] ;
 wt_px(a,r)$rgn(r)   = [PX0(a,r)*QX0(a,r)]/SUM[ap, PX0(ap,r)*QX0(ap,r)] ;
 wt_pva(a,r)$rgn(r)  = [PVA0(a,r)*QVA0(a,r)]/SUM[ap, PVA0(ap,r)*QVA0(ap,r)] ;
 wt_pint(a,r)$rgn(r) = [PINT0(a,r)*QINT0(a,r)]/SUM[ap, PINT0(ap,r)*QINT0(ap,r)] ;
           
 wt_wf(f,r)$rgn(r)   = [SUM(a,WF0(f,r)*FD0(f,a,r))]/SUM[(fp,ap), WF0(fp,r)*FD0(fp,ap,r)] ;
  
* Trade price weights

 wt_pwe(c,r)${rgn(r) AND SUM[(cp,wp), PWE0(cp,wp,r)*QER0(cp,wp,r)]}  = SUM{w,([PWE0(c,w,r)*QER0(c,w,r)]/SUM[(cp,wp), PWE0(cp,wp,r)*QER0(cp,wp,r)])} ;
 
 wt_pwm(c,r)${rgn(r) AND SUM[(cp,w), PWM0(w,cp,r)*QMR0(w,cp,r)]}   = SUM{w,([PWM0(w,c,r)*QMR0(w,c,r)]/SUM[(cp,wp), PWM0(wp,cp,r)*QMR0(wp,cp,r)])} ;
 
 wt_pe(c,r)$rgn(r)  = [PE0(c,r)*QE0(c,r)]/SUM[cp, PE0(cp,r)*QE0(cp,r)] ;
 
 wt_pm(c,r)$rgn(r)  = [PM0(c,r)*QM0(c,r)]/SUM[cp, PM0(cp,r)*QM0(cp,r)] ;
 
 wt_pw("exp",r)$rgn(r)
  = SUM[(cp,w), PWE0(cp,w,r)*QER0(cp,w,r)]
    / {[SUM((cp,w),PWE0(cp,w,r)*QER0(cp,w,r))] + [SUM((w,cp), PWM0(w,cp,r)*QMR0(w,cp,r))] } ;
 wt_pw("imp",r)$rgn(r)
  = SUM[(cp,w), PWM0(w,cp,r)*QMR0(w,cp,r)]
    / {[SUM((cp,w),PWE0(cp,w,r)*QER0(cp,w,r))] + [SUM((w,cp), PWM0(w,cp,r)*QMR0(w,cp,r))] }  ;
    
* CPI weights
 wt_cpi_h(c,h,r)$rgn(r)  = SAMG(c,h,r)/SUM[cp,SAMG(cp,h,r)] ;
 
* PPI weights
 wt_ppi_a(a,c,r)$(rgn(r) AND SUM[ap,SAMG(ap,c,r)]) = SAMG(a,c,r)/SUM[ap,SAMG(ap,c,r)] ;
    

*--------- COMMODITY PRICE INDICES -------------

* Domestic price indices

 resP_IND("pd_ind",r,%res_dimen%)$rgn(r)   = 100 * SUM[c,lev_PD(c,r,%res_dimen%) * wt_pd(c,r)] ;
 resP_IND("pqs_ind",r,%res_dimen%)$rgn(r)  = 100 * SUM[c,lev_PQS(c,r,%res_dimen%) * wt_pqs(c,r)] ;
 resP_IND("pqd_ind",r,%res_dimen%)$rgn(r)  = 100 * SUM[c,lev_PQD(c,r,%res_dimen%) * wt_pqd(c,r)] ;
 resP_IND("pqcd_ind",r,%res_dimen%)$rgn(r) = 100 * SUM[c,lev_PQCD(c,r,%res_dimen%) * wt_pqcd(c,r)] ;

* Production price indices
 resP_IND("pxc_ind",r,%res_dimen%)$rgn(r)    = 100 * SUM[c,lev_PXC(c,r,%res_dimen%) * wt_pxc(c,r) ] ;
 resP_IND("px_ind",r,%res_dimen%)$rgn(r)     = 100 * SUM[a,lev_PX(a,r,%res_dimen%) * wt_px(a,r)  ] ;
 resP_IND("pva_ind",r,%res_dimen%)$rgn(r)    = 100 * SUM[a,lev_PVA(a,r,%res_dimen%) * wt_pva(a,r) ] ;
 resP_IND("pint_ind",r,%res_dimen%)$rgn(r)   = 100 * SUM[a,lev_PINT(a,r,%res_dimen%) * wt_pint(a,r)] ;

 resP_IND("wf_ind",r,%res_dimen%)$rgn(r)     = 100 * SUM[f,lev_WF(f,r,%res_dimen%) * wt_wf(f,r)] ;
                                                      
* wfa_ind    Activity specific factor prices index (base = 100)
                                                   
* Trade price indices

 resP_IND("er",r,%res_dimen%)$rgn(r)       = 100 * lev_ER(r,%res_dimen%) ;
 
* resP_IND("pwe_ind",r,%res_dimen%)  = 100 * SUM[c,lev_PWE(c,r,%res_dimen%) * wt_pwe(c,r)]
*                                         /SUM[c,PWE0(c,r) * wt_pwe(c,r)] ;
                                         
* resP_IND("pwm_ind",r,%res_dimen%)  = 100 * SUM[c,lev_PWM(c,r,%res_dimen%) * wt_pwm(c,r)]
*                                         /SUM[c,PWM0(c,r) * wt_pwm(c,r)] ;
                                                                                  
 resP_IND("pe_ind",r,%res_dimen%)$rgn(r)   = 100 * SUM[c,lev_PE(c,r,%res_dimen%) * wt_pe(c,r)]
                                         /SUM[c,PE0(c,r) * wt_pe(c,r)] ;

 resP_IND("pm_ind",r,%res_dimen%)$rgn(r)   = 100 * SUM[c,lev_PM(c,r,%res_dimen%) * wt_pm(c,r)]
                                         /SUM[c,PM0(c,r) * wt_pm(c,r)] ;   
                                         
 resP_IND("pw_ind ",r,%res_dimen%)$rgn(r)  = [wt_pw("exp",r) * resP_IND("pwe_ind",r,%res_dimen%)]
                                     + [wt_pw("imp",r) * resP_IND("pwm_ind",r,%res_dimen%)] ;
                                                                              
 resP_IND("rer",r,%res_dimen%)$rgn(r)      = resP_IND("er",r,%res_dimen%)
                                    * [resP_IND("pw_ind ",r,%res_dimen%)/resP_IND("pd_ind ",r,%res_dimen%)] ;
                                                                      
 resP_IND("toft",r,%res_dimen%)$resP_IND("pwm_ind",r,%res_dimen%)
                                  = 100 * {resP_IND("pwe_ind",r,%res_dimen%)
                                          / resP_IND("pwm_ind",r,%res_dimen%)} ;


* Consumer prices indices

 resCPI_H_IND(h,r,%res_dimen%)$rgn(r)      = 100 * SUM[c,lev_PQCD(c,r,%res_dimen%) * wt_cpi_h(c,h,r)]
                                          /SUM[c,PQCD0(c,r) * wt_cpi_h(c,h,r)] ;
                                          
* Producer price indices

 resPPI_A_IND(a,r,%res_dimen%)$rgn(r)      = 100 * SUM[c,lev_PD(c,r,%res_dimen%) * wt_ppi_a(a,c,r)]
                                          /SUM[c,PD0(c,r) * wt_ppi_a(a,c,r)] ;
                                          
* ------- Exporting Welfare Results to GDX -------------------------------

* This writes the results data to GDX

Execute_Unload  '6_Results\%expt_res%\anar_t_respind.gdx',

                                                resP_IND
                                                resCPI_H_IND
                                                resPPI_A_IND
                                                  ;


*----------- END OF anar_t calculate and write out various indices -------
