* -------------- anar_t parameter declaration & assignments -------------

$ontext
 Calibration proceeds by the blocks of equations
 each block contains all the related parameter declarations and assignments

 All permutations for the model and model calibration are selected in
       EITHER     dat_c_f_r_10.inc
       OR         data_c_f_r_10.xls

$offtext
* ######## NORMALISED PRICE BLOCK

PARAMETERS
 PE0(c,r)       Domestic price of exports by commodity c
 PER0(c,w,r)    Domestic price of exports of comm'y c to region w and wm

 PD0(c,r)       Consumer price for domestic supply of commodity c

 PM0(c,r)       Domestic price of competitive imports c
 PML0(c,r)      Dom price of imports of comm'y c from region with small shares
 PMS0(c,r)      Dom price of imports of comm'y c from region with large shares
 PMR0(w,c,r)    Domestic price of imports of comm'y c from region w and wm

 PT0(c,r)       Price of margin services c

 PX0(a,r)       Composite price of output by activity a
 PXC0(c,r)      Producer price of composite domestic output

 ER0(r)         Exchange rate

   ;

* #### Assignments

 PE0(c,r)                     = 1.0 ;
 PER0(c,w,r)                  = 1.0 ;

 PD0(c,r)                     = 1.0 ;

 PM0(c,r)                     = 1.0 ;
 PML0(c,r)                    = 1.0 ;
 PMS0(c,r)                    = 1.0 ;
* PMR0(w,c,r)                  = 1.0 ;

 PT0(c,r)                     = 1.0 ;

 PX0(a,r)$SAMG("total",a,r)   = 1.0 ;

 PXC0(c,r)                    = 1.0 ;

 ER0(r)                       = 1.0 ;

* ######## TRADE BLOCK

* #### Exports Block

PARAMETERS
* ## Initial values for variables
 PWE0(c,w,r)        World price of exports of comm'y c to region w

 QER0(c,w,r)        Exports of comm'y c to region w
 QE0(c,r)           Total exports of comm'y
 QD0(c,r)           Domestic demand for commodity c

* ## Parameters for CET functions
* CET in normal form

 mod_elaste(c,r)  Level 1 CET elasticities used in the model
 mod_elastre(c,r) Level 2 CET elasticities used in the model

 atr(c,r)         Shift param for CET over exports by aggregate region

 gammar(c,w,r)    Share parameter for CET over exports by region & aggregate

 rhoe(c,r)        Elast parameter for CET over exports by aggregate region

 at(c,r)          Shift parameter for CET function
 gamma(c,r)       Share parameter for CET function

 rhot(c,r)        Elasticity parameter for Output CET function

   ;

* #### Assignments

* ## Initial values for variables

 QER0(c,w,r)$cer(c,w,r)      = (SAMG(c,w,r)
                                  - SUM(ter$map_w_ter(w,ter), SAMG(ter,c,r)))
                                         /PER0(c,w,r) ;

* note that QEO is a CET of QER0 by region and PER0(c,wm,r) = 1
* as assigned earlier

 QE0(c,r)$PE0(c,r)       = SUM(w, PER0(c,w,r)*QER0(c,w,r))/PE0(c,r) ;

 PWE0(c,w,r)$QER0(c,w,r)     = (SAMG(c,w,r)/ER0(r))/QER0(c,w,r) ;

* QD0 = QXC0 - QE0
 QD0(c,r)      = (SUM(a,SAMG(a,c,r))/PXC0(c,r)) - QE0(c,r) ;

* ## Parameters for CET functions

$ontext
Choice of elasticities for Export transformation
  Selection controlled by value of mod_cont("cetelast")
   a) IF mod_cont("cetelast") = 1
        ALL elasticities for CET are from Excel

   b) IF mod_cont("cetelast") = 2
        Elast'ies for CET are from GTAP

$offtext

IF (mod_cont("cetelast") = 1,

 mod_elastre(c,r) = ELASTRE(c,r) ;

  ) ;

IF (mod_cont("cetelast") = 2,

 mod_elastre(c,r)   = ELASTRMG(c,r)/mod_cont("cetscal") ;

 mod_elastre(c,r)$(mod_elastre(c,r) GT 0.85 and mod_elastre(c,r) LE 1.0) = 0.85 ;
 mod_elastre(c,r)$(mod_elastre(c,r) GT 1.0 and mod_elastre(c,r) LT 1.15) = 1.15 ;

  ) ;

 rhoe(c,r)         = ((1/mod_elastre(c,r)) + 1) ;

$ontext
 Calibrate CET functions with an arbitrary number of trade partners
 AND explicitly exclude the globe because it has a homogeneous export
$offtext

* level 1

 gammar(c,w,r)$(cer(c,w,r) AND rgn(r))
                = (PER0(c,w,r)*QER0(c,w,r)**(1-rhoe(c,r)) ) /
                SUM(wp$cer(c,wp,r), PER0(c,wp,r)*QER0(c,wp,r)**(1-rhoe(c,r)) );

 atr(c,r)$(QE0(c,r) AND rgn(r))
                = QE0(c,r)/SUM(w, gammar(c,w,r)*QER0(c,w,r)
                           **(rhoe(c,r)) )**(1/(rhoe(c,r))) ;


*## FOR EXPORTS-DOMESTIC COMPOSITE

$ontext
Choice of elasticities for Export transformation
  Selection controlled by value of mod_cont("cetelast")
   a) IF mod_cont("cetelast") = 1
        ALL elasticities for CET are from Excel

   b) IF mod_cont("cetelast") = 2
        Elast'ies for CET are from GTAP

$offtext

IF (mod_cont("cetelast") = 1,

 mod_elaste(c,r)  = ELASTE(c,r) ;

  ) ;

IF (mod_cont("cetelast") = 2,

 mod_elaste(c,r)   = ELASTMG(c,r)/mod_cont("cetscal") ;

 mod_elaste(c,r)$(mod_elaste(c,r) GT 0.85 and mod_elaste(c,r) LE 1.0) = 0.85 ;
 mod_elaste(c,r)$(mod_elaste(c,r) GT 1.0 and mod_elaste(c,r) LT 1.15) = 1.15 ;

  ) ;

 rhot(c,r)$(cd(c,r) AND ce(c,r))    = (1/mod_elaste(c,r)) + 1 ;

 gamma(c,r)$(cd(c,r) AND ce(c,r))
              = 1/(1+PD0(c,r)/PE0(c,r)*(QE0(c,r)/QD0(c,r))**(rhot(c,r)-1));

* Using QXC0 = (SUM(a,SAMG(a,c,r))/PXC0(c,r))
 at(c,r)$(cd(c,r) AND ce(c,r))
              = (SUM(a,SAMG(a,c,r))/PXC0(c,r))/(gamma(c,r)*QE0(c,r)
                           **rhot(c,r) + (1-gamma(c,r))*
                       QD0(c,r)**rhot(c,r))**(1/rhot(c,r));

* #### Imports Block

PARAMETERS
* ## Initial values for variables
 PWM0(w,c,r)      World cif price of imports of comm'y c from region w
 PWMFOB0(w,c,r)   Imports of comm'y c from region w valued at fob prices

 QMR0(w,c,r)      Imports of comm'y c to region w
 QM0(c,r)         Total imports of comm'y
 QML0(c,r)        Supply of composite import from large share regions
 QMS0(c,r)        Supply of composite import from large share regions
 QQ0(c,r)         Supply of composite commodity c

 QT0(w,c,r)       Margin services on total imports from region w

* ## Parameters for Armington/CES functions
* CET in normal form
 mod_elastm(c,r)  Level 1 CES elasticities used in the model
 mod_elastrm(c,r) Level 2 CES elasticities used in the model

 acr(c,r)         Shift parameter for Armington CES over imports by aggregate region

 deltar(w,c,r)    Share parameter for Armington CES over imports by region & aggregate

 rhom(c,r)        Elast parameter for Armington CES over imports by aggregate region

 ac(c,r)          Shift parameter for Armington CES function

 delta(c,r)       Share parameter for Armington CES function

 rhoc(c,r)        Elasticity parameter for Armington CES function

* ## Parameters for Leontief functions

 ioqmlqm(c,r)     Share of QML in QM
 ioqmrqms(w,c,r)  Share of QMR in QMS
 ioqmsqm(c,r)     Share of QMS in QM

* ## Parameters for Trade margins
 margcor(w,c,cp,r)  Margin c per unit of r's import of commodity cp from region w

   ;

* #### Assignments

* ## Initial values for variables

 PWMFOB0(w,c,r)   = SUM((rp,wp)
                       $(map_w_r(w,rp)
                        $map_r_w(r,wp)),PWE0(c,wp,rp)) ;

 QMR0(w,c,r)$PWMFOB0(w,c,r)  = SAMG(w,c,r)/PWMFOB0(w,c,r) ;

 PMR0(w,c,r)$QMR0(w,c,r) = (SAMG(w,c,r) + SUM(tmr$map_w_tmr(w,tmr), SAMG(tmr,c,r)) +
                                SUM(cp$ct(cp,r), IMPMARG(w,cp,c,r)) )
                               /QMR0(w,c,r) ;


  QML0(c,r)    = SUM(w$cmrl(w,c,r), PMR0(w,c,r)*QMR0(w,c,r)) ;

  QMS0(c,r)   = SUM(w$cmrs(w,c,r), PMR0(w,c,r)*QMR0(w,c,r)) ;

  QM0(c,r)$PM0(c,r)       = SUM(w, PMR0(w,c,r)*QMR0(w,c,r))/PM0(c,r) ;

* check
*  QML0(c,r)   = QM0(c,r) - QMS0(c,r) ;

* nested CES
* note that PMR0(c,w,r) = 1, as assigned earlier)
* note that QM0 is a CES of QMR by aggregate regions
Parameter
 QM02(c,r)   alternate calculation
 QM03(c,r)   alternate calculation
;

 QM03(C,R)                = QML0(C,R) + QMS0(C,R) ;
 QM02(c,r)$PM0(c,r)       = SUM(w, PMR0(w,c,r)*QMR0(w,c,r))/PM0(c,r) ;

 QM0(c,r)$PM0(c,r)
             = ((PMS0(c,r)*QMS0(c,r)) + (PML0(c,r)*QML0(c,r)))/PM0(c,r) ;

Parameter
 QM02chk(c,r)  Comparison of QM02 with QM0
 qm03chk(c,r)  Comparison of QM03 with QM0
;

QM02chk(c,r) = QM02(c,r) - QM0(c,r) ;
QM03chk(c,r) = QM03(c,r) - QM0(c,r) ;


 PWM0(w,c,r)$QMR0(w,c,r)
             = (SAMG(w,c,r)+ SUM(cp$ct(cp,r), IMPMARG(w,cp,c,r)) )/
                               ER0(r)/QMR0(w,c,r) ;

 QQ0(c,r)                    = QD0(c,r) + QM0(c,r) ;

* ## Parameters for Armington/CES functions

$ontext
Choice of elasticities for Import substitution
  Selection controlled by value of mod_cont("armelast")
   a) IF mod_cont("armelast") = 1
        ALL elasticities for ARMINGTON are from Excel, the parameter ELASTRM

   b) IF mod_cont("armelast") = 2
        ALL elasticities for ARMINGTON are from GTAP, the parameter ELASTRMG
$offtext

IF (mod_cont("armelast") = 1,

 mod_elastrm(c,r)   = ELASTRM(c,r) ;

  ) ;

IF (mod_cont("armelast") = 2,

 mod_elastrm(c,r)   = ELASTRMG(c,r)/mod_cont("armscal") ;

 mod_elastrm(c,r)$(mod_elastrm(c,r) GT 0.85 and mod_elastrm(c,r) LE 1.0) = 0.85 ;
 mod_elastrm(c,r)$(mod_elastrm(c,r) GT 1.0 and mod_elastrm(c,r) LT 1.15) = 1.15 ;

  ) ;

 rhom(c,r)         = ((1/mod_elastrm(c,r)) - 1) ;

* Level 2
* calibrate CES with an arbitrary number of trade partners

 deltar(w,c,r)$cmrl(w,c,r)
                 = (PMR0(w,c,r)*QMR0(w,c,r)**(1+rhom(c,r)) )
                    /SUM(wp$cmrl(wp,c,r), PMR0(wp,c,r)*QMR0(wp,c,r)
                     **(1+rhom(c,r)) ) ;

 acr(c,r)$QML0(c,r)   = QML0(c,r)/SUM(wp$cmrl(wp,c,r), deltar(wp,c,r)*QMR0(wp,c,r)
                                 **(-rhom(c,r)) )**(-1/rhom(c,r)) ;


* ## Parameters for Leontief functions

 ioqmlqm(c,r)$cm(c,r)          = QML0(c,r)/QM0(c,r) ;

 ioqmrqms(w,c,r)$cmrs(w,c,r)    = QMR0(w,c,r)/QMS0(c,r) ;

 ioqmsqm(c,r)$cm(c,r)          = QMS0(c,r)/QM0(c,r) ;


Parameter
deltarCHK(c,r)
ioqmrqmsCHK(c,r)
ioqmCHK(c,r) ;

 deltarCHK(c,r)    = SUM(w,deltar(w,c,r)) ;

 ioqmrqmsCHK(c,r)     = SUM(w,ioqmrqms(w,c,r)) ;

 ioqmCHK(c,r)         = ioqmlqm(c,r) + ioqmsqm(c,r) ;

*#### CALIBRATION OF SHIFT AND SHARE PARAMETERS FOR TRADE ####

*## FOR IMPORTS-DOMESTIC COMPOSITE

$ontext
Choice of elasticities for Import substitution
  Selection controlled by value of mod_cont("armelast")
   a) IF mod_cont("armelast") = 1
        ALL elasticities for ARMINGTON are from Excel, the parameter ELASTM

   b) IF mod_cont("armelast") = 2
        ALL elasticities for ARMINGTON are from GTAP, the parameter ELASTMG

$offtext

IF (mod_cont("armelast") = 1,

* rhoc(c,r)$(cx(c,r) AND cm(c,r))    = (1/ELASTM(c,r)) - 1 ;
 mod_elastm(c,r)       = ELASTM(c,r) ;

  ) ;

IF (mod_cont("armelast") = 2,

* rhoc(c,r)$(cx(c,r) AND cm(c,r))    = (1/ELASTMG(c,r)) - 1 ;
 mod_elastm(c,r)       = ELASTMG(c,r)/mod_cont("armscal") ;

 mod_elastm(c,r)$(mod_elastm(c,r) GT 0.85 and mod_elastm(c,r) LE 1.0) = 0.85 ;
 mod_elastm(c,r)$(mod_elastm(c,r) GT 1.0 and mod_elastm(c,r) LT 1.15) = 1.15 ;

  ) ;


 rhoc(c,r)$(cx(c,r) AND cm(c,r))    = (1/mod_elastm(c,r)) - 1 ;

* generalized calibration of CES, allows an arbitrary number of arguments

 delta(c,r)$(cd(c,r) AND cm(c,r)) = (PM0(c,r)*QM0(c,r)**(1+rhoc(c,r)) )
                                     /(PM0(c,r)*QM0(c,r)**(1+rhoc(c,r))
                                     + PD0(c,r)*QD0(c,r)**(1+rhoc(c,r))) ;

 ac(c,r)$(cd(c,r) AND cm(c,r)) = QQ0(c,r)/(delta(c,r)*QM0(c,r)**(-rhoc(c,r))
                                        +(1-delta(c,r))*QD0(c,r)
                                  **(-rhoc(c,r)))**(-1/rhoc(c,r)) ;

Parameter qqcalib(c,r)
          qqdif(c,r) ;

qqcalib(c,r) = ac(c,r)* (delta(c,r)*QM0(c,r)**(-rhoc(c,r))
                                        +(1-delta(c,r))*QD0(c,r)
                                  **(-rhoc(c,r)))**(-1/rhoc(c,r));
qqdif(c,r) = qqcalib(c,r) - qq0(c,r) ;
display qqdif;


* ## Parameters for Trade margins

 QT0(w,c,r)$CT(c,r)          = SUM(cp, IMPMARG(w,c,cp,r))/PT0(c,r) ;

 margcor(w,c,cp,r)$QMR0(w,cp,r)
              = IMPMARG(w,c,cp,r)/PT0(c,r)/QMR0(w,cp,r) ;

* ######## COMMODITY PRICE BLOCK

PARAMETERS

* ## Initial values for variables

 PQS0(c,r)        Supply price of composite commodity c
 PQD0(c,r)        Consumer price of composite commodity c
 PQCD0(c,r)       Purchaser price of composite commodity c private final demand
 tv2(c,r)         VAT rates for initialization
  ;

* #### Assignments

* ## Initial values for variables

 PQS0(c,r)    = 1 ;

 PQD0(c,r)$QQ0(c,r)
              = (SAMG(c,"total",r) - SUM(w, SAMG(c,w,r)) - SAMG("vattax",c,r))
                 /QQ0(c,r) ;

 tv2(c,r)$(SUM(h, SAMG(c,h,r)) - SAMG("vattax",c,r) )
              = SAMG("vattax",c,r)/(SUM(h, SAMG(c,h,r)) - SAMG("vattax",c,r)) ;

 PQCD0(c,r)   =  PQD0(c,r) * (1 + tv2(c,r)) ;

* ######## NUMERAIRE PRICE BLOCK

PARAMETERS

* ## Initial values for variables

 CPI0(r)         Consumer price index - Region numeraires
 PPI0(r)         Producer (domestic) price index - Region numeraires
 ERPI0           Exchange rate index - Global numeraire

* ## Price index weights

 comtotsh(c,r)    Share of commodity c in total commodity demand
 vddtotsh(c,r)    Share of value of domestic output for the domestic market
 tradtotsh(ref)   Share of total Exports by reference regions

  ;

* #### Assignments

* ## Price index weights

* CPI weights are based on household final demand expenditure shares ONLY

 comtotsh(c,r)$(SUM((cp,hp),SAMG(cp,hp,r)))
              = SUM(h,SAMG(c,h,r))/(SUM((cp,hp),SAMG(cp,hp,r))) ;

* alternate 1 - CPI weights based on final demand expenditure shares

* comtotsh(c)   = (SUM(h,SAM(c,h)) + SAM(c,"govt") + SAM(c,"i_s"))
*                 /(SUM((cp,hp),SAM(cp,hp))
*                  + SUM(cp,SAM(cp,"govt"))
*                  + SUM(cp,SAM(cp,"i_s")))  ;

* alternate 2 - CPI weights based on volume shares of domestic output

* comtotsh(c)   = QD0(c)/SUM(cp,QD0(cp)) ;

* PPI weights are based on the value of domestic output for the domestic market

 vddtotsh(c,r)$(SUM((ap,cp),SAMG(ap,cp,r)))
                = SUM(a,SAMG(a,c,r))/SUM((ap,cp),SAMG(ap,cp,r)) ;

* ERPI weights are based on shares of total trade by reference regions

* alternate 1 - ERPI weights based on export (fob) shares

 tradtotsh(ref)          = SUM((c,w),SAMG(c,w,ref))
                                /SUM((cp,wp,refp),SAMG(cp,wp,refp)) ;

* ## Initial values for variables

 CPI0(r)  = SUM(c, comtotsh(c,r) * PQCD0(c,r)) ;

 PPI0(r)   = SUM(c,vddtotsh(c,r) * PD0(c,r)) ;

 ERPI0   = SUM(ref, tradtotsh(ref) * ER0(ref)) ;

* ######## PRODUCTION BLOCK

PARAMETERS

 PX0(a,r)       Composite price of output by activity a

* ## Initial values for variables

* CES aggregation functions for Level 1 of production nest

 PVA0(a,r)      Value added price for activity a in r
 PINT0(a,r)     Price of aggregate intermediate input

 QX0(a,r)       Domestic production by activity a in r
 QVA0(a,r)      Quantity of aggregate value added for level 1 production

* Leontief aggregation functions for Level 1 of production nest

 QINT0(a,r)     Agg quantity of intermediates used by activity a in r

* CES aggregation functions for Level 2 of production nest

 WF0(ff,r)       Price of factor ff in r
 WFDIST0(ff,a,r) Sectoral proportion for factor prices in r
 WFA0(ff,a,r)    Factor prices ff by a in r

 V_FD0(ff,a,r)   Value of natural and aggregate factors used by activities
 
 FD0(ff,a,r)     Demand for factor f by activity a in r
 FS0(ff,r)       Supply of factor f in r

* Intermediate Input Demand

 QINTD0(c,r)    Demand for intermediate inputs by commodity in r

* Commodity Output

 QXC0(c,r)      Domestic production by commodity c in r

* Technology Parameters and Adjustment factors

 ADXADJ0(r)     Scaling Factor for Shift parameter on CES functions for QX
 DADX0(r)       Partial scaling factor for Shift parameter on CES functions for QX

 ADVAADJ0(r)    Scaling Factor for Shift parameter on CES functions for QVA
 DADVA0(r)      Partial scaling factor for Shift parameter on CES functions for QVA

 ADFDfADJ0(f)   Factor Scaling Factor for flow parameter on ADFD
 ADFDaADJ0(a)   Activity Scaling Factor for flow parameter on ADFD
 ADFDrADJ0(r)   Region Scaling Factor for flow parameter on ADFD

* CES aggregation functions for Level 1 of production nest

 mod_elastx(a,r) Level 1 CES elasticities used in the model

 adx0(a,r)      Initial Shift parameter for CES production functions for QX in r
 adxb(a,r)      Base Shift parameter for CES production functions for QX in r
 dabadx(a,r)    Change in base shift parameter on functions for QX
 adx01(a,r)     0-1 par for flexing of shift parameter on functions for QX

 predeltax(a,r) dummy used to estimated deltax
 deltax(a,r)    Share parameter for CES production functions for QX in r
 rhox(a,r)      Elasticity parameter for CES production function for QX in r
 thetax(a,r)    Share of QVA in QX

* Leontief aggregation functions for Level 1 of production nest

 use(c,a,r)      use matrix transactions
 ioqx(c,a,r) use matrix coefficients

 ioqintqx(a,r)  Agg intermed quantity per unit QX for Level 1 Leontief agg
 ioqvaqx(a,r)   Agg value added quant per unit QX for Level 1 Leontief agg

* CES aggregation functions for Level 2 of production nest

 mod_elastva(a,r) Level 2 CES elasticities used in the model

 adva0(a,r)     Initial Shift parameter for CES production functions for QVA
 advab(a,r)     Base Shift parameter for CES production functions for QVA
 dabadva(a,r)   Change in base shift parameter on functions for QVA
 adva01(a,r)    0-1 par for flexing of shift parameter on functions for QVA

 deltava(ff,a,r) Share parameters for CES production functions for QVA
 rhova(a,r)    Elasticity parameter for CES production function for QVA
 thetava(f,a,r) Share of primary factor in QVA
 
* CHECKS on deltava
 deltavaCHK(a,r)      check on deltava
 deltava_neg(ff,a,r)  CHECK that NO deltava are negative


 adfd0(ff,a,r)   Initial Shift parameter for factor and activity specific efficiency
 adfdb(ff,a,r)   Base Shift parameter for factor and activity specific efficiency
 dadfd(ff,a,r)   Change in shift parameter for factor and activity specific efficiency

* CES aggregation functions for Level 2 of production nest 
 adfag0(ff,a,r)      Initial Shift parameter for factor and activity specific efficiency
 adfagb(ff,a,r)      Base Shift parameter for factor and activity specific efficiency
* ELASTF(ff,a)      Production elasticities indexed on aggregate factors
 rhofd(ff,a,r)       Elasticity parameter for CES prodn fns for Aggregated FD
 deltafd(ff,ff,a,r)  CES Share parameters for Aggregated FD fag using ff by a
 
* CHECKS on deltafd
 deltafdCHK(ff,a,r)     CHECK that all deltafd sum to ONE
 deltafd_neg(ff,ff,a,r) CHECK that NO deltafd are negative
 
* Reporting the nesting structure

 nest_va(ff,a,r)     Value added nest
 nest_fd(ff,ff,a,r)  All nests below VA

* Intermediate Input Demand

 ioqint(c,a,r) intermediate input output coefficients

* Activity Output

 ioqxcqx(a,c,r) Share of commodity c in output by activity a

  ;

* #### Assignments

* Value of natural factors

 V_FD0(f,a,r)   = {SAMG(f,a,r) + SUM[tff$map_f_tff(f,tff),SAMG(tff,a,r)]} ;
 
* Value of aggregate factors

* V_FD0(fag,a) = SUM[ff$map_fagg_ff(fag,ff,a),SAM(ff,a)] ;

 V_FD0(fag,a,r) = SUM[ff$map_fagg_ff(fag,ff,a),V_FD0(ff,a,r)] ;

* ## Initial values for variables

 QX0(a,r)$PX0(a,r)      = SAMG("total",a,r)/PX0(a,r) ;
 QXC0(c,r)$PXC0(c,r)    = SUM(a,SAMG(a,c,r))/PXC0(c,r) ;

*(SAMG(c,"total",r) - SUM(w, SAMG(c,w,r)) )/QQ0(c,r)

 QINT0(a,r)$SUM(c,SAMG(c,a,r))   = SUM(c,SAMG(c,a,r)/PQD0(c,r)) ;

 QVA0(a,r)              = SUM(f,SAMG(f,a,r)) ;

 PINT0(a,r)$(QINT0(a,r))
             = SUM(c,(SAMG(c,a,r)/PQD0(c,r)/QINT0(a,r)) * PQD0(c,r)) ;

 PVA0(a,r)$QVA0(a,r)    = ( SUM(f,SAMG(f,a,r))+ SUM(tff, SAMG(tff,a,r)) )
                            /QVA0(a,r) ;

 QINTD0(c,r)$SUM(a,SAMG(c,a,r))  = SUM(a,SAMG(c,a,r)/PQD0(c,r)) ;

 FD0(f,a,r)              = FACTUSE(f,a,r) ;
 FS0(f,r)                = SUM(a,FACTUSE(f,a,r)) ;
 
*~~~~~ Factor prices for natural factors f

 WF0(f,r)$SUM(a, FD0(f,a,r))
                       = SUM(a,SAMG(f,a,r))/SUM(a, FD0(f,a,r)) ;

 WFDIST0(f,a,r)$FD0(f,a,r)
                         = (SAMG(f,a,r)/FD0(f,a,r))/WF0(f,r) ;

 WFDIST0(f,a,r)$(FD0(f,a,r) EQ 0)
                         = 0.0 ;

* WFA0(f,a,r)           = WF0(f,r) * WFDIST0(f,a,r) ;
 WFA0(f,a,r)$FD0(f,a,r)   = SAMG(f,a,r)/FD0(f,a,r) ;
 
*~~~~~ Calibrating factor quantities and prices for aggregate factors

 FD0(fag,a,r)  = V_FD0(fag,a,r) ;

Parameter
 neg_FD0(ff,a,r)   Identify neg_FD0
 CHK_neg_FD0       CHECK on neg_FD0
  ;

 neg_FD0(ff,a,r)$(FD0(ff,a,r) LT 0.0) = FD0(ff,a,r) ;
 CHK_neg_FD0 = SUM[(ff,a,r)$neg_FD0(ff,a,r), 1 ] ;

Display neg_FD0, CHK_neg_FD0 ;

ABORT $(CHK_neg_FD0 GT 0.0)
  "At least ONE factor demand (FD0) is negative" ;

 FS0(fag,r)    = SUM[a,FD0(fag,a,r)] ;

 WF0(fag,r)$SUM[a, FD0(fag,a,r)]
             = SUM[a,V_FD0(fag,a,r)]/SUM[a, FD0(fag,a,r)] ;

* WF0(fag)$[FS0(fag)] = 1.0 ;

 WFA0(fag,a,r)$FD0(fag,a,r)
             = V_FD0(fag,a,r)/FD0(fag,a,r) ;

 WFDIST0(fag,a,r)$FD0(fag,a,r)
             = {V_FD0(fag,a,r)/FD0(fag,a,r)}/WF0(fag,r) ;

 WFDIST0(fag,a,r)$[FD0(fag,a,r) EQ 0] = 0.0 ;

 QINTD0(c,r)$PQD0(c,r)    = SUM(a,SAMG(c,a,r)/PQD0(c,r)) ;

* Technology Parameters and Adjustment factors

 ADXADJ0(r)       = 1.0 ;
 DADX0(r)         = 0.0 ;

 ADVAADJ0(r)      = 1.0 ;
 DADVA0(r)        = 0.0 ;

 ADFDfADJ0(f)     = 1.0 ;
 ADFDaADJ0(a)     = 1.0 ;
 ADFDrADJ0(r)     = 1.0 ;

* ADFD0(ff,a,r)     = 1.0 ;

* CES aggregation functions for Level 1 of production nest

$ontext
Choice of elasticities for substitution at Level 1 Production Function
  Selection controlled by value of mod_cont("qxelast")
   a) IF mod_cont("qxelast") = 1
        ALL elasticities for Level 1 Production are from Excel - ELASTX

   b) IF mod_cont("qxelast") = 2
        Elast'ies for Level 1 Production are from GTAP - ELASTVAG/qxscal

$offtext

IF (mod_cont("qxelast") = 1,

 mod_elastx(a,r)   = ELASTX(a,r) ;

  ) ;

IF (mod_cont("qxelast") = 2,

 mod_elastx(a,r)   = ELASTVAG(a,r)/mod_cont("qxscal") ;

 mod_elastx(a,r)$(mod_elastx(a,r) GT 0.95 and mod_elastx(a,r) LE 1.0) = 0.95 ;
 mod_elastx(a,r)$(mod_elastx(a,r) GT 1.0 and mod_elastx(a,r) LT 1.05) = 1.05 ;

  ) ;

 rhox(a,r)    = (1/mod_elastx(a,r)) - 1 ;
 
 deltax(a,r)$(QINT0(a,r))
               = (PVA0(a,r)*QVA0(a,r)**(1+rhox(a,r)) )
                   /(PVA0(a,r)*QVA0(a,r)**(1+rhox(a,r))
                      + PINT0(a,r)*QINT0(a,r)**(1+rhox(a,r))) ;

$ontext
 predeltax(a,r)$(QINT0(a,r))
               = (PVA0(a,r)/PINT0(a,r))*(QVA0(a,r)/QINT0(a,r))**(1+rhox(a,r)) ;
 deltax(a,r)
               = predeltax(a,r)/(1.0+predeltax(a,r)) ;
$offText

 adx0(a,r)$deltax(a,r)
           = QX0(a,r)/(deltax(a,r)*QVA0(a,r)**(-rhox(a,r))
             +(1-deltax(a,r))*QINT0(a,r)**(-rhox(a,r)))**(-1/rhox(a,r)) ;

 adxb(a,r)       = adx0(a,r) ;
 dabadx(a,r)     = 0.0 ;
 adx01(a,r)      = 0.0 ;

 thetax(a,r)$deltax(a,r)  = PVA0(a,r)*QVA0(a,r)/
                            (PINT0(a,r)*QINT0(a,r) + PVA0(a,r)*QVA0(a,r) ) ;

* Leontief aggregation functions for Level 1 of production nest

 use(c,a,r)$SAMG("total",a,r)
               = SAMG(c,a,r)/SAMG("total",a,r) ;

 ioqx(c,a,r)$(QX0(a,r) AND PQD0(c,r))
               = (SAMG(c,a,r)/PQD0(c,r))/QX0(a,r) ;

 ioqintqx(a,r)$QX0(a,r)   = QINT0(a,r)/QX0(a,r) ;

 ioqvaqx(a,r)$QX0(a,r)    = QVA0(a,r)/QX0(a,r) ;

* CES aggregation functions for Level 2 of production nest

Parameter
 tf02(ff,a,r)  tf for calibration of production functions
  ;

 tf02(f,a,r)$SAMG(f,a,r)  = ((SUM(tff$map_f_tff(f,tff),SAMG(tff,a,r)))
                                 /SAMG(f,a,r)) ;
                                                                
* By construction factor use taxes are only paid on Natural factors see V_FD0 above

 tf02(fag,a,r)            = 0.0 ;


$ontext
Choice of elasticities for substitution at Level 2 Production Function
  Selection controlled by value of mod_cont("qvaelast")
   a) IF mod_cont("qvaelast") = 1
        ALL elasticities for Level 2 Production are from Excel - ELASTVA

   b) IF mod_cont("qvaelast") = 2
        Elast'ies for Level 2 Production are from GTAP - ELASTVAG

$offtext

IF (mod_cont("qvaelast") = 1,

 mod_elastva(a,r)   = ELASTVA(a,r) ;

  ) ;

IF (mod_cont("qvaelast") = 2,

 mod_elastva(a,r)   = ELASTVAG(a,r) ;

 mod_elastva(a,r)$(mod_elastva(a,r) GT 0.95 and mod_elastva(a,r) LE 1.0) = 0.95 ;
 mod_elastva(a,r)$(mod_elastva(a,r) GT 1.0 and mod_elastva(a,r) LT 1.05) = 1.05 ;

  ) ;

 rhova(a,r)   = (1/mod_elastva(a,r)) - 1 ;


* share parameters WITH factor use taxes - tf0(f,a,r)

 deltava(ff,a,r)$[map_va_ff(ff,a) AND FD0(ff,a,r)]
            = {[WF0(ff,r)*WFDIST0(ff,a,r)]*[1+tf02(ff,a,r)]*[FD0(ff,a,r)]**[1+rhova(a,r)]}
              / SUM{ffp$map_va_ff(ffp,a),
                    [WF0(ff,r)*WFDIST0(ff,a,r)]*[1+tf02(ffp,a,r)]
                    *[FD0(ffp,a,r)]**[1+rhova(a,r)]} ;
                    
 deltavaCHK(a,r)  = [SUM(ff,deltava(ff,a,r))] - 1.0 ;

 deltavaCHK(a,r)$[ABS(deltavaCHK(a,r)) GT 0.0000000000000]   = 0.00 ;

 deltava_neg(ff,a,r)$[deltava(ff,a,r) LT 0.000]  = 1.00 ;

ABORT $(SUM[(a,r),deltavaCHK(a,r)] NE 0.0)
 "SUM of ONE OR MORE deltava is not ONE - view deltava and deltavaCHK" ;

ABORT $(SUM[(ff,a,r),deltava_neg(ff,a,r)] NE 0.0)
 "ONE OR MORE deltava is negative - view deltava and deltava_neg" ;
 
 ADVA0(a,r)$SUM(ff$map_va_ff(ff,a),deltava(ff,a,r)*FD0(ff,a,r))
                   = QVA0(a,r)/(SUM(ff$map_va_ff(ff,a),deltava(ff,a,r)*FD0(ff,a,r)
                    **(-rhova(a,r))))**(-1/rhova(a,r));

$onText
* deltava(f,a,r)$SAMG(f,a,r)
*          = (WFDIST0(f,a,r)*WF0(f,r)*(1+tf02(f,a,r))*(FD0(f,a,r))**(1+rhova(a,r)))
*            /SUM(fp,WFDIST0(fp,a,r)*WF0(fp,r)*(1+tf02(fp,a,r))*(FD0(fp,a,r))
             **(1+rhova(a,r))) ;

 adva0(a,r)$SUM(f,SAMG(f,a,r))
          = QVA0(a,r)/(SUM(f$(FD0(f,a,r)),deltava(f,a,r)*FD0(f,a,r)
                 **(-rhova(a,r))))**(-1/rhova(a,r));
$offText

 advab(a,r)      = adva0(a,r) ;
 dabadva(a,r)    = 0.0 ;
 adva01(a,r)     = 0.0 ;

 thetava(f,a,r)$SAMG(f,a,r)
          = WFDIST0(f,a,r)*WF0(f,r)*(1+tf02(f,a,r))*(FD0(f,a,r))/
            SUM(fp,WFDIST0(fp,a,r)*WF0(fp,r)*(1+tf02(f,a,r))*FD0(fp,a,r)) ;

 adfd0(ff,a,r)    = 1.0 ;
 adfdb(ff,a,r)    = adfd0(ff,a,r) ;
 dadfd(ff,a,r)    = 0.0 ;
 
* CES aggregation functions for Level 3 of production nest

 rhofd(fag,a,r)   = (1/ELASTFD(fag,a,r)) - 1 ;
 
Parameter

 test_deltafd(ff,a,r)  Denominator for deltafd calculation
;

 test_deltafd(ff,a,r) ={SUM(ffpp$map_fagg_ff(ff,ffpp,a),
                       [WF0(ffpp,r)*WFDIST0(ffpp,a,r)]*[1+tf02(ffpp,a,r)]*(FD0(ffpp,a,r))
                         **[1+rhofd(ff,a,r)])} ;

 deltafd(ff,ffp,a,r)${map_fagg_ff(ff,ffp,a) AND SUM[ffpp$map_fagg_ff(ff,ffpp,a), FD0(ffpp,a,r)] }
            = {[WF0(ffp,r)*WFDIST0(ffp,a,r)]*[1+tf02(ffp,a,r)]*(FD0(ffp,a,r))
                       **[1+rhofd(ff,a,r)]}
              /{SUM(ffpp$map_fagg_ff(ff,ffpp,a),
                  [WF0(ffpp,r)*WFDIST0(ffpp,a,r)]*[1+tf02(ffpp,a,r)]*(FD0(ffpp,a,r))
                       **[1+rhofd(ff,a,r)])} ;


* deltafdCHK(ff,a,r)$fag(ff)  = SUM(ffp$map_fagg_ff(ff,ffp,a),deltafd(ff,ffp,a,r)) ;
 deltafdCHK(ff,a,r)$fag(ff)  = SUM(ffp$map_fagg_ff(ff,ffp,a),deltafd(ff,ffp,a,r)) - 1.0 ;

 deltafdCHK(ff,a,r)$[ABS(deltafdCHK(ff,a,r)) GT 0.0000000000000]   = 0.00 ;

 deltafd_neg(ff,ff,a,r)$[deltafd(ff,ff,a,r) LT 0.000]  = 1.00 ;

Option decimals = 8

Display deltafdCHK, deltafd_neg ;

ABORT $(SUM[(ff,a,r),deltafdCHK(ff,a,r)] NE 0.0)
 "SUM of ONE OR MORE deltafd is not ONE - view deltafd and deltafdCHK" ;

ABORT $(SUM[(ff,ffp,a,r),deltafd_neg(ff,ffp,a,r)] NE 0.0)
 "ONE OR MORE deltafd is negative - view deltafd and deltafd_neg" ;

 
 adfag0(ff,a,r)${SUM[ffp,map_fagg_ff(ff,ffp,a)] AND SUM[ffp$map_fagg_ff(ff,ffp,a),FD0(ffp,a,r)]  }
                = FD0(ff,a,r)
                 /{ SUM[ffp$map_fagg_ff(ff,ffp,a),
                    deltafd(ff,ffp,a,r)*FD0(ffp,a,r)**(-rhofd(ff,a,r))] }
                    **[-1/rhofd(ff,a,r)] ;
                    
* adfag0(ff,a,r) = adfag(ff,a,r) ;
 
* Reporting the nesting structure

 nest_va(ff,a,r)$[deltava(ff,a,r) GT 0.0]    = 1.0 ;
 nest_fd(ff,ffp,a,r)$[deltafd(ff,ffp,a,r) GT 0.0]    = 1.0 ;

* Intermediate Input Demand

 ioqint(c,a,r)$(QINT0(a,r) AND PQD0(c,r))
               = SAMG(c,a,r)/PQD0(c,r)/QINT0(a,r) ;

* Activity Output

 ioqxcqx(a,c,r)$acx(a,r)         = SAMG(a,c,r)/SUM(cp,SAMG(a,cp,r)) ;

* ######## FACTOR BLOCK

PARAMETERS

* ## Initial values for variables

 YF0(f,r)        Income to factor f
 YFDIST0(f,r)    Factor income for distribution after depreciation

* ## Savings Expenditures

 deprec(f,r)      depreciation rate by factor f on stock of factor f

* ## Transfer Expenditures

 hvash(h,f,r)     Share of income from factor f to household h

  ;

* #### Assignments

* ## Initial values for variables

 YF0(f,r)      = SAMG("total",f,r) ;
 YFDIST0(f,r)  = (SAMG("total",f,r) - SAMG("i_s",f,r) - SAMG("dirtax",f,r)) ;

* ## Savings Expenditures

 deprec(f,r)$SAMG("total",f,r)     = SAMG("i_s",f,r)/SAMG("total",f,r) ;

* ## Transfer Expenditures

 hvash(h,f,r)$SAMG("total",f,r)    = SAMG(h,f,r)/
                    (SAMG("total",f,r) - SAMG("i_s",f,r) - SAMG("dirtax",f,r)) ;

* ######## HOUSEHOLD BLOCK

PARAMETERS

* ## Initial values for variables

 YH0(h,r)        Income to household h
 HEXP0(h,r)      Household consumption expenditure

 QCD0(c,h,r)     Household consumption by commodity c

* ## Transfer Expenditures

* ## Consumption Expenditures
* # Cobb Douglas Utility function

 comhav(c,h,r)    Household consumption shares

* # Stone-Geary Utility function

 sumelast(h,r)    Weighted sum of income elasticities
 yhelast(c,h,r)   (Normalised) household income elasticities
 beta(c,h,r)      Marginal budget shares
 hexps(h,r)       Subsistence consumption expenditure
 frisch(h,r)      Elasticity of the marginal utility of income
 qcdconst(c,h,r)  Volume of subsistence consumption

  ;

* #### Assignments

* ## Initial values for variables

 YH0(h,r)               = SAMG("total",h,r) ;

 HEXP0(h,r)             = SUM(c,SAMG(c,h,r)) ;
 QCD0(c,h,r)$PQCD0(c,r) = SAMG(c,h,r)/PQCD0(c,r) ;

* ## Transfer Expenditures


* ## Consumption Expenditures
* # Cobb Douglas Utility function

 comhav(c,h,r)$HEXP0(h,r)   = SAMG(c,h,r)/SUM(cp,SAMG(cp,h,r)) ;

* # Stone-Geary Utility function
* Weighted sum of the expenditures elasticities must equal one.
* Weights are average budget shares. Normalised elasticities will satisfy
* Engel aggregation

 sumelast(h,r)   = SUM(c, comhav(c,h,r)*ELASTY(c,h,r)) ;

 yhelast(c,h,r)$sumelast(h,r)
               = ELASTY(c,h,r)/sumelast(h,r) ;

 yhelast(c,h,r)$(comhav(c,h,r) eq 0)  = 0 ;

 beta(c,h,r)     = yhelast(c,h,r)*comhav(c,h,r) ;

 frisch(h,r)     = ELASTF(r,h) ;

 qcdconst(c,h,r)$(PQCD0(c,r) and frisch(h,r))
               = (HEXP0(h,r)/PQCD0(c,r))*(comhav(c,h,r)+(beta(c,h,r)/frisch(h,r))) ;

 hexps(h,r)      = SUM(c,qcdconst(c,h,r) * PQCD0(c,r)) ;

* ######## GOVERNMENT BLOCK

* #### Government Income Block

* ## Government Taxes

PARAMETERS
* ## Initial values for overall scaling variables
 TEADJ0(r)       Export subsidy Scaling Factor
 TMADJ0(r)       Tarrif rate Scaling Factor
 TSADJ0(r)       Sales tax rate scaling factor
 TVADJ0(r)       Value added tax rate scaling factor
 TXADJ0(r)       Indirect Tax Scaling Factor
 TYFADJ0(r)      Factor income Tax Scaling Factor
 TYHADJ0(r)      Income Tax Scaling Factor
 TFADJ0(r)       Factor Use Tax Scaling Factor

* ## Initial values for partial scaling variables
 DTE0(r)         Partial Export tax rate scaling factor
 DTM0(r)         Partial Tariff rate scaling factor
 DTS0(r)         Partial Sales tax rate scaling factor
 DTV0(r)         Partial Value added tax rate scaling factor
 DTX0(r)         Partial Indirect tax rate scaling factor
 DTYF0(r)        Partial direct tax on factor rate scaling factor
 DTYH0(r)        Partial direct tax on household rate scaling factor
 DTF0(r)         Uniform adjustment to factor use tax by activity

* ## Initial tax revenues
 MTAX0(r)        Tariff revenue
 ETAX0(r)        Export tax revenue
 FTAX0(r)        Factor use tax revenue
 FYTAX0(r)       Factor income tax revenue
 ITAX0(r)        Indirect tax revenue
 HTAX0(r)        Household income tax
 STAX0(r)        Sales tax revenue
 VTAX0(r)        Value added tax revenue

* ## base tax rates
 teb(c,w,r)      Export tax rates on exports of comm'y c to region w
 tmb(w,c,r)      Tariff rates on comm'y imported from region w
 tsb(c,r)        Base sales tax rate
 tvb(c,r)        Base value added tax rate
 txb(a,r)        Base indirect tax rate on activity a
 tyfb(f,r)       Factor income tax rate
 tyhb(h,r)       Direct tax rate on household h
 tfb(ff,a,r)     Factor use tax rate

 te0(c,w,r)      Export tax rates on exports of comm'y c to region w
 tm0(w,c,r)      Tariff rates on comm'y imported from region w
 ts0(c,r)        Base sales tax rate
 tv0(c,r)        Base value added tax rates
 tx0(a,r)        Base indirect tax rate on activity a
 tyf0(f,r)       Factor income tax rate
 tyh0(h,r)       Direct tax rate on household h
 tf0(ff,a,r)     Factor use tax rate

* ## absolute changes in base tax rates

 dabte(c,w,r)    Change in base export taxes on comm'y imported from region w
 dabtm(w,c,r)    Change in base tariff rates on comm'y imported from region w
 dabts(c,r)      Change in base sales tax rate
 dabtv(c,r)      Change in value added tax rate
 dabtx(a,r)      Change in base indirect tax rate
 dabtyf(f,r)     Change in base direct tax rate on factors
 dabtyh(h,r)     Change in base direct tax rate on households
 dabtf(ff,a,r)   Change in base factor us tax rate on activities

* ## partial changes in tax rates

 te01(c,w,r)     0-1 par for potential flexing of export taxes on comm'ies
 tm01(w,c,r)     0-1 par for potential flexing of Tariff rates on comm'ies
 ts01(c,r)       0-1 par for potential flexing of sales tax rates
 tv01(c,r)       0-1 par for potential flexing of value added tax rates
 tx01(a,r)       0-1 par for potential flexing of indirect tax rates
 tyf01(f,r)      0-1 par for potential flexing of direct tax rates on factors
 tyh01(h,r)      0-1 par for potential flexing of direct tax rates on h'holds
 tf01(ff,a,r)    0-1 par for potential flexing of factor use tax rates

  ;

* #### Assignments

* ## Initial values for scaling variables
 TEADJ0(r)       = 1.0 ;
 TMADJ0(r)       = 1.0 ;
 TYFADJ0(r)      = 1.0 ;
 TSADJ0(r)       = 1.0 ;
 TVADJ0(r)       = 1.0 ;
 TXADJ0(r)       = 1.0 ;
 TYHADJ0(r)      = 1.0 ;
 TFADJ0(r)       = 1.0 ;

* ## Initial values for partial scaling variables

 DTE0(r)         = 0.0 ;
 DTM0(r)         = 0.0 ;
 DTS0(r)         = 0.0 ;
 DTV0(r)         = 0.0 ;
 DTX0(r)         = 0.0 ;
 DTYF0(r)        = 0.0 ;
 DTYH0(r)        = 0.0 ;
 DTF0(r)         = 0.0 ;

* ## Initial tax revenues
 MTAX0(r)       = SUM((c,w), SUM(tmr$map_w_tmr(w,tmr), SAMG(tmr,c,r))) ;
 ETAX0(r)       = SUM((c,w), SUM(ter$map_w_ter(w,ter), SAMG(ter,c,r))) ;
 STAX0(r)       = SUM(c,SAMG("saltax",c,r)) ;
 VTAX0(r)       = SUM(c,SAMG("vattax",c,r)) ;
 ITAX0(r)       = SUM(a,SAMG("prodtax",a,r)) ;
 FYTAX0(r)      = SUM(f,SAMG("dirtax",f,r)) ;
 HTAX0(r)       = SUM(h,SAMG("dirtax",h,r)) ;
 FTAX0(r)       = SUM((f,a),SUM(tff$map_f_tff(f,tff),SAMG(tff,a,r))) ;

* ## tax rates

 te0(c,w,r)$cer(c,w,r)        = SUM(ter$map_w_ter(w,ter), SAMG(ter,c,r))
                                 /SAMG(c,w,r) ;

 tm0(w,c,r)$cmr(w,c,r)        = SUM(tmr$map_w_tmr(w,tmr), SAMG(tmr,c,r))
                                 /(SAMG(w,c,r)
                                   + SUM(cp$ct(cp,r),IMPMARG(w,cp,c,r))) ;

 ts0(c,r)$(SUM(a,SAMG(c,a,r)) + SUM(h,SAMG(c,h,r)) + SAMG(c,"govt",r)
                              + SAMG(c,"i_s",r) - SAMG("saltax",c,r))
                 = SAMG("saltax",c,r)/(SUM(a,SAMG(c,a,r))
                                       + SUM(h,SAMG(c,h,r))
                                       + SAMG(c,"govt",r)
                                       + SAMG(c,"i_s",r)
                                       - SAMG("saltax",c,r)
                                       - SAMG("vattax",c,r)) ;

 tv0(c,r)$(SUM(h, SAMG(c,h,r)) - SAMG("vattax",c,r))
               = SAMG("vattax",c,r)/(SUM(h, SAMG(c,h,r)) - SAMG("vattax",c,r)) ;

 tx0(a,r)$SAMG("total",a,r)
               = SAMG("prodtax",a,r)/SAMG("total",a,r) ;

 tyf0(f,r)$(SAMG("total",f,r) - SAMG("i_s",f,r))
               = SAMG("dirtax",f,r)/(SAMG("total",f,r) - SAMG("i_s",f,r)) ;

 tyh0(h,r)$SAMG("total",h,r)
               = SAMG("dirtax",h,r)/SAMG("total",h,r) ;

 tf0(f,a,r)$SAMG(f,a,r)     = SUM(tff$map_f_tff(f,tff),SAMG(tff,a,r))
                               /SAMG(f,a,r) ;

 tf0(fag,a,r)   = 0.0 ;

 teb(c,w,r)     = te0(c,w,r) ;
 tmb(w,c,r)     = tm0(w,c,r) ;
 tsb(c,r)       = ts0(c,r) ;
 tvb(c,r)       = tv0(c,r) ;
 txb(a,r)       = tx0(a,r) ;
 tyfb(f,r)      = tyf0(f,r) ;
 tyhb(h,r)      = tyh0(h,r) ;
 tfb(ff,a,r)    = tf0(ff,a,r) ;

* ## absolute changes in base tax rates

 dabte(c,w,r)   = 0.0 ;
 dabtm(w,c,r)   = 0.0 ;
 dabts(c,r)     = 0.0 ;
 dabtv(c,r)     = 0.0 ;
 dabtx(a,r)     = 0.0 ;
 dabtyf(f,r)    = 0.0 ;
 dabtyh(h,r)    = 0.0 ;
 dabtf(ff,a,r)  = 0.0 ;

* ## partial changes in tax rates

 te01(c,w,r)    = 1.0 ;
 tm01(w,c,r)    = 1.0 ;
 ts01(c,r)      = 1.0 ;
 tV01(c,r)      = 1.0 ;
 tx01(a,r)      = 1.0 ;
 tyf01(f,r)     = 1.0 ;
 tyh01(h,r)     = 1.0 ;
 tf01(f,a,r)    = 1.0 ;

* #### Government Income and Expenditure Block

PARAMETERS
* ## Initial values for scaling variables

 QGDADJ0(r)      Government consumption demand scaling factor

* ## Initial values for variables

 YG0(r)          Government income
 QGD0(c,r)       Government consumption demand
 EG0(r)          Expenditure by government

* ## Transfer Expenditures

* ## Consumption Expenditures

 qgdconst(c,r)  Government demand volume
 qgdconst0(c,r) Initial Government demand volume

  ;

* #### Assignments

* ## Initial values for scaling variables

 QGDADJ0(r)  = 1.0 ;

* ## Initial values for variables

 YG0(r)                  = SAMG("total","govt",r) ;
 QGD0(c,r)$PQD0(c,r)     = SAMG(c,"govt",r)/PQD0(c,r) ;

 EG0(r)                  = YG0(r) - SAMG("i_s","govt",r) ;

* ## Transfer Expenditures


* ## Consumption Expenditures

 qgdconst(c,r)$PQD0(c,r) = SAMG(c,"govt",r)/PQD0(c,r) ;

 qgdconst0(c,r)          = qgdconst(c,r) ;

* ######## KAPITAL BLOCK

PARAMETERS
* ## Initial values for scaling variables

 SADJ0(r)        Savings rate scaling factor
 IADJ0(r)        Investment scaling factor
 DSHH0(r)        Partial household savings rate scaling factor

* ## Initial values for variables

 INVEST0(r)      Total investment expenditure
 QINVD0(c,r)     Investment consumption by commodity c
 TOTSAV0(r)      Total savings

* ## base savings rates
 shh0(h,r)       Initial Household saving rates
 shhb(h,r)       Base Household saving rates

* ## absolute changes in base savings rates

 dabshh(h,r)     Change in base Household saving rates

* ## partial changes in savings rates
 shh01(h,r)      0-1 par for potential flexing of Household saving rates

* ## Consumption Expenditures

 qinvdconst(c,r)    Investment demand volume
 qinvdconst0(c,r)   Initial Investment demand volume

  ;

* #### Assignments

* ## Initial values for scaling variables

 SADJ0(r)      = 1.0 ;
 IADJ0(r)      = 1.0 ;

 DSHH0(r)      = 0.0 ;

* ## Initial values for variables

 QINVD0(c,r)$PQD0(c,r) = SAMG(c,"i_s",r)/PQD0(c,r) ;
 INVEST0(r)            = SAMG("total","i_s",r) ;
 TOTSAV0(r)            = SAMG("i_s","total",r) ;

* ## base savings rates

 shh0(h,r)$SAMG("total",h,r)
                      = SAMG("i_s",h,r)
                        /(SAMG("total",h,r) - SAMG("dirtax",h,r)) ;

 shhb(h,r)      = shh0(h,r) ;

* ## absolute changes in base savings rates

 dabshh(h,r)          = 0.0 ;

* ## partial changes in savings rates

 shh01(h,r)           = 0.0 ;

* ## Consumption Expenditures

 qinvdconst(c,r)$PQD0(c,r)   = SAMG(c,"i_s",r)/PQD0(c,r) ;
 qinvdconst0(c,r)            = qinvdconst(c,r) ;

* ######## FOREIGN INSTITUTIONS BLOCK

*PARAMETERS

* ## Initial values for variables

* ## Savings Expenditures

* ## Transfer Expenditures


* #### Assignments

* ## Initial values for variables


* ## Transfer Expenditures


* ######## MARKET CLEARING BLOCK

PARAMETERS
* ## Initial values for variables

* # Account Closure

 KAPGOV0(r)      Government Savings
 KAPWOR0(r)      Current account balance
 KAPREG0(w,r)    Bilateral current account balance

* # Absorption Closure

 VFDOMD0(r)      Value of final domestic demand
 INVESTSH0(r)    Value share of investment in total final dom demand
 VGDSH0(r)       Value share of Govt consump in total final dom demand

* # Slack

 WALRAS0(r)      Slack variable for Walras's Law
 KAPWOR_SL0      Slack variable for global system for regions
 GLB_SL0     Slack variable for Globe

  ;

* #### Assignments

* ## Initial values for variables
* # Account Closure

 KAPGOV0(r)    = SAMG("i_s","govt",r) ;
 KAPWOR0(r)    = SUM(w, SAMG("i_s",w,r)) ;
 KAPREG0(w,r)  = SAMG("i_s",w,r) ;


* # Absorption Closure

 VFDOMD0(r)    = SUM((c,h),SAMG(c,h,r))
                  + SUM(c,SAMG(c,"govt",r))
                  + SUM(c,SAMG(c,"i_s",r)) ;

 INVESTSH0(r)$VFDOMD0(r)
               = SUM(c,SAMG(c,"i_s",r))/VFDOMD0(r) ;

 VGDSH0(r)$VFDOMD0(r)
               = SUM(c,SAMG(c,"govt",r))/VFDOMD0(r) ;

* # Slack

 WALRAS0(r)   = 0 ;
 KAPWOR_SL0   = SUM(r, KAPWOR0(r))    ;
 GLB_SL0  = 0 ;


* ------ VARIOUS CHECKS FOR CALIBRATION OF PARAMETERS

 OPTION decimals = 6 ;

* TEST FOR ZEROES
PARAMETER
 TOTCON(r)           Total consumption
 TOTPROD(r)          Total production
 HCON(c,r)           Household consumption

 deltavacheck(a,r)   Check on deltava

 gammarchk(c,r)      Check on gammar

 checkcomtotsh(r)    Check on CPI weights

  ;

 TOTCON(r)           = SUM((c,h),SAMG(c,h,r)) ;
 TOTPROD(r)          = SUM((ap,cp),SAMG(ap,cp,r)) ;

 deltavacheck(a,r)   = SUM(f,deltava(f,a,r)) ;

 gammarchk(c,r)      = sum(w, gammar(c,w,r)) ;

 checkcomtotsh(r)    = SUM(c,comtotsh(c,r)) ;

 display deltavacheck,
         checkcomtotsh,
         gammarchk ;


* CALIBRATION CHECK

 PARAMETER
 QMCALIB(c,r)       CALIBRATED VALUE OF QM0
 QMDIFF(c,r)        DIFFERENCE BETWEEN CALIBRATED AND ACTUAL QM0
 QECALIB(c,r)       CALIBRATED VALUE OF QE0
 QEDIFF(c,r)        DIFFERENCE BETWEEN CALIBRATED AND ACTUAL QE0

;
$ontext
 QMCALIB(c,r) = acr(c,r)*SUM(w, deltar(w,c,r)*QMR0(w,c,r)
                        **(-rhom(c,r)) )**(-1/rhom(c,r)) ;

 QMDIFF(c,r)  = QMCALIB(c,r) - QM0(c,r) ;
$offtext

 QECALIB(c,r) = atr(c,r)*SUM(w, gammar(c,w,r)*QER0(c,w,r)
                        **(rhoe(c,r)) )**(1/rhoe(c,r)) ;

 QEDIFF(c,r)  = QECALIB(c,r) - QE0(c,r) ;


DISPLAY QEDIFF, qecalib;
*DISPLAY QMDIFF, qmcalib;
 ;

PARAMETER
 COMTAXM0(r)   M Taxes
 COMTAXE0(r)   E Taxes
 COMTAXS0(r)   S Taxes
 COMTAXT0(r)   Total Com Taxes
   ;

 COMTAXM0(r) = SUM((tmr,c),SAMG(tmr,c,r)) ;

 COMTAXE0(r) = SUM((ter,c),SAMG(ter,c,r)) ;

 COMTAXS0(r) = SUM((g,c),SAMG(g,c,r)) ;

 COMTAXT0(r) = SUM((tmr,c),SAMG(tmr,c,r))
                + SUM((ter,c),SAMG(ter,c,r))
                + SUM((g,c),SAMG(g,c,r)) ;

 OPTION decimals = 3 ;

* -------------- END OF anar_t parameter declaration & assignments ------
