* -------------- anar_t result SAMs ------------------------------------------

*#### GENERATE NEW GLOBAL SAMG FOR EACH EXPERIMENT

* SAM assignment statements by ROWS of the Regional SAMs

$ontext

The data are stored as SAMG. For ALL regions the model uses a SAM that has the
following structure of potentially active submatrices: X marks submatrices
active in the database and model.

       1     2     3     4     5     6     7     8     9     10    11    12
    � COM � ACT � FAC � HOU � TM  � TE  � ITX � YTX � GOV � KAP � MAR � ROW
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
COM �  0  �  X  �  0  �  X  �  0  �  0  �  0  �  0  �  X  �  X  �  0  �  X
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
ACT �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
FAC �  0  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
HOU �  0  �  0  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
TM  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
TE  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
ITX �  X  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
YTX �  0  �  0  �  X  �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
GOV �  0  �  0  �  0  �  0  �  X  �  X  �  X  �  X  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
KAP �  0  �  0  �  X  �  X  �  0  �  0  �  0  �  0  �  X  �  0  �  0  �  X
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
MAR �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----
ROW �  X  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  0  �  X  �  0
----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----�-----

$offtext

* OPTION DECIMALS = 6 ;

* -------- Commodity Accounts ---------

 SAMG3(c,a,r,%res_dimen%)
              = ioqint(c,a,r) * ioqintqx(a,r) * lev_QX(a,r,%res_dimen%)
                      * lev_PQD(c,r,%res_dimen%) ;

 SAMG3(c,h,r,%res_dimen%)
              = lev_QCD(c,h,r,%res_dimen%) * lev_PQCD(c,r,%res_dimen%) ;

 SAMG3(c,"govt",r,%res_dimen%)
              = lev_QGD(c,r,%res_dimen%) * lev_PQD(c,r,%res_dimen%) ;

 SAMG3(c,"I_S",r,%res_dimen%)
              = lev_QINVD(c,r,%res_dimen%) * lev_PQD(c,r,%res_dimen%) ;

 SAMG3(c,w,r,%res_dimen%)
              = lev_QER(c,w,r,%res_dimen%) * lev_PWE(c,w,r,%res_dimen%)
                  * lev_ER(r,%res_dimen%) ;

* -------- Activity Accounts ----------

 SAMG3(a,c,r,%res_dimen%)
              = ioqxcqx(a,c,r) * lev_PXC(c,r,%res_dimen%)
                   * lev_QX(a,r,%res_dimen%) ;

* -------- Factor Accounts ------------

 SAMG3(f,a,r,%res_dimen%)
              = lev_FD(f,a,r,%res_dimen%) * lev_WF(f,r,%res_dimen%)
                  * lev_WFDIST(f,a,r,%res_dimen%) ;

* -------- Household Accounts ---------

 SAMG3(h,f,r,%res_dimen%)
              = hvash(h,f,r) * lev_YFDIST(f,r,%res_dimen%) ;

* -------- Tariff Accounts ------------

 SAMG3(tmr,c,r,%res_dimen%)
              = SUM(w$MAP_TMR_W(tmr,w),lev_TM(w,c,r,%res_dimen%)
                    * lev_PWM(w,c,r,%res_dimen%) * lev_QMR(w,c,r,%res_dimen%)
                    * lev_ER(r,%res_dimen%)) ;

* -------- Export Duty Accounts -------

 SAMG3(ter,c,r,%res_dimen%)
              = SUM(w$MAP_TER_W(ter,w),lev_TE(c,w,r,%res_dimen%)
                    * lev_PWE(c,w,r,%res_dimen%) * lev_ER(r,%res_dimen%)
                    * lev_QER(c,w,r,%res_dimen%)) ;

* -------- Indirect Tax Accounts ------

 SAMG3("saltax",c,r,%res_dimen%)
              = lev_TS(c,r,%res_dimen%) * lev_PQS(c,r,%res_dimen%)
                     * lev_QQ(c,r,%res_dimen%) ;

 SAMG3("vattax",c,r,%res_dimen%)
              = SUM(h, lev_TV(c,r,%res_dimen%) * lev_PQD(c,r,%res_dimen%)
                     * lev_QCD(c,h,r,%res_dimen%)) ;

 SAMG3(tff,a,r,%res_dimen%)
              = SUM(f$MAP_TFF_F(tff,f),lev_TF(f,a,r,%res_dimen%)
                    * lev_WF(f,r,%res_dimen%) * lev_WFDIST(f,a,r,%res_dimen%)
                    * lev_FD(f,a,r,%res_dimen%)) ;

 SAMG3("prodtax",a,r,%res_dimen%)
              = lev_TX(a,r,%res_dimen%) * lev_PX(a,r,%res_dimen%)
                      * lev_QX(a,r,%res_dimen%) ;

* -------- Direct Tax Accounts --------

 SAMG3("dirtax",f,r,%res_dimen%)
              = lev_TYF(f,r,%res_dimen%) * (1-deprec(f,r))
                       * lev_YF(f,r,%res_dimen%) ;

 SAMG3("dirtax",h,r,%res_dimen%)
              = lev_TYH(h,r,%res_dimen%) * lev_YH(h,r,%res_dimen%) ;

* -------- Government Accounts --------

 SAMG3("govt",tmr,r,%res_dimen%)  = SUM(c,SAMG3(tmr,c,r,%res_dimen%)) ;

 SAMG3("govt",ter,r,%res_dimen%)  = SUM(c,SAMG3(ter,c,r,%res_dimen%)) ;

 SAMG3("govt",tff,r,%res_dimen%)  = SUM(a,SAMG3(tff,a,r,%res_dimen%)) ;

 SAMG3("govt","saltax",r,%res_dimen%)
              = SUM(c,SAMG3("saltax",c,r,%res_dimen%)) ;

 SAMG3("govt","vattax",r,%res_dimen%)
              = SUM(c,SAMG3("vattax",c,r,%res_dimen%)) ;

 SAMG3("govt","prodtax",r,%res_dimen%)
              = SUM(a,SAMG3("prodtax",a,r,%res_dimen%)) ;

 SAMG3("govt","dirtax",r,%res_dimen%)
              = SUM(f,SAMG3("dirtax",f,r,%res_dimen%))
                 + SUM(h,SAMG3("dirtax",h,r,%res_dimen%)) ;

* -------- Trade Margin Accounts ------

 SAMG3(owatpmarg,cp,r,%res_dimen%)
              = SUM(w$map_marg_w(owatpmarg,w),
                 lev_PT("cserv",r,%res_dimen%) * lev_QMR(w,cp,r,%res_dimen%)
                   * margcor(w,"cserv",cp,r)) ;

* -------- Trade Accounts -------------

 SAMG3(w,c,r,%res_dimen%)
              = lev_PWMFOB(w,c,r,%res_dimen%) * lev_QMR(w,c,r,%res_dimen%)
                               * lev_ER(r,%res_dimen%) ;

 SAMG3("wglo",owatpmarg,r,%res_dimen%)
              = SUM(c,SAMG3(owatpmarg,c,r,%res_dimen%)) ;

* -------- Capital Accounts -----------

 SAMG3("I_S",f,r,%res_dimen%)
              = deprec(f,r) * lev_YF(f,r,%res_dimen%) ;

 SAMG3("I_S",wgn,r,%res_dimen%)
              = SUM(c,SAMG3(wgn,c,r,%res_dimen%))
                 - SUM(c,SAMG3(c,wgn,r,%res_dimen%)) ;

 SAMG3("I_S","wglo",r,%res_dimen%)
              = SUM((owatpmarg,c),SAMG3(owatpmarg,c,r,%res_dimen%))
                 - SUM(c,SAMG3(c,"wglo",r,%res_dimen%)) ;

 SAMG3("I_S","hous",r,%res_dimen%)
              = SUM(h,(lev_YH(h,r,%res_dimen%)
                 *(1-lev_TYH(h,r,%res_dimen%)))*(lev_SHH(h,r,%res_dimen%))) ;

 SAMG3("I_S","govt",r,%res_dimen%)  = lev_KAPGOV(r,%res_dimen%) ;

* -------- Account Totals -------------

 SAMG3("TOTAL",sacnp,r,%res_dimen%)   = SUM(sacn,SAMG3(sacn,sacnp,r,%res_dimen%)) ;
 SAMG3(sacn,"TOTAL",r,%res_dimen%)    = SUM(sacnp,SAMG3(sacn,sacnp,r,%res_dimen%)) ;


Execute_Unload  '6_results\%expt_res%\anar_t_ressamg.gdx', SAMG3

 ;

* -------------- END OF anar_t results SAMs ----------------------------------
