$TITLE STAGE_t Static CGE Model
$OFFUPPER ONEMPTY
*$OFFLISTING OFFSYMXREF OFFSYMLIST

$ontext
On Dollar Control Directives see Chapter 10 GAMS manual
$offtext

*################ GENERAL INFORMATION ####################################
$ontext
   This model is a member of the STAGE model family, developed for the
'Single Country CGE Modelling' course. It has features that are more
sophisticated than those in the open source versions of STAGE.

Copyright (c) (Nov) 2017 Scott McDonald
Last revised:  Jan 2021

The model should be referenced as:
  McDonald, S., (2021). A Static Applied General Equilibrium Model:
    Technical Documentation - STAGE_t Version. mimeo (www.cgemod.org.uk).
$offtext        
*################ LICENCE INFORMATION ####################################
$ontext
   This model is licenced to participants on the 'Single Country CGE
Modelling' course.

   The licence is Creative Commons CC BY-SA 4.0
(https://creativecommons.org/licenses/by-sa/4.0/)

   During, and after, the 'Single Country CGE Modelling' course.
You are free to
    1.  Share — copy and redistribute the material in any medium or format
    2.  Adapt — remix, transform, and build upon the material for any
        purpose, even commercially.
Subject to
       a.  Attribution — You must give appropriate credit, provide a link
           to the license, and indicate if changes were made. You may do
           so in any reasonable manner, but not in any way that suggests
           the licensor endorses you or your use.
       b.  ShareAlike — If you remix, transform, or build upon the
           material, you must distribute your contributions under the
           same license as the original.
   
    We appreciate receiving copies of developments of stg_t that include new
 behavioural relationships. 
 
    If you have NOT participated in the 'Single Country CGE Modelling'
course: all files should be deleted from your PC, and no copies kept.

Do NOT remove this notice.
$offtext
*##################### MODEL DEVELOPMENT NOTES ###########################
$ontext

$offtext
*################ WORK TO DO ON THIS VERSION #############################
$ontext
 1. Revise  stg_t_convent.inc
 2. Develop stg_t_struct.inc
 4. Review and revise res_struct
 7. Test Scaling consistency between factuse and SAM
 8. Abort statement if elasticities equal 0.95 to 1.05

$offtext
*-######## 2. GLOBAL VARIABLES THAT CONTROL FOLDERS AND FILES ############

*~~~~~ Set Comparative static data file name
$SETGLOBAL mod_data     stg_t_data_sam

*##################### 1. MODEL DESCRIPTION ##############################
$ontext

    1. Model structure derives from
       Dervis et al (1984) 'General Equilibrium Models....'
    2. SAM approach derives from
       Pyatt (1988) 'SAM Approach to Modelling'
    3. Programme organisation - data followed by model
       see Brooke et al (1992) 'GAMS: A Users Guide' Chapter 3
    4. Original code structure derives from
       USDA Model by Robinson et al (1990) AND Devarajan et al (1994)
       Getting the Model Right. Chapter 3 'Cameroon Model'.
    5. The code is closely related to the GLOBE model by McDonald,
       Thierfelder and Robinson (2005) 'A SAM Based Global CGE Model
       using GTAP Data', Sheffield Economics Research Paper 2005:001.
    6. Earlier versions of this code were developed for the PROVIDE project
       between 2002 and 2010.
    7. The development of this model has been influenced by many other
       modellers and collaborators; a failure to acknowledge their input
       etc., is not intended to deny the value of their inputs.

Acknowledgemets: contributions by the following are gratefully acknowledged
                    Cecilia Punt,
                    Lindsay Chant,
                    Melt van Schoor,
                    Kalie Pauw,
                    Emanuele Ferrari,
                    Emert Aragie,
                    Rehab Osman,
                    Hasan Dudu

Special thanks are due to Sherman Robinson for providing code and advice
when this model started, in 1992, and since.

* ------ SCHEMATIC OUTLINE OF PROGRAMME

The model code consists of a number of files; the relationships between
these files is illustrated below.

 stg_t.gms                                MASTER programme file
     |
     |<----- stg_t_descrip.inc              model data & behaviour description
     |<----- stg_t_convent.inc              conventions used in model code
     |
     | 2. Model Origins
     |
     | 3. PARAMETER AND VARIABLE LISTINGS
     |
     |<----- stg_t_list.inc                 alphabetic listing
     |
     | 4. SET AND DATA PARAMETER DECLARATION
     |
     |<----- stg_t_data_load.inc            data include file
             |<----- samgadjC_F_R.inc         SAM adjustment file
     |
     | 5. SET AND DATA ASSIGNMENT
     |
     | 6. DATA DIAGNOSTICS
     |
     |<----- smod4_1_diagnost.inc             data diagnostics file
     |
     | 7. PARAMETER CALIBRATION
     |
     |<----- stg_t_parmcalib.inc            Parameter declaration
                                                    & calibration file
     |
     | 8. VARIABLE DECLARATION
     |
     | 9. VARIABLE INITIALISATION
     |
     |<----- stg_t_varinit.inc              Variable initialisation file
     |
     | 10. SOCIAL ACCOUNTING MATRIX
     |
     |<----- stg_t_samchk1.inc              MacroSAM & MicroSAM
     |                                             checks on calibration
     |
     |10b. Structural Tables
     |
     |<----- stg_t_struct.inc               Descriptive structural tables
     |
     | 11. EQUATION DECLARATION
     |
     | 12. EQUATIONS
     |
     | 13. MODEL CLOSURE
     |
     |<----- stg_t_bclose.inc               Base model closure
     |
     | 14. MODEL & SOLVE STATEMENTS
     |
     | 15. SOCIAL ACCOUNTING MATRIX
     |
     |<----- stg_t_samchk2.inc              MacroSAM & MicroSAM
     |                                             checks on model
     |
     | 16. POLICY EXPERIMENTS
     |
     |<----- stg_t_expt.inc                 Experiment files
                 |
                 |<----- stg_t_resparm.inc       Declare results params
                 |
                 |<----- stg_t_varinit2.inc      Reinitialise variables
                 |<----- stg_t_reset.inc         Reset closure variables
                 |
                 |<----- stg_t_cl***1.inc        Alternative closures
                 |<----- stg_t_cl***..inc                 .
                 |<----- stg_t_cl***..inc                 .
                 |<----- stg_t_cl***n.inc        Alternative closures
                 |
                 |
                 |<----- stg_t_resassign.inc     Assigning results params
                 |
                 |
      |
      |<----- stg_t_anal.inc                 Result Analyses sub routine
      |          |
                 |
                 |<----- stg_t_reslevel.inc       Levels results saved
                 |
                 |<----- stg_t_resmacro.inc       Macroeconomic results
                 |
                 |<----- stg_t_reswelf.inc        Welfare results
                 |
                 |<----- stg_t_resstruct.inc      Structural results
                 |
                 |<----- stg_t_resindex.inc       Price index results
                 |
                 |<----- stg_t_resperc.inc        Proportionate results

$offtext

* ------ DESCRIPTION OF BASIC MODEL

$INCLUDE 2_include/stg_t_descrip.inc

* Coding and notation conventions

$INCLUDE 2_include/stg_t_convent.inc

*############### 3. PARAMETER AND VARIABLE LISTINGS ######################

$INCLUDE 2_include/stg_t_list.inc

*############### 3. PARAMETER AND VARIABLE LISTINGS ######################


*############### 4. SET AND DATA PARAMETER DECLARATION ###################
$ontext
 The data are entered in 6 components
  i)     SAM accounts set SAC
  ii)    various subsets of SAC
  iii)   various mapping sets for the model and results
  iv)    various sets assigned from the data
  v)     sets to control model structure and flow
  vi)    sets for reporting results
$offtext

$ontext
 SET ORDERING
   The ORDERING of the elements in the sets is important
 1.  it aids readability; AND
 2.  allows the definition of mapping sets using the '#**:#**' shorthand

$offtext

SETS

 sac        SAM accounts

 c(sac)     Commodities
 cagr(c)    Agricultural Commodities
 cnat(c)    Natural Resource Commodities
 cfd(c)     Food Commodities
 cind(c)    Industrial Commodities
 cuti(c)    Utility Commodities
 ccon(c)    Construction Commodities
 cser(c)    Service Commodities
 cagg       Aggregate commodity groups

 m(sac)     Margins

 a(sac)     Activities
 aagr(a)    Agricultural Activities
 anat(a)    Natural Resource Activities
 afd(a)     Food Activities
 aind(a)    Industrial Activities
 auti(a)    Utility Activities
 acon(a)    Construction Activities
 aser(a)    Service Activities
 aagg       Aggregate activity groups

 anch(a)    Anchor activity for fixing 1 WFDIST in various factor closures
 anchN(a)   Anchor activity for fixing 1 WFDIST in land factor closures

 aleon(a)   Activities with Leontief prodn function at Level 1

 ff(sac)    factors and aggregates
 f(ff)      natural factor accounts
 fag(ff)    aggregate factors
 f2(ff)     factor inputs to QVA at level 1

 l(f)       Labour Factors
 ls(l)      Skilled Labour Factors
 lm(l)      Skilled or Unskilled Labour Factors
 lu(l)      Unskilled Labour Factors

 k(f)       Capital Factors
 kfx(k)     Immobile capital factors
 kfxn(k)    Mobile capital factors

 n(f)       Land Factors

 insa(sac)  All Domestic Institutions and Rest of World
 insw(insa) Domestic Non Government Institutions and Rest of World
 insg(insa) Domestic Institutions including Government
 ins(insg)  Domestic Non Government Institutions

 h(insa)    Households
 g(sac)     Government
 gt(g)      Government tax accounts
* imptax(g)
 tff(g)     factor tax account used in GDX program

 e(insa)    Enterprises

 i(sac)     Investment categories
 in(i)      Investment categories excluding i_s

 w(insa)    Rest of the world

 ppn        population

* Mapping sets

* Mapping sets commented out are assigned dynamically

* map_f_tff(f,tff) Factor taxes to factors
* map_tff_f(tff,f) Factor taxes to factors reverse

 map_aagg_a(aagg,a) Mapping from activies to aggregate activities
 map_cagg_c(cagg,c) Mapping from commodities to aggregate commodities

* Maps for production nesting

 map_va_ff(ff,a)      Mapping for arguments in Value added level nest
 map_fagg_ff(ff,ff,a) Mapping for arguments in nests below value added level

* map_i_k(i,k)       Mapping from investment type to capital type

* Declaring SETS that will be assigned from the data

 ce(c)      export commodities
 cen(c)     Non-export commodities

 ced(c)     export commodities with export demand functions
 cedn(c)    export commodities without export demand functions

 cm(c)      imported commodities
 cmn(c)     non-imported commodities

 cx(c)      commodities produced domestically
 cxn(c)     commodities NOT produced domestically AND imported

 cxac(c)    commodities that are differentiated by activity
 cxacn(c)   commodities that are NOT differentiated by activity

 cd(c)      commodities produced and demanded domestically
 cdn(c)     commodities NOT produced and demanded domestically

 aqx(a)     Activities with CES aggregation function at Level 1 of nest
 aqxn(a)    Activities with Leontief aggregation function at Level 1 of nest

 acet(a)    Activities with CET function on output
 acetn(a)   Activities without CET function on output

* Declaring other sets

 sacn(sac)  SAM accounts excluding TOTAL

 ss         ASAM categories
 ssn(ss)    ASAM excluding totals

* Set used to control model flow

 mcons      set for parameters controlling model content

* Sets to print results for scalar variables

 adjres     Set for adjuster results
 scalres    Set for scalar results

    ;

* Setting up ALIASES

 ALIAS(sac,sacp), (sacn,sacnp),
      (c,cp,cpp), (cagr,cagrp), (cnat,cnatp), (cfd,cfdp), (cind,cindp),
      (cuti,cutip), (ccon,cconp), (cser,cserp),
      (m,mp),
      (a,ap,app), (aagr,aagrp), (anat,anatp), (afd,afdp), (aind,aindp),
      (auti,autip), (acon,aconp), (aser,aserp),
      (f,fp,fpp), (f2,f2p), (ff,ffp,ffpp),
      (insa,insap), (insw, inswp), (insg,insgp), (ins, insp),
      (l,lp), (ls,lsp), (lm,lmp), (lu,lup), (k,kp), (kfx,kfxp),(n,np)
      (h,hp,hpp), (e,ep), (g,gp), (gt,gtp), (tff,tffp),
      (i,ip), (in,inp),
      (w,wp),
      (ce,cep), (ced,cedp), (cm,cmp), (cx,cxp), (cxac,cxacp), (cd,cdp),
      (ss,ssp), (ssn,ssnp)
 ;

*#### DECLARING PARAMETERS FOR ALL MODEL DATA

* ------- Declare parameters for data loading ----------------------------
$ontext
 The data are entered in 8 components
  i)     SAM matrix
  ii)    FACTUSE (quantities) matrix
  iii)   Factor ownership by households
  iv)    Population data - population measure needs selecting
  v)     4 tables of elasticities

 In addtion there are
  vi)   2 (scalar) scaling parameters
  vii)  2 tables of parameters to control model flow and model structure
  viii) a table of parameters defining closures to be used for experiments
$offtext

PARAMETER
* Data parameters
 SAM(sac,sacp)     the SAM for this model
 FACTUSE(f,a)      Factor use by activity

 FACTINS(insa,f)   Factor use supplied by household
 popn(h,ppn)       Population data using various measures
 pop(h)            Population data used in model

* Commodities and Activities
 ELASTC(c,*)       Trade Elasticities indexed on commodities
 ELASTX(a,*)       Production Elasticities indexed on activities

* Production
 ELASTF(ff,a)      Elasticities for CES Production function level 3

* Household Demand
 ELASTY(c,h)       Income Demand Elasticities for households
 ELASTMU(h,*)      Elasticity of the MU of income

* Data scaling parameters

 samscal           algorithm performance scaling parameter for SAM
 factscal          algorithm performance scaling parameter for FACTUSE

* Parameters used to control model flow

 mod_cont(mcons)    values for parameters controlling model content

     ;

*############### 5. DATA ENTRY ###########################################

* ------- Data load include file -----------------------------------------
$ontext
    All data and sets are read in using an include file

    The output filename - data_in.gdx - should NOT be changed since it is
used in several places.

Adjustments to the data are also made in this file.
$offtext

$INCLUDE 1_1_Model_data\stg_t_data_load.inc

*################ 6. ADDITIONAL SET ASSIGNMENT ###########################

* Define mapping between CONSISTENTLY ORDERED sets
$ontext
  This method of declaration and assignment requires that the two set
 arguments are ordered so that the matching is PERFECT.
  Check carefully
$offtext

Sets
 map_f_tff(f,tff) Factor taxes to factors /
 #f:#tff
  /

 map_tff_f(tff,f) Factor taxes to factors reverse  /
 #tff:#f
  /

 map_i_k(in,k)     Mapping from investment type to capital type /
 #in:#k
  /

 ;

* Define sets on the basis of read in data

 ce(c)$(SAM(c,"row"))          = YES ;
 cen(c)                        = NOT ce(c) ;

 ELASTC(c,"exdem")$(NOT ELASTC(c,"exdem")) =   0.0 ;

 ced(c)$(ELASTC(c,"exdem"))    = YES ;
 cedn(c)                       = NOT ced(c) ;

 cm(c)$(SAM("row",c))          = YES ;
 cmn(c)                        = not cm(c);

 cx(c)$(SUM(a,SAM(a,c)))       = YES ;
 cxn(c)                        = not cx(c) ;

 ELASTC(c,"sigmaxc")$(NOT ELASTC(c,"sigmaxc")) =   0.0 ;

 cxac(c)$ELASTC(c,"sigmaxc")   = YES ;
 cxacn(c)                      = not cxac(c) ;

 cd(c)$( SUM(a,SAM(a,c)) GT (SAM(c,"row") - SAM("exptax",c)))
                               = YES ;
 cdn(c)                        = not cd(c) ;

* CET vs. non-CET activities
$ontext
   CET if elasticity for CET is non-zero
   Fixed proportions if CET is zero
$offtext

 ELASTX(a,"omegaout")$(NOT ELASTX(a,"omegaout")) =   0.0 ;

 acet(a)$(ELASTX(a,"omegaout"))  = YES ;
 acetn(a)                        = NOT acet(a) ;

* Capital factors for closure settings
* Mobile capital factors
 kfxn(k)                       = NOT kfx(k) ;

* ----- Displaying dynamic sets
DISPLAY ce, cen, ced, cedn, cm, cmn, cx, cxn, cxac, cxacn, cd, cdn
        aqx, aqxn, acet, acetn, kfx, kfxn
  ;

* ---- Displaying Scaling and Controls

 DISPLAY mod_cont, samscal, factscal ;


*######################## END OF DATA ENTRY ##############################

*################ 7. DATA DIAGNOSTICS ####################################

$INCLUDE 2_include/stg_t_diagnost.inc

*################ 8. MODEL CALIBRATION ###################################
* Calibration proceeds by the blocks of equations
* each block contains all the related parameter declarations and assignments

$INCLUDE 2_include/stg_t_parmcalib.inc

*################ 9. VARIABLE DECLARATION ################################
* NOTE the default specification of variables as FREE

 Free Variables
* ------- TRADE BLOCK ----------------------------------------------------
* #### Exchange Rate Block

 ER           Exchange rate                         (domestic per world unit)

* #### Exports Block

 PWE(c)       World price of exports in dollars
 PE(c)        Domestic price of exports by activity a
 PD(c)        Consumer price for domestic supply of commodity c

 QE(c)        Domestic output exported by commodity c
 QD(c)        Domestic demand for commodity c

* #### Imports Block

 PWM(c)       World price of imports in dollars
 PM(c)        Domestic price of competitive imports of commodity c

 QM(c)        Imports of commodity c

 QQ(c)        Supply of composite commodity c

* ------- TRADE AND TRANSPORT MARGINS BLOCK ------------------------------

 PTT(m)       Price of trade and transport margin m
 QTT(m)       Quantity of trade and transport margin m
 QTTD(c)      Intermediate input use for trade and transport margin m

* ------- COMMODITY PRICE BLOCK ------------------------------------------

 PQS(c)       Supply price of composite commodity c
 PQD(c)       Purchaser price of composite commodity c
 PQCD(c)      Purchaser price of composite commodity c private final demand

* ------- NUMERAIRE PRICE BLOCK ------------------------------------------

 CPI          Consumer price index
 PPI          Producer (domestic) price index

* ------- PRODUCTION BLOCK -----------------------------------------------

 PX(a)        Composite price of output by activity a

* CES aggregation functions for Level 1 of production nest

 PVA(a)       Value added price for activity a
 PINT(a)      Price of aggregate intermediate input

 ADX(a)       Shift parameter for CES production functions for QX
 ADXADJ       Scaling Factor for Shift parameter on CES functions for QX
 DADX         Partial scaling factor for Shift parameter on CES functions for QX

 ADFD(ff,a)   Shift parameter for factor and activity specific efficiency

 QX(a)        Domestic production by activity a
 QVA(a)       Quantity of aggregate value added for level 1 production

* Leontief aggregation functions for Level 1 of production nest

 QINT(a)      Aggregate quantity of intermediates used by activity a

* CES aggregation functions for Level 2 of production nest

 ADVA(a)      Shift parameter for CES production functions for QVA
 ADVAADJ      Scaling Factor for Shift parameter on CES functions for QVA
 DADVA        Partial scaling factor for Shift parameter on CES functions for QVA

 WF(ff)       Price of factor f
 WFDIST(ff,a) Sectoral proportion for factor prices
 WFA(ff,a)    Activity specific prices for factors ff
 
 FD(ff,a)     Demand for factor f by activity a
 FSI(insa,f)  Factor supplies from institution ins by factor f
 FS(ff)       Supply of factor f

* Unemployment

 UNEMP(f)     Unemployed factors

* Intermediate Input Demand

 QINTD(c,a)   Demand for intermediate inputs by commodity & activity

* Commodity Output

 PXC(c)       Producer price of composite domestic output

 QXC(c)       Domestic production by commodity c

* Activity Output

 PXAC(a,c)    Activity commodity prices

 QXAC(a,c)    Domestic commodity output by each activity

 IOQXACQXV(a,c)  Share of commodity c in output by activity a

* ------- FACTOR BLOCK ---------------------------------------------------

 YF(f)        Income to factor f
 YFDISP(f)    Factor income for distribution after depreciation
 YFINS(f)     Factor income for distribution to domestic non govt institutions

 FSISH(insa,f) Shares of factor f supplied by institution ins
 INSVA(insa,f) Factor income after deprecn distribution to institn ins

* ------- HOUSEHOLD BLOCK ------------------------------------------------
* ## Household Income

 YH(h)        Income to household h

* Household Expenditure

 HOHO(h,hp)   Inter household transfer
 HEXP(h)      Household consumption expenditure
 QCD(c,h)     Household consumption by commodity c

* ------- ENTERPRISE BLOCK -----------------------------------------------
* ## Enterprise Income

 YE(e)        Enterprise incomes

* ## Enterprise Expenditure

 QEDADJ       Enterprise demand volume Scaling Factor
 HEADJ        Scaling factor for enterprise transfers to households

 HOENT(h,e)   Household Income from enterprise e
 GOVENT(e)    Government income from enterprise e
 QED(c,e)     Enterprise consumption by commodity c
 VED(e)       Value of enterprise e consumption expenditure

* ------- GOVERNMENT BLOCK -----------------------------------------------
* #### Government Income Block

 TE(c)        Export taxes on exported comm'y c ad valorem
 TM(c)        Tariff rates ad valorem
 TS(c)        Sales tax rate ad valorem
 TSS(c)       Sales tax 2 rate ad valorem
 TEX(c)       Excise tax rate per unit quantity
 TV(c)        Value added tax rate
 TX(a)        Indirect tax rate
 TF(ff,a)     Tax rate on factor use
 TYF(f)       Direct tax rate on factor income
 TYH(h)       Direct tax rate on households
 TYE(e)       Direct tax rate on enterprises

* ## Government Tax Revenues

 MTAX         Tariff revenue
 ETAX         Export tax revenue
 STAX         Sales tax revenue
 SSTAX        Sales tax 2 revenue
 EXTAX        Excise tax revenue
 VTAX         Value added tax revenue
 ITAX         Indirect tax revenue
 FTAX         Factor use tax revenue
 DTAX         Direct Income tax revenue
 FYTAX        Factor Income tax revenue

 TEADJ        Export subsidy Scaling Factor
 TMADJ        Tarrif rate Scaling Factor
 TSADJ        Sales tax rate scaling factor
 TSSADJ       Sales tax 2 rate scaling factor
 TVADJ        Value added tax rate scaling factor
 TEXADJ       Excise tax rate scaling factor
 TXADJ        Indirect Tax Scaling Factor
 TFADJ        Factor Use Tax Scaling Factor
 TYFADJ       Factor Tax Scaling Factor
 TYHADJ       Household Income Tax Scaling Factor
 TYADJ        Household and Enterprise Income Tax Scaling Factor
 TYEADJ       Enterprise income tax Scaling Factor

 DTE          Partial Export tax rate scaling factor
 DTM          Partial Tariff rate scaling factor
 DTS          Partial Sales tax rate scaling factor
 DTSS         Partial Sales tax 2 rate scaling factor
 DTV          Partial value added tax rate scaling factor
 DTEX         Partial Excise tax rate scaling factor
 DTX          Partial Indirect tax rate scaling factor
 DTF          Uniform adjustment to factor use tax by activity
 DTYF         Partial direct tax on factor rate scaling factor
 DTYH         Partial direct tax on household rate scaling factor
 DTY          Partial direct tax on hold and enterprise rate scaling factor
 DTYE         Partial direct tax on enterprise rate scaling factor

* ## Government Income

 YG           Government income

* #### Government Expenditure Block

 QGDADJ       Government consumption demand scaling factor
 HGADJ        Scaling factor for government transfers to households
 EGADJ        Transfers to enterprises by government Scaling Factor

 QGD(c)       Government consumption demand by commodity c
 VGD          Value of Government consumption expenditure
 EG           Expenditure by government

* ------- KAPITAL BLOCK --------------------------------------------------
* ## Savings Block

 SHH(h)       Household savings rates
 HHSAV(h)     Household savings
 SEN(e)       Enterprise savings rates
 ENTSAV(e)    Enterprise savings

 SADJ         Savings rate scaling factor for BOTH households and enterprises
 SHADJ        Savings rate scaling factor for households
 SEADJ        Savings rate scaling factor for enterprises

 DSHH         Partial household savings rate scaling factor
 DS           Partial household and enterprise savings rate scaling factor
 DSEN         Partial enterprise savings rate scaling factor

 TOTSAV       Total savings

* ## Investment Block

 IADJ         Investment scaling factor

 QINVD(c,i)   Investment demand by commodity c for investment type i
 QINV(i)      Investment volume by investment type i

 INVSH_I(i)   Shares of savings to investment of type i

 INVEST       Total investment expenditure

* ------- FOREIGN INSTITUTIONS BLOCK -------------------------------------

 YFWOR(f)     Foreign factor income

* ------- MARKET CLEARING BLOCK ------------------------------------------
* ##### Account Closure

 KAPGOV       Government Savings
 CAPWOR       Current account balance

* #### Absorption Closure

 VFDOMD       Value of final domestic demand
 INVESTSH     Value share of investment in total final domestic demand
 VGDSH        Value share of Govt consumption in total final domestic demand
 VEDSH(e)     Value share of Ent consumption in total final domestic demand

* ##### GDP

 GDP          GDP from Expenditure
 ABSORP       Absorption

* ##### Slack

 WALRAS       Slack variable for Walras's Law

        ;

* If the model is correctly specified WALRAS equals zero - a useful check
* See Devarajan et al (1994) Getting the Model Right

*################ 10. VARIABLE INITIALISATION ############################
$ontext
   This section initialises the variables to their base values.
$offtext

$INCLUDE 2_include/stg_t_varinit.inc

*################ 11. DATA DISPLAY AND EXPORT ############################
$ontext
   Using gdx=input in the command line ensures that details of All data,
sets, parameters, variables, equations etc., are reported in input.gdx

  Using rf=*** generates a reference file.
$offtext

*################ 12. SOCIAL ACCOUNTING MATRICES #########################
$ontext
  This section checks that the model is calibrated with a balanced SAM,
by using a Macro and a Micro SAM.

  The MICRO SAM element can be switched off by setting "micsam1" = 0 in the
parameter 'flow_cont' in the worksheet 'controls'

 1) Macro SAM
  The programme aborts IF
           - ROW AND COLUMN SUMS FOR ASAM1 NOT EQUAL
           - ALL ASAM1 CELL ENTRIES DO NOT EQUAL ASAM0 ENTRIES

 2) Micro SAM
  The programme aborts IF
           - ALL SAM1 CELL ENTRIES DO NOT EQUAL SAM0 ENTRIES

 ALL ABORT commands are after the Macro and Micro SAM checks are computed
$offtext

$SETGLOBAL ASAM_chk  ASAM1
$SETGLOBAL SAM_chk   SAM1

$INCLUDE 2_include/stg_t_samchk.inc

$DROPGLOBAL ASAM_chk
$DROPGLOBAL SAM_chk

*################ 13. STRUCTURAL DESCRIPTION #############################
$ontext
   This section produces various summary macroeconoic statistics and a
series of summary descriptive statistics.
$offtext

$INCLUDE 2_include/stg_t_struct.inc

*################ END OF CALIBRATION ######################################

EQUATIONS

*################ 14. EQUATION DECLARATIONS ###############################
* ------- TRADE BLOCK ----------------------------------------------------
* #### Exports Block

 PEDEF(c)        Domestic price of exports by commodity c

 CET(c)          CET function for domestic production
 ESUPPLY(c)      Export supply function (FOC)
 EDEMAND(c)      Export demand function
 CETALT(c)       CET fn for dom prodn with no exports OR only exported

* #### Imports Block

 PMDEF(c)        Domestic price of competitive imports of commodity c

 ARMINGTON(c)    Composite commodity aggregation function
 COSTMIN(c)      Cost minimisation for composite commodity (FOC)
 ARMALT(c)       Comp commody aggn fn with no imports OR no dom prodn

* ------- TRADE AND TRANSPORT MARGINS BLOCK ------------------------------

 PTTDEF(m)       Price of trade and transport margin m
 QTTDEF(m)       Quantity of trade and transport margin m
 QTTDEQ(c)       Intermediate input use for trade and transport margin m

* ------- COMMODITY PRICE BLOCK ------------------------------------------

 PQSDEF(c)       Supply price of composite commodity c
 PQDDEF(c)       Purchaser price of composite commodity c
 PQCDDEF(c)      Purchaser price of composite commodity c private final demand
 PXCDEF(c)       Producer price for composite domestic output

* ------- NUMERAIRE PRICE BLOCK ------------------------------------------

 CPIDEF          Consumer price index
 PPIDEF          Producer (domestic) price index

* ------- PRODUCTION BLOCK -----------------------------------------------

 PXDEF(a)        Composite price of output by activity a
 
 WFADEF(ff,a)    Activity specific prices for factors ff

* CES aggregation functions for Level 1 of production nest

 PVADEF(a)       Value added price for activity a level 1 of nest
 PINTDEF(a)      Aggregate intermed input price for activity a level 1 of nest

 ADXDEF(a)       Shift parameter for CES production functions for QX
 QXPRODFN(a)     Production function for QX in activity a level 1 of nest
 QXFOC(a)        FOC for production function for QX level 1 of nest

* Leontief aggregation functions for Level 1 of production nest

 QINTDEF(a)      Leontief intermediate aggregation for Level 1 of nest
 QVADEF(a)       Leontief value added aggregation for Level 1 of nest

* CES aggregation functions for Level 2 of production nest

 ADVADEF(a)      Shift parameter for CES production functions for QVA
 QVAPRODFN(a)    Production function for QVA in activity a level 2 of nest
 QVAFOC(ff,a)     FOC Production function for QVA level 2 of nest

* CES aggregation functions for Level 3 of production nest

 FDPRODFN(ff,a)  Production function for aggregate labour at Level 3
 FDFOC(ff,ff,a)  FOC for aggregate labour at Level 3

* Intermediate Input Demand

 QINTDEQ(c,a)    Intermediate input demand by commodity & activity

* Commodity Output

 COMOUT(c)       Domestic differentiated commodity production
 COMOUTFOC(a,c)  FOC for Domestic differentiated commodity production

 COMOUT2(c)      Domestic homogenous commodity production
 COMOUTFOC2(a,c) FOC for Domestic homogenous commodity production

* Activity Output

 ACTOUT(a,c)     Domestic activity output
 ACTOUTFOC(a,c)  FOC for domestic activity output

* ACTIVOUT(a,c)    Domestic activity output

* ------- FACTOR BLOCK ---------------------------------------------------

 YFEQ(f)         Factor incomes
 YFDISPEQ(f)     Factor income for distribution after depreciation
 YFINSEQ(f)       Factor income for distribution to domestic non govt institutions

 FSISHEQ(insw,f)  Shares of factor f supplied by institution insw

 INSVAEQ(insw,f)  Factor income after deprecn distribution to institn insw

* ------- HOUSEHOLD BLOCK ------------------------------------------------
* ## Household Income

 YHEQ(h)         Household incomes

* Household Expenditure

 HOHOEQ(h,hp)    Inter household transfer
 HEXPEQ(h)       Household consumption expenditure
 QCDEQ(c,h)      Household commodity consumption

* ------- ENTERPRISE BLOCK -----------------------------------------------
* ## Enterprise Income

 YEEQ(e)         Enterprise incomes

* ## Enterprise Expenditure

 QEDEQ(c,e)      Enterprise commodity consumption
 HOENTEQ(h,e)    Household Income from enterprise e
 VEDEQ(e)        Value of enterprise consumption expenditure
 GOVENTEQ(e)     Government income from enterprise e

* ------- GOVERNMENT BLOCK -----------------------------------------------
* #### Government Income Block

* ## Government Tax Rates

 TEDEF(c)        Export tax rates on exports of comm'y c
 TMDEF(c)        Tariff rates on imports of comm'y c
 TSDEF(c)        Sales tax rates
 TSSDEF(c)       Sales tax 2 rates
 TVDEF(c)        Value added tax rates
 TEXDEF(c)       Excise tax rates
 TXDEF(a)        Indirect tax rates
 TFDEF(f,a)      Factor use tax rates paid by activities
 TYFDEF(f)       Factor income tax rates
 TYHDEF(h)       Household income tax rates
 TYEDEF(e)       Enterprise income tax rates

* ## Government Tax Revenues

 MTAXEQ          Import tariff taxes
 ETAXEQ          Export taxes
 STAXEQ          Sales taxes
 SSTAXEQ         Sales taxes 2
 EXTAXEQ         Excise taxes
 VTAXEQ          Value added taxes
 ITAXEQ          Indirect taxes on activities
 FTAXEQ          Factor use tax revenue
 FYTAXEQ         Factor income taxes
 DTAXEQ          Direct taxes on households and enterprises

* #### Government Expenditure Block
 YGEQ            Government Income
 QGDEQ(c)        Government commodity consumption
 EGEQ            Government expenditure
 VGDEQ           Value of Government consumption expenditure

* ------- KAPITAL BLOCK --------------------------------------------------
* ## Savings Block

 SHHDEF(h)       Household savings rates
 HHSAVEQ(h)      Household savings
 SENDEF(e)       Enterprise savings rates
 ENTSAVEQ(e)     Enterprise savings
 TOTSAVEQ        Total Savings

* ## Investment Block

 QINVDEQ(c,i)    Investment demand in quantities
 QINVEQ(i)       Investment volume by investment type i

 INVSH_IEQ(i)    Shares of savings to investment of type i

 INVESTEQ        Total Investment expenditure

* ------- FOREIGN INSTITUTIONS BLOCK -------------------------------------

 YFWOREQ(f)      Foreign factor income

* ------- MARKET CLEARING BLOCK ------------------------------------------
* ##### Account Closure

 FMEQUIL(f)      Factor market equilibrium
 UNEMPEQUIL(f)   Unemployment equation

 FSDEF(f)        Factor supply definition

 PRODEQUIL(a,c)  Production equilibrium
 QEQUIL(c)       Commodity market equilibrium

 GOVEQUIL        Government equilibrium

 CAEQUIL         Current account balance (foreign trade equilibrium)

* #### Absorption Closure

 VFDOMDEQ        Value of final domestic demand
 INVESTSHEQ      Value share of investment in total final domestic demand
 VGDSHEQ         Value share of Govt consumption in total final domestic demand
 VEDSHEQ(e)      Value share of Ent consumption in total final domestic demand

* ##### GDP

 GDPEQ           GDP from Expenditure
 ABSORPEQ        Absorption

* ##### Slack

 WALRASEQ        Savings and Investment equilibrium

  ;

*################ 15. EQUATIONS ASSIGNMENTS ##############################

* ------- TRADE BLOCK ----------------------------------------------------
* #### Exports Block

* For some c there are no exports hence only implement for ce(c)

 PEDEF(c)$ce(c)..  PE(c) =E= PWE(c) * ER * (1 - TE(c))
                                    - SUM(m,ioqttqe(m,c) * PTT(m)) ;

 PE.FX(c)$(NOT ce(c))         = 0.0 ;

* For some c there are no exports hence only implement for ce(c)

 CET(c)$(cd(c) AND ce(c))..
                  QXC(c) =E= at(c)*(gamma(c)*QE(c)**rhot(c) +
                                 (1-gamma(c))*QD(c)**rhot(c))**(1/rhot(c)) ;

 QXC.FX(c)$(NOT cx(c))        = 0.0 ;

 ESUPPLY(c)$(cd(c) AND ce(c))..
                   QE(c) =E= QD(c)*((PE(c)/PD(c))*((1-gamma(c))
                                 /gamma(c)))**(1/(rhot(c)-1)) ;

 QE.FX(c)$(NOT ce(c))         = 0.0 ;

 EDEMAND(c)$ced(c)..
                   QE(c) =E= econ(c)*((PWE(c)/pwse(c))**(-eta(c))) ;

* For c with no exports OR for c with no domestic production
* domestic supply is by CETALT

 CETALT(c)$((cd(c) AND cen(c)) OR (cdn(c) AND ce(c)))..
                  QXC(c) =E= QD(c) + QE(c) ;

* #### Imports Block

* For some c there are no imports hence only implement for cm(c)

 PMDEF(c)..  PM(c) =E= (PWM(c) *(1 + TM(c))) * ER ;

 PM.FX(c)$(NOT cm(c))         = 0.0 ;

* For some c there are no imports or domestic production
* hence only implement for cd(c) AND cm(c)

 ARMINGTON(c)$(cx(c) AND cm(c))..
                  QQ(c)  =E= ac(c)*(delta(c)*QM(c)**(-rhoc(c)) +
                                 (1-delta(c))*QD(c)**(-rhoc(c)))**(-1/rhoc(c)) ;

 COSTMIN(c)$(cx(c) AND cm(c))..
                   QM(c) =E= QD(c)*((PD(c)/PM(c))*(delta(c)/
                                 (1-delta(c))))**(1/(1+rhoc(c))) ;

 QM.FX(c)$(NOT cm(c))         = 0.0 ;

* For c with no imports OR for c with no domestic production
* supply is from ARMALT

 ARMALT(c)$((cx(c) AND cmn(c)) OR (cxn(c) AND cm(c)))..
                    QQ(c) =E= QD(c) + QM(c) ;


* ------- TRADE AND TRANSPORT MARGINS BLOCK ------------------------------

 PTTDEF(m)..    PTT(m) =E= SUM(c,ioqtdqtt(c,m) * PQD(c)) ;

 QTTDEF(m)..    QTT(m) =E= SUM(c,ioqttqq(m,c) * QQ(c))
                               + SUM(c,ioqttqe(m,c) * QE(c)) ;

 QTTDEQ(c)..   QTTD(c) =E= SUM(m,ioqtdqtt(c,m) * QTT(m)) ;

* ------- COMMODITY PRICE BLOCK ------------------------------------------

 PQDDEF(c)$(cd(c) OR cm(c))..
                  PQD(c) =E= PQS(c) * (1 + TS(c) + TSS(c)) + TEX(c)
                              + SUM(m,ioqttqq(m,c) * PTT(m)) ;

 PQCDDEF(c)$(cd(c) OR cm(c))..
                  PQCD(c) =E= PQD(c) * (1 + TV(c)) ;

 PQSDEF(c)$(cd(c) OR cm(c))..
            PQS(c)*QQ(c) =E= (PD(c)*QD(c))+(PM(c)*QM(c)) ;

 PXCDEF(c)$cx(c)..
           PXC(c)*QXC(c) =E= (PD(c)*QD(c)) + (PE(c)*QE(c))$ce(c) ;

 PXC.FX(c)$(NOT cx(c))        = 0.0 ;

* ------- NUMERAIRE PRICE BLOCK ------------------------------------------

 CPIDEF..            CPI =E= SUM(c,comtotsh(c)* PQCD(c) ) ;

 PPIDEF..            PPI =E= SUM(c,vddtotsh(c)*PD(c)) ;

* ------- PRODUCTION BLOCK -----------------------------------------------

 PXDEF(a)..        PX(a) =E= SUM(c,IOQXACQXV(a,c)*PXAC(a,c)) ;
 
* Factor Prices

 WFADEF(ff,a)$[WFDIST0(ff,a)]..
                  WFA(ff,a) =E= WF(ff) * WFDIST(ff,a) ;

* CES aggregation functions for Level 1 of production nest


 PVADEF(a)..  (PX(a)*(1 - TX(a)) * QX(a))
                         =E= [(PVA(a)*QVA(a)) + (PINT(a)*QINT(a))] ;

 PINTDEF(a)..    PINT(a) =E= SUM(c,ioqtdqd(c,a) * PQD(c)) ;

 ADXDEF(a)..      ADX(a) =E= ((adxb(a) + dabadx(a)) * ADXADJ)
                                      + (DADX * adx01(a)) ;

 QXPRODFN(a)$aqx(a)..
                   QX(a) =E= ADX(a)*{deltax(a)*QVA(a)**(-rhocx(a))
                              + (1-deltax(a))*QINT(a)**[-rhocx(a)]}
                              **(-1/rhocx(a)) ;

 QXFOC(a)$aqx(a)..
                  QVA(a) =E= QINT(a)*{[PINT(a)/PVA(a)]*[deltax(a)/
                                 (1-deltax(a))]}**[1/(1+rhocx(a))] ;
                                 
* Leontief aggregation functions for Level 1 of production nest

 QINTDEF(a)$aqxn(a)..
                 QINT(a) =E= ioqintqx(a) * QX(a) ;

 QVADEF(a)$aqxn(a)..
                  QVA(a) =E= ioqvaqx(a) * QX(a) ;

* CES aggregation functions for Level 2 of production nest

 ADVADEF(a)..    ADVA(a) =E= ((advab(a) + dabadva(a)) * ADVAADJ)
                                      + (DADVA * adva01(a)) ;

 QVAPRODFN(a)$rhocva(a)..
            QVA(a) =E= ADVA(a)*(SUM(ff$[map_va_ff(ff,a) AND deltava(ff,a)],
                          deltava(ff,a)
                           *(ADFD(ff,a)*FD(ff,a))**(-rhocva(a))))
                             **(-1/rhocva(a)) ;


 QVAFOC(ff,a)$[map_va_ff(ff,a) AND deltava(ff,a)]..
  WFA(ff,a)*(1 + TF(ff,a)) =E= PVA(a)*QVA(a)
                                *{SUM[ffp$deltava(ffp,a),deltava(ffp,a)
                                *[ADFD(ffp,a)*FD(ffp,a)]**(-rhocva(a))]}**(-1)
                                *deltava(ff,a)*ADFD(ff,a)**(-rhocva(a))
                                 *FD(ff,a)**(-rhocva(a)-1) ;

 WF.FX(ff)$(NOT F(FF))                   = WF0(ff) ;

* CES aggregation functions for LEVEL 3 of production nest below QVA
* Aggregate - fag - by activity a using inputs l

* ADFAGEQ(ff,a,r)$fag(ff)..
*           ADFAG(ff,a,r) =E= ((adfagb(ff,a,r) + dadfag(ff,a,r))
*                                * (ADFAGfADJ(ff) * ADFAGaADJ(a) * ADFAGrADJ(r)) ;

 FDPRODFN(ff,a)$SUM[ffp,map_fagg_ff(ff,ffp,a)]..
        FD(ff,a) =E= ADFAG(ff,a)
                     *{SUM[ffp${map_fagg_ff(ff,ffp,a) AND deltafd(ff,ffp,a)},
                           deltafd(ff,ffp,a) *FD(ffp,a)**(-rhofd(ff,a))]}
                              **[-1/rhofd(ff,a)] ;

 FD.FX(f,a)$(NOT SAM(f,a)) = 0.0 ;

* fix for aggregate factors
 FD.FX(ff,a)$(NOT FD0(ff,a)) = 0.0 ;

* FOC for input ffpp used to produce aggregate input ffp by activity a
* NOTE ffpp can consist of natural or aggregate factors

 FDFOC(ff,ffp,a)$[map_fagg_ff(ff,ffp,a) AND deltafd(ff,ffp,a)]..

  WFA(ffp,a)*[1 + TF(ffp,a)]
           =E= {WFA(ff,a) *[1 + TF(ff,a)] * FD(ff,a)}
                            *{SUM[ffpp${map_fagg_ff(ff,ffpp,a) AND deltafd(ff,ffpp,a)},
                               deltafd(ff,ffpp,a)*FD(ffpp,a)**(-rhofd(ff,a))]}
                               **(-1)*deltafd(ff,ffp,a)*FD(ffp,a)**[-rhofd(ff,a)-1] ;
                               
* WF.FX(ff)$fag(ff)      = WF0(ff) * mod_cont("numerchk") ;
 WF.FX(ff)$fag(ff)      = WF0(ff) ;

* Intermediate Input Demand

 QINTDEQ(c,a)..   QINTD(c,a) =E= ioqtdqd(c,a)*QINT(a) ;

* Commodity Output

* CES aggregation of differentiated commodities

 COMOUT(c)$(cx(c) and cxac(c))..
                  QXC(c) =E= adxc(c)*{SUM[a$deltaxc(a,c),deltaxc(a,c)
                             *QXAC(a,c)**(-rhocxc(c))]}**(-1/rhocxc(c)) ;

 COMOUTFOC(a,c)$(deltaxc(a,c) and cxac(c))..
               PXAC(a,c) =E= PXC(c)*QXC(c)
                             *(SUM(ap$deltaxc(ap,c),deltaxc(ap,c)
                             *QXAC(ap,c)**(-rhocxc(c))))**(-1)
                             *deltaxc(a,c)*QXAC(a,c)**(-rhocxc(c)-1) ;

 PXAC.FX(a,c)$(NOT SAM(a,c) ) = 0.0 ;

* Aggregation of homogenous commodities

 COMOUT2(c)$(cx(c) and cxacn(c))..
                  QXC(c) =E= SUM(a,QXAC(a,c)) ;

 COMOUTFOC2(a,c)$(deltaxc(a,c) and cxacn(c))..
               PXAC(a,c) =E= PXC(c) ;

* Activity Output
* Selection of CET - specify elast of transformation in Excel as non-zero

 ACTOUT(a,c)$(ioqxacqx(a,c) AND acetn(a))..
*               QXAC(a,c) =E= ioqxacqx(a,c) * QX(a) ;
               QXAC(a,c) =E= IOQXACQX(a,c) * QX(a) ;

* CET FOC for multiproduct firms with transformation possibility NO PRIMAL

 ACTOUTFOC(a,c)$(ioqxacqx(a,c) AND acet(a))..
              QXAC(a,c) =E= QX(a)
                *(PXAC(a,c)/(PX(a)*gammai(a,c)*ati(a)**(rhoti(a))))
                      **(1/(rhoti(a)-1)) ;

 QXAC.FX(a,c)$(NOT SAM(a,c))  = 0.0 ;

* ######## FACTOR BLOCK

 YFEQ(f)..         YF(f) =E= SUM(a,WFA(f,a)*FD(f,a))
                             + (factwor(f)*ER) ;

 YFDISPEQ(f).. YFDISP(f) =E= (YF(f) * (1- deprec(f)))*(1 - TYF(f)) ;

 YFINSEQ(f)..   YFINS(f) =E= YFDISP(f) ;

 FSISHEQ(insw,f)$SUM(inswp,fsia(inswp,f)) ..
                       FSISH(insw,f) =E= FSI(insw,f)/SUM(inswp,FSI(inswp,f)) ;

 FSISH.FX(insw,f)$(NOT FSISH0(insw,f))  = 0.0 ;

 INSVAEQ(insw,f)..   INSVA(insw,f) =E= FSISH(insw,f) * YFINS(f) ;

 INSVA.FX(insw,f)$(NOT INSVA0(insw,f)) = 0.0 ;

* ######## HOUSEHOLD BLOCK
* ## Household Income

 YHEQ(h)..         YH(h) =E= SUM(f,INSVA(h,f))
                             + SUM(hp,HOHO(h,hp))
                             + SUM(e,HOENT(h,e))
                             + (HGADJ * hogovconst(h)*CPI)
                             + (howor(h)*ER)    ;

* Household Expenditure

 HOHOEQ(h,hp)..
              HOHO(h,hp) =E= hohosh(h,hp)
                             *{[YH(h) * (1 - TYH(h))] * [1 - SHH(h)]} ;

 HOHO.FX(h,hp)$(NOT SAM(h,hp)) = 0.0 ;

 HEXPEQ(h)..     HEXP(h) =E= {[YH(h) * (1 - TYH(h))] * [1 - SHH(h)]}
                             - SUM(hp,HOHO(hp,h)) ;

 QCDEQ(c,h)..
         PQCD(c)*QCD(c,h)
                         =E= (PQCD(c)*qcdconst(c,h))
                             + beta(c,h)
                              *(HEXP(h) - SUM(cp,PQCD(cp)*qcdconst(cp,h))) ;

* ------- ENTERPRISE BLOCK -----------------------------------------------
* ## Enterprise Income

 YEEQ(e)..         YE(e) =E= SUM(f,INSVA(e,f))
                             + (EGADJ * entgovconst(e) * CPI)
                             + (entwor(e)*ER) ;

* ## Enterprise Expenditure

 QEDEQ(c,e)..
                QED(c,e) =E= QEDADJ*qedconst(c,e) ;

 HOENTEQ(h,e)..
              HOENT(h,e) =E= hoentsh(h,e)
                             * (((YE(e) * (1 - TYE(e))) * (1 - SEN(e)))
                             - SUM(c,QED(c,e)*PQD(c))) ;

 GOVENTEQ(e).. GOVENT(e) =E= goventsh(e)
                             * (((YE(e) * (1 - TYE(e))) * (1 - SEN(e)))
                              - SUM(c,QED(c,e)*PQD(c))) ;

 VEDEQ(e)..       VED(e) =E= SUM(c,QED(c,e)*PQD(c)) ;

* ------- GOVERNMENT BLOCK -----------------------------------------------
* #### Government Income Block

* ## Government Tax Rates

 TMDEF(c)$cm(c)..  TM(c) =E= [(tmb(c) + dabtm(c)) * TMADJ]
                                      + [DTM * tm01(c)] ;

 TEDEF(c)..        TE(c) =E= [(teb(c) + dabte(c)) * TEADJ]
                                      + [DTE * te01(c)] ;

 TSDEF(c)$(cd(c) OR cm(c))..
                   TS(c) =E= [(tsb(c) + dabts(c)) * TSADJ]
                                      + (DTS * ts01(c)) ;

 TSSDEF(c)$(cd(c) OR cm(c))..
                   TSS(c) =E= [(tssb(c) + dabtss(c)) * TSSADJ]
                                        + (DTSS * tss01(c)) ;

 TEXDEF(c)$(cd(c) OR cm(c))..
                  TEX(c) =E= [(texb(c) + dabtex(c)) * TEXADJ]
                                       + [DTEX * tex01(c)] ;

 TVDEF(c)$(cd(c) OR cm(c))..
                   TV(c) =E= [(tvb(c) + dabtv(c)) * TVADJ]
                                      + [DTV * tv01(c)] ;

 TXDEF(a)..        TX(a) =E= [(txb(a) + dabtx(a)) * TXADJ]
                                      + [DTX * tx01(a)] ;

 TFDEF(f,a)..    TF(f,a) =E= [(tfb(f,a) + dabtf(f,a))* TFADJ]
                                        + [DTF*tf01(f,a)] ;

 TF.FX(ff,a)$(NOT f(ff))  = TF0(ff,a) ;

 TYFDEF(f)..      TYF(f) =E= [(tyfb(f) + dabtyf(f)) * TYFADJ]
                                       + [DTYF * tyf01(f)] ;

 TYHDEF(h)..      TYH(h) =E= [(tyhb(h) + dabtyh(h)) * TYHADJ * TYADJ]
                                       + [DTYH * DTY * tyh01(h)] ;

 TYEDEF(e)..      TYE(e) =E= [(tyeb(e) + dabtye(e)) * TYEADJ * TYADJ]
                                       + [DTYE * DTY * tye01(e)] ;

* ## Government Tax Revenues

 MTAXEQ..         MTAX =E= SUM[c,TM(c)*PWM(c)*ER*QM(c)] ;

 ETAXEQ..         ETAX =E= SUM[c,TE(c)*PWE(c)*ER*QE(c)] ;

 STAXEQ..         STAX =E= SUM[c,TS(c)*PQS(c)*QQ(c)] ;

 SSTAXEQ..       SSTAX =E= SUM[c,TSS(c)*PQS(c)*QQ(c)] ;

 EXTAXEQ..       EXTAX =E= SUM[c,TEX(c)*QQ(c)] ;

 VTAXEQ..         VTAX =E= SUM[(c,h),TV(c)*PQD(c)*QCD(c,h)] ;

 ITAXEQ..         ITAX =E= SUM[a,TX(a)*PX(a)*QX(a)] ;

 FTAXEQ..         FTAX =E= SUM[(f,a),TF(f,a)*WF(f)*WFDIST(f,a)*FD(f,a)] ;

 FYTAXEQ..       FYTAX =E= SUM[f,TYF(f)*(YF(f) * (1 - deprec(f)))] ;

 DTAXEQ..         DTAX =E= SUM[h,TYH(h)*YH(h)] + SUM[e,TYE(e)*YE(e)] ;

* ## Government Income

 YGEQ..             YG =E= MTAX + ETAX
                           + EXTAX + STAX + SSTAX + VTAX
                           + FTAX + ITAX
                           + FYTAX + DTAX
                           + SUM(e,GOVENT(e)) + (govwor*ER)    ;

* #### Government Expenditure Block

 QGDEQ(c)..       QGD(c) =E= QGDADJ*qgdconst(c) ;

 EGEQ..               EG =E= SUM(c,QGD(c)*PQD(c))
                             + SUM(h,hogovconst(h)*CPI*HGADJ)
                             + SUM(e,EGADJ*entgovconst(e)*CPI) ;

 VGDEQ..             VGD =E= SUM(c,QGD(c)*PQD(c)) ;

* ------- KAPITAL BLOCK --------------------------------------------------
* ## Savings Block

 SHHDEF(h)..     SHH(h) =E= ((shhb(h) + dabshh(h)) * SHADJ * SADJ)
                              + (DSHH * DS * shh01(h)) ;

 HHSAVEQ(h)..    HHSAV(h) =E= [YH(h) * (1 - TYH(h))] * SHH(h) ;

 SENDEF(e)..     SEN(e) =E= ((senb(e) + dabsen(e)) * SEADJ * SADJ)
                              + (DSEN * DS * sen01(e)) ;

 ENTSAVEQ(e)..    ENTSAV(e) =E= [YE(e) * (1 - TYE(e))] * SEN(e) ;

 TOTSAVEQ..       TOTSAV =E= SUM[f,(deprec(f)*YF(f))]
                             + SUM(h,HHSAV(h))
                             + SUM(e,ENTSAV(e))
                             + KAPGOV
                             + (CAPWOR*ER) ;

* ## Investment Block

 QINVDEQ(c,i)$in(i)..  QINVD(c,i) =E= (QINV(i)*ioqinvd(c,i)) ;

 QINVD.FX(c,i)$(NOT ioqinvd(c,i))  = 0.0 ;

 QINVEQ(i)$in(i)..     QINV(i) =E= qinvb(i) * IADJ ;

 INVSH_IEQ(i)$in(i)..  INVSH_I(i) =E= SUM(c,PQD(c)*QINVD(c,i))
                                       /SUM((cp,ip),PQD(cp)*QINVD(cp,ip)) ;

 INVESTEQ..       INVEST =E= SUM(c,PQD(c)*(SUM[in,QINVD(c,in)] + dstocconst(c))) ;

* ------- FOREIGN INSTITUTIONS BLOCK -------------------------------------

 YFWOREQ(f)..   YFWOR(f) =E= SUM[w,INSVA(w,f)] ;

* ------- MARKET CLEARING BLOCK ------------------------------------------
* ### Factor market clearing

* FMEQUIL(f)..       FS(f) =E= SUM(a,FD(f,a)) + UNEMP(f) ;

* condition on existence of the factor because set f has element fcap_flex and
* no data entry
 FMEQUIL(f)$SUM(a, FD0(f,a))..  SUM(insw,FSI(insw,f))
                         =E= SUM(a, FD(f,a)) ;

* FSDEF(f)..       FS(f) =E= SUM(ins,FSI(ins,f)) ;

* FS.FX(ff)$(NOT f(ff))   = FS0(ff) ;

* Unemployment
* UNEMPEQUIL(f).. UNEMP(f) =G= 0 ;

* ### Commodity and activity market clearing

 PRODEQUIL(a,c)..  QXAC(a,c) =E= IOQXACQXV(a,c)*QX(a) ;

 QEQUIL(c)..       QQ(c)  =E= QTTD(c) + SUM(a,QINTD(c,a))
                               + SUM(h,QCD(c,h)) + SUM(e,QED(c,e))
                               + QGD(c) + SUM[in,QINVD(c,in)] + dstocconst(c) ;

* ### Institutional account (market) clearing

 GOVEQUIL..        KAPGOV =E= YG - EG ;

 CAEQUIL..         CAPWOR =E= SUM(cm,PWM(cm)*QM(cm))
                               + (SUM(f,YFWOR(f))/ER)
                               - SUM(ce,PWE(ce)*QE(ce))
                               - SUM(h,howor(h))
                               - SUM(e,entwor(e))
                               - govwor
                               - SUM(f,factwor(f)) ;

* #### Absorption Closure

 VFDOMDEQ..   VFDOMD =E= SUM(c, PQCD(c) *  SUM[h,QCD(c,h)])
                           + SUM{c,PQD(c) *
                               [SUM(e,QED(c,e)) + QGD(c)
                                 + SUM[in,QINVD(c,in)] + dstocconst(c)]} ;

 INVESTSHEQ..
       INVESTSH * VFDOMD =E= INVEST ;

 VGDSHEQ..
          VGDSH * VFDOMD =E= VGD ;

 VEDSHEQ(e)..
       VEDSH(e) * VFDOMD =E= VED(e) ;

* ##### GDP

 GDPEQ..      GDP =E= SUM[(c,h), PQCD(c) * QCD(c,h)]
                       + SUM{c,PQD(c) *
                           [SUM(e,QED(c,e)) + QGD(c)
                            + SUM[in,QINVD(c,in)] + dstocconst(c)]}
                         + SUM(c,PWE(c) * ER * QE(c))
                         - SUM(c,PWM(c) * ER * QM(c)) ;

 ABSORPEQ..  ABSORP =E= SUM[(c,h), PQCD(c) * QCD(c,h)]
                        + SUM{c,PQD(c) *
                            [SUM(e,QED(c,e)) + QGD(c)
                              + SUM[in,QINVD(c,in)] + dstocconst(c)]} ;

* ##### Slack

 WALRASEQ..       TOTSAV =E= INVEST + WALRAS ;

*################ 16. MODEL CLOSURE ######################################
$ontext
   The standard or default closure is a minimal closure.
   It is assumed that the closures used for experiments will be set in the
experiment files.
$offtext

$INCLUDE 3_close/stg_t_cl_base.inc

*################ 17. MODEL & SOLVE STATEMENTS ###########################
$ontext
limrow - number of rows for each equation block in the *.lst file (default 3)
limcol - number of columns for each equation block in the *.lst file (default 3)
iterlim - limit on iterations (default 1000)
nlp - non-linear programming
mcp - mixed complementarity problem
PATH - PATH Solver
$offtext

 OPTION DECIMALS = 6 ;

 Options limrow=500,limcol=0;

 option iterlim = 25000 ;
* option iterlim = 20 ;

 option MCP           = PATH ;

 Model stg_t /

$ontext
When matching equations and variables: do NOT match variables that may be
fixed in any model closure.
$offtext
* ------- TRADE BLOCK ----------------------------------------------------
* #### Exports Block
 PEDEF.PE
 CET
 ESUPPLY
 EDEMAND
 CETALT
* #### Imports Block
 PMDEF.PM
 ARMINGTON
 COSTMIN
 ARMALT
* ------- TRADE AND TRANSPORT MARGINS BLOCK ------------------------------
 PTTDEF.PTT
 QTTDEF.QTT
 QTTDEQ.QTTD
* ------- COMMODITY PRICE BLOCK ------------------------------------------
 PQSDEF.PQS
 PQDDEF.PQD
 PQCDDEF.PQCD
 PXCDEF.PXC
* ------- NUMERAIRE PRICE BLOCK ------------------------------------------
 CPIDEF
 PPIDEF
* ------- PRODUCTION BLOCK -----------------------------------------------
 PXDEF.PX
 WFADEF
 PVADEF.PVA
 PINTDEF.PINT
 ADXDEF.ADX
 QXPRODFN.QX
 QXFOC
 QINTDEF.QINT
 QVADEF.QVA
 ADVADEF.ADVA
 QVAPRODFN
 QVAFOC
 FDPRODFN
 FDFOC
 QINTDEQ.QINTD
 COMOUT
 COMOUTFOC
 COMOUT2
 COMOUTFOC2
 ACTOUT.QXAC
 ACTOUTFOC
* ------- FACTOR BLOCK ---------------------------------------------------
 YFEQ.YF
 YFDISPEQ.YFDISP
 YFINSEQ.YFINS
 FSISHEQ.FSISH
 INSVAEQ.INSVA
* ------- HOUSEHOLD BLOCK ------------------------------------------------
 YHEQ.YH
 HOHOEQ.HOHO
 HEXPEQ.HEXP
 QCDEQ.QCD
* ------- ENTERPRISE BLOCK -----------------------------------------------
 YEEQ.YE
 QEDEQ.QED
 HOENTEQ.HOENT
 VEDEQ
 GOVENTEQ.GOVENT
* ------- GOVERNMENT BLOCK -----------------------------------------------
 TEDEF.TE
 TMDEF.TM
 TSDEF.TS
 TSSDEF.TSS
 TVDEF.TV
 TEXDEF.TEX
 TXDEF.TX
 TFDEF.TF
 TYFDEF.TYF
 TYHDEF.TYH
 TYEDEF.TYE

 MTAXEQ.MTAX
 ETAXEQ.ETAX
 STAXEQ.STAX
 SSTAXEQ.SSTAX
 VTAXEQ.VTAX
 EXTAXEQ.EXTAX
 ITAXEQ.ITAX
 FTAXEQ
 FYTAXEQ.FYTAX
 DTAXEQ.DTAX

 YGEQ.YG
 QGDEQ.QGD
 EGEQ.EG
 VGDEQ.VGD
* ------- KAPITAL BLOCK --------------------------------------------------
 SHHDEF.SHH
 HHSAVEQ.HHSAV
 ENTSAVEQ.ENTSAV
 SENDEF.SEN
 TOTSAVEQ.TOTSAV
 QINVDEQ.QINVD
 QINVEQ
 INVSH_IEQ
 INVESTEQ
* ------- FOREIGN INSTITUTIONS BLOCK -------------------------------------
 YFWOREQ.YFWOR
* ------- MARKET CLEARING BLOCK ------------------------------------------
 FMEQUIL
* UNEMPEQUIL.WF
* FSDEF
 PRODEQUIL.IOQXACQXV
 QEQUIL.QQ
 GOVEQUIL
 CAEQUIL
 VFDOMDEQ
 INVESTSHEQ
 VGDSHEQ
 VEDSHEQ
 GDPEQ.GDP
 ABSORPEQ.ABSORP
 WALRASEQ.WALRAS

             / ;

 PD.FX(c)$(NOT cd(c))         = 0.0 ;
 QD.FX(c)$(NOT cd(c))         = 0.0 ;

 stg_t.HOLDFIXED   = 1 ;
 stg_t.TOLINFREP   = 0.0000001 ;
 stg_t.TOLINFEAS   = 0.0000001 ;
* stg_t.TOLINFEAS   = 0.00000000001 ;

Solve stg_t Using MCP ;

*################ 18. SOCIAL ACCOUNTING MATRICES #########################
$ontext
This section checks that the model is solved with a balanced SAM,
by using a Macro and a Micro SAM.

The MICRO SAM element can be switched off by setting "micsam2" = 0 in the
parameter 'flow_cont' in the worksheet 'controls'

The check on the MICRO SAM is only implemented if "numerchk" = 1

 1) Macro SAM
  The programme aborts IF
           - ROW AND COLUMN SUMS FOR ASAM2 NOT EQUAL
           - ALL ASAM1 CELL ENTRIES DO NOT EQUAL ASAM0 ENTRIES

 2) Micro SAM
  The programme aborts IF
           - ALL SAM2 CELL ENTRIES DO NOT EQUAL SAM1 ENTRIES

 ALL ABORT commands are after the Macro and Micro SAM checks are computed
$offtext

$SETGLOBAL ASAM_chk  ASAM2
$SETGLOBAL SAM_chk   SAM2

$INCLUDE 2_include/stg_t_samchk.inc

$DROPGLOBAL ASAM_chk
$DROPGLOBAL SAM_chk

*################ 19. POLICY EXPERIMENTS ################################

$ontext

$SETGLOBAL   res_dimen    sim 
$SETGLOBAL   expt_data    stg_t_expt_7_2
$SETGLOBAL   expt_res     trade


$INCLUDE 4_expts/stg_t_expt_7_2_sol.inc

$INCLUDE 5_analysis/stg_t_anal.inc

$offtext

* ================================================= END OF MODEL CODE FILE
