* -------------- stg_t SAM2_chk checks ----------------------------------------
$ontext
  This file checks that the model solves correctly by checking that
the solution values for variables and parameters produce balanced Macro
and Micro SAM.

  The programme aborts IF checks are failed and reports are displayed.
$offtext

* ------- MACRO SAM ------------------------------------------------------
$ontext
  This section checks that the model is solved with a balanced SAM,
by using a Macro SAM.

  The programme aborts IF
           - ROW AND COLUMN SUMS FOR ASAM* NOT EQUAL
           - ALL ASAM* CELL ENTRIES DO NOT EQUAL ASAM1 ENTRIES

  Reports are produced for
      i)   the ratio of ASAM1 to ASAM0 (all should equal 1)
      ii)  the differences between the Macro SAMs
      iii) a count of the number of differences.
$offtext

 OPTION DECIMALS = 6 ;

 %ASAM_chk%("COMMDTY","MARG")     = SUM(c,QTTD.L(c)*PQD.L(c)) ;
 %ASAM_chk%("COMMDTY","ACTIVITY") = SUM((c,a),QINTD.L(c,a)*PQD.L(c)) ;
 %ASAM_chk%("COMMDTY","HHOLDS")   = SUM((c,h),QCD.L(c,h)*PQCD.L(c)) ;
 %ASAM_chk%("COMMDTY","ENTP")     = SUM((c,e),QED.L(c,e)*PQD.L(c)) ;
 %ASAM_chk%("COMMDTY","GOVTN")    = SUM(c,QGD.L(c)*PQD.L(c)) ;
 %ASAM_chk%("COMMDTY","KAPITAL")  = SUM[(c,in),QINVD.L(c,in)*PQD.L(c)]
                                    + SUM[c,PQD.L(c)*dstocconst(c)] ;
 %ASAM_chk%("COMMDTY","WORLD")    = SUM(c,PWE.L(c)*QE.L(c)*ER.L) ;

 %ASAM_chk%("MARG","COMMDTY")     = SUM((m,c),ioqttqe(m,c) * PTT.L(m) * QE.L(c))
                                    + SUM((m,c),ioqttqq(m,c) * PTT.L(m) * QQ.L(c)) ;

 %ASAM_chk%("ACTIVITY","COMMDTY") = SUM(a,PX.L(a)*QX.L(a)) ;

 %ASAM_chk%("VALUAD","ACTIVITY")  = SUM((f,a),WF.L(f)*WFDIST.L(f,a)*FD.L(f,a)) ;
 %ASAM_chk%("VALUAD","WORLD")     = SUM(f,factwor(f)*ER.L) ;

 %ASAM_chk%("HHOLDS","VALUAD")    = SUM((h,f),hovash(h,f)*YFDISP.L(f)) ;
 %ASAM_chk%("HHOLDS","HHOLDS")    = SUM((h,hp),hohosh(h,hp)
                                    *((YH.L(h)*(1-TYH.L(h)))*(1-SHH.L(h)))) ;
 %ASAM_chk%("HHOLDS","ENTP")      = SUM((h,e),HOENT.L(h,e)) ;
 %ASAM_chk%("HHOLDS","GOVTN")     = SUM(h,hogovconst(h)*CPI.L*HGADJ.L) ;
 %ASAM_chk%("HHOLDS","WORLD")     = SUM(h,howor(h)*ER.L) ;

 %ASAM_chk%("ENTP","VALUAD")      = SUM((e,f),entvash(e,f)*YFDISP.L(f)) ;
 %ASAM_chk%("ENTP","GOVTN")       = SUM(e,EGADJ.L*entgovconst(e)*CPI.L) ;
 %ASAM_chk%("ENTP","WORLD")       = SUM(e,entwor(e)*ER.L) ;

 %ASAM_chk%("GOVTN","COMMDTY")    = SUM(c,TM.L(c)*PWM.L(c)*QM.L(c)*ER.L)
                                    + SUM(c,TE.L(c)*PWE.L(c)*ER.L*QE.L(c))
                                    + SUM(c,TS.L(c)*PQS.L(c)*QQ.L(c))
                                    + SUM(c,TSS.L(c)*PQS.L(c)*QQ.L(c))
                                    + SUM((c,h),TV.L(c)*PQD.L(c)*QCD.L(c,h))
                                    + SUM(c,TEX.L(c)*QQ.L(c))  ;
 %ASAM_chk%("GOVTN","ACTIVITY")   = SUM(a,TX.L(a)*PX.L(a)*QX.L(a))
                                    + SUM((f,a),TF.L(f,a)*WF.L(f)*WFDIST.L(f,a)
                                    *FD.L(f,a)) ;
 %ASAM_chk%("GOVTN","VALUAD")     = SUM(f,govvash(f)*YFDISP.L(f))
                                    + SUM(f,TYF.L(f)*(YF.L(f)*(1- deprec(f)))) ;
 %ASAM_chk%("GOVTN","HHOLDS")     = SUM(h,TYH.L(h)*YH.L(h)) ;
 %ASAM_chk%("GOVTN","ENTP")       = SUM(e,GOVENT.L(e))
                                    + SUM(e,TYE.L(e)*YE.L(e)) ;
 %ASAM_chk%("GOVTN","WORLD")      = (govwor*ER.L) ;

 %ASAM_chk%("KAPITAL","VALUAD")   = SUM(f,deprec(f)*YF.L(f)) ;
 %ASAM_chk%("KAPITAL","HHOLDS")   = SUM(h,(YH.L(h)*(1-TYH.L(h)))*SHH.L(h)) ;
 %ASAM_chk%("KAPITAL","ENTP")     = SUM(e,(YE.L(e)*(1-TYE.L(e)))*SEN.L(e)) ;
 %ASAM_chk%("KAPITAL","GOVTN")    = KAPGOV.L ;
 %ASAM_chk%("KAPITAL","WORLD")    = (CAPWOR.L*ER.L) ;

 %ASAM_chk%("WORLD","COMMDTY")    = SUM(c,PWM.L(c)*QM.L(c)*ER.L) ;
 %ASAM_chk%("WORLD","VALUAD")     = SUM(f,YFWOR.L(f)) ;

 %ASAM_chk%("TOTALS",ssnp)        = SUM(ssn,%ASAM_chk%(ssn,ssnp)) ;
 %ASAM_chk%(ssn,"TOTALS")         = SUM(ssnp,%ASAM_chk%(ssn,ssnp)) ;

*-------- Checking that a balanced and equal ASAM is produced
PARAMETER
 %ASAM_chk%CHK(ss,ss)    Ratio of %ASAM_chk% to ASAM1 - 1 except for numeraire check
 CHECK2             Differences in Row and Column totals of %ASAM_chk%

 DIFF%ASAM_chk%(ss,ss)   Differences between ASAM and %ASAM_chk%

 CNT%ASAM_chk%           Count of non zero entries in DIFF%ASAM_chk%

 ;

 CHECK2 = SUM(ssn,(ABS(%ASAM_chk%(ssn,"TOTALS")-%ASAM_chk%("TOTALS",ssn)))) ;

 %ASAM_chk%CHK(ss,ssp)$ASAM1(ss,ssp)
                   = (%ASAM_chk%(ss,ssp))/ASAM0(ss,ssp) ;

 DIFF%ASAM_chk%(ss,ssp)  = (ASAM1(ss,ssp) * mod_cont("numerchk")) - %ASAM_chk%(ss,ssp) ;

 DIFF%ASAM_chk%(ss,ssp)$(ABS(DIFF%ASAM_chk%(ss,ssp)
                  lt (10*mod_cont("toldiffsam")))) = 0.0 ;

 DIFF%ASAM_chk%("totals","totals")   = 0.0 ;

 CNT%ASAM_chk%  = SUM((ssn,ssnp)$DIFF%ASAM_chk%(ssn,ssnp), 1) ;

 OPTION decimals = 6 ;

* ------- Micro SAM ------------------------------------------------------
$ontext
  This section checks that the model solution produces a balanced SAM,
by using a Micro SAM.

  The programme aborts IF
           - ALL %SAM_chk% CELL ENTRIES DO NOT EQUAL SAM1 ENTRIES

  Reports are produced for
      i)   the ratio of ASAM1 to ASAM0 (all should equal 1)
      ii)  the differences between the Macro SAMs
      iii) a count of the number of differences.
$offtext

PARAMETER
 %SAM_chk%(sac,sacp)     Micro SAM for checking initial model solve

 %SAM_chk%CHK(sac,sac)   Ratio of %SAM_chk% to SAM1 should be 1
 DIFF%SAM_chk%(sac,sac)  Differences between SAM1 and %SAM_chk%
 CNT%SAM_chk%            Count of non zero entries in DIFF%SAM_chk%

  ;

If(mod_cont("mic%SAM_chk%") = 1,

 %SAM_chk%(c,m)              = ioqtdqtt(c,m)*QTT.L(m)*PQD.L(c) ;

 %SAM_chk%(c,a)              = QINTD.L(c,a)*PQD.L(c);

 %SAM_chk%(c,h)              = QCD.L(c,h)*PQCD.L(c) ;

 %SAM_chk%(c,e)              = QED.L(c,e)*PQD.L(c) ;

 %SAM_chk%(c,"govt")         = QGD.L(c)*PQD.L(c) ;

 %SAM_chk%(c,i)              = QINVD.L(c,i)*PQD.L(c) ;
 %SAM_chk%(c,"dstoc")        = PQD.L(c)*dstocconst(c) ;

 %SAM_chk%(c,"row")          = PWE.L(c)*QE.L(c)*ER.L ;

 %SAM_chk%(m,c)              = (ioqttqe(m,c) * PTT.L(m) * QE.L(c))
                               +(ioqttqq(m,c) * PTT.L(m) * QQ.L(c)) ;

 %SAM_chk%(a,c)              = PXAC.L(a,c)*QXAC.L(a,c) ;

 %SAM_chk%(f,a)              = WF.L(f)*WFDIST.L(f,a)*FD.L(f,a);

 %SAM_chk%(f,"row")          = factwor(f)*ER.L;

 %SAM_chk%(h,f)              = hovash(h,f)*YFDISP.L(f);

 %SAM_chk%(h,hp)             = hohosh(h,hp)
                               * ((YH.L(h)*(1-TYH.L(h)))*(1-SHH.L(h))) ;

 %SAM_chk%(h,e)              = HOENT.L(h,e) ;

 %SAM_chk%(h,"govt")         = hogovconst(h)*CPI.L*HGADJ.L ;

 %SAM_chk%(h,"row")          = howor(h)*ER.L ;

 %SAM_chk%(e,f)              = entvash(e,f)*YFDISP.L(f) ;

 %SAM_chk%(e,"govt")         = EGADJ.L*entgovconst(e)*CPI.L ;

 %SAM_chk%(e,"row")          = entwor(e)*ER.L ;

 %SAM_chk%("govt","imptax")  = SUM(c,TM.L(c)*PWM.L(c)*QM.L(c)*ER.L) ;
 %SAM_chk%("imptax",c)       = TM.L(c)*PWM.L(c)*QM.L(c)*ER.L ;

 %SAM_chk%("govt","exptax")  = SUM(c,TE.L(c)*PWE.L(c)*ER.L*QE.L(c)) ;
 %SAM_chk%("exptax",c)       = TE.L(c)*PWE.L(c)*ER.L*QE.L(c) ;

 %SAM_chk%("govt","saltax")  = SUM(c,TS.L(c)*PQS.L(c)*QQ.L(c)) ;
 %SAM_chk%("saltax",c)       = TS.L(c)*PQS.L(c)*QQ.L(c) ;

 %SAM_chk%("govt","ssaltax") = SUM(c,TSS.L(c)*PQS.L(c)*QQ.L(c)) ;
 %SAM_chk%("ssaltax",c)      = TSS.L(c)*PQS.L(c)*QQ.L(c) ;

 %SAM_chk%("govt","vattax")  = SUM((c,h),TV.L(c)*PQD.L(c)*QCD.L(c,h)) ;
 %SAM_chk%("vattax",c)       = SUM(h,TV.L(c)*PQD.L(c)*QCD.L(c,h)) ;

 %SAM_chk%("govt","ectax")   = SUM(c,TEX.L(c)*QQ.L(c)) ;
 %SAM_chk%("ectax",c)        = TEX.L(c)*QQ.L(c) ;

 %SAM_chk%("govt","indtax")  = SUM(a,TX.L(a)*PX.L(a)*QX.L(a)) ;
 %SAM_chk%("indtax",a)       = TX.L(a)*PX.L(a)*QX.L(a) ;

 %SAM_chk%("govt",tff)       = SUM(a,SUM(f$map_tff_f(tff,f),
                               TF.L(f,a)*WF.L(f)*WFDIST.L(f,a)*FD.L(f,a))) ;
                               
 %SAM_chk%(tff,a)            = SUM(f$map_tff_f(tff,f),
                               TF.L(f,a)*WF.L(f)*WFDIST.L(f,a)*FD.L(f,a)) ;

 %SAM_chk%("facttax",f)      = TYF.L(f)*(YF.L(f)*(1- deprec(f)));
 %SAM_chk%("govt","facttax") = SUM(f,TYF.L(f)*(YF.L(f)*(1- deprec(f)))) ;

 %SAM_chk%("dirtax",h)       = TYH.L(h)*YH.L(h) ;

 %SAM_chk%("dirtax",e)       = TYE.L(e)*YE.L(e) ;

 %SAM_chk%("govt","dirtax")  = SUM(h,TYH.L(h)*YH.L(h))
                               + SUM(e,(TYE.L(e)*YE.L(e))) ;

 %SAM_chk%("govt",f)         = govvash(f)*YFDISP.L(f) ;

 %SAM_chk%("govt","row")     = (govwor*ER.L) ;

 %SAM_chk%("i_s",f)          = deprec(f)*YF.L(f) ;

 %SAM_chk%("i_s",h)          = (YH.L(h)*(1-TYH.L(h)))*SHH.L(h) ;

 %SAM_chk%("i_s",e)          = (YE.L(e) * (1-TYE.L(e)))*SEN.L(e) ;
 %SAM_chk%("i_s","govt")     = KAPGOV.L ;
 %SAM_chk%("i_s","row")      = (CAPWOR.L*ER.L) ;

 %SAM_chk%(in,"i_s")         = SUM[c,SAM1(c,in)] ;
 %SAM_chk%("dstoc","i_s")    = SUM[c,SAM1(c,"dstoc")] ;

 %SAM_chk%("row",c)          = PWM.L(c)*QM.L(c)*ER.L ;
 %SAM_chk%("row",f)          = YFWOR.L(f) ;

 %SAM_chk%("total",sac)      = SUM(sacnp, %SAM_chk%(sacnp,sac)) ;
 %SAM_chk%(sac,"total")      = SUM(sacnp, %SAM_chk%(sac,sacnp)) ;

 %SAM_chk%(sac,sacp)         = %SAM_chk%(sac,sacp) ;

  ) ;

* Testing for differences between %SAM_chk% and SAM1

*IF((mod_cont("numerchk") and flow_cont("mic%SAM_chk%")) = 1,

option decimals = 6 ;

 %SAM_chk%CHK(sac,sacp)$SAM1(sac,sacp)
                         = %SAM_chk%(sac,sacp)/SAM1(sac,sacp) ;

 DIFF%SAM_chk%(sac,sacp) = [SAM1(sac,sacp) * mod_cont("numerchk")]
                            - %SAM_chk%(sac,sacp) ;

 DIFF%SAM_chk%(sac,sacp)$(ABS(DIFF%SAM_chk%(sac,sacp)) lt mod_cont("toldiffsam"))
                          = 0 ;

 DIFF%SAM_chk%("total","total")   = 0.0 ;

 CNT%SAM_chk%  = SUM((sac,sacp)$DIFF%SAM_chk%(sac,sacp), 1) ;

*---- Display and Abort Statements

 OPTION decimals = 8 ;

DISPLAY %ASAM_chk%, %ASAM_chk%CHK, CHECK2, DIFF%ASAM_chk%, CNT%ASAM_chk%,
        %SAM_chk%, %SAM_chk%CHK, DIFF%SAM_chk%, CNT%SAM_chk% ;

 OPTION decimals = 3 ;

 ABORT$(CHECK2 GT 0.000005)
         "SAM ROW AND COLUMN SUMS NOT EQUAL", CHECK2, %ASAM_chk% ;

 ABORT$(CNT%ASAM_chk% GT 0.0)
         "ALL %ASAM_chk% CELL ENTRIES DO NOT EQUAL ASAM1 ENTRIES", CNT%ASAM_chk% ;

 ABORT$(CNT%SAM_chk% GT 0.0)
         "ALL %SAM_chk% CELL ENTRIES DO NOT EQUAL SAM1 ENTRIES", CNT%SAM_chk% ;

* No totals check required since MICRO%SAM_chk% has already been checked

* -------------- END of stg_t %SAM_chk% checks --------------------------------
