* -------------------- stg_t experiment file -----------------------------
$ontext
 This file sets up and runs experiments on a model. It has a standard structure
 which is described directly below, but makes use (in sections 1 and 7) of two
 include files where users can define and implement their experiments.

 Structure (indentation indicates code structure):
   1.  Declare and Assign Simulation Set
   2.  Declare and Assign experiment parameters
   |   2a. Declare experiment parameters
   |   2b. Assign experiment parameters
   3.  Declare Result parameters
   4.  Setting Closures
   |   4a. Declaring Parameters for Closure
   |   4b. Assigning Parameters for Closure
   |   4c. Implementing Closure Changes
   5.  sim loop begins
   6.  Shocks implemented
   7.  Solve statement
   8.  Storing results
   9.  Terminating sim and expclos loops


The experiment code consists of a number of files; the relationships between
these files is illustrated below.

 stg_t.gms                                master programme file
     |
    .
     .
      .
       .
     |
     | 16. POLICY EXPERIMENTS
     |
     |<----- stg_t_expt_***.inc                 Experiment files
                 |
                 |<----- stg_t_resparm.inc       Declare results params
                 |
                 |<----- stg_t_varinit2.inc      Reinitialise variables
                 |<----- stg_t_reset.inc         Reset closure variables
                 |
                 |<----- stg_t_cl***1.inc        Alternative closures
                 |<----- stg_t_cl***..inc                 .
                 |<----- stg_t_cl***..inc                 .
                 |<----- stg_t_cl***n.inc        Alternative closures
                 |
                 |
                 |<----- stg_t_resassign.inc     Assigning results params
                 |
                 |
                 
      |
      |<----- stg_t_anal.inc                 Result Analyses sub routine
      |          |
                 |
                 |<----- stg_t_reslevel.inc       Levels results saved
                 |
                 |<----- stg_t_resmacro.inc       Macroeconomic results
                 |
                 |<----- stg_t_reswelf.inc        Welfare results
                 |
                 |<----- stg_t_resstruct.inc      Structural results
                 |
                 |<----- stg_t_resindex.inc       Price index results
                 |
                 |<----- stg_t_resperc.inc        Proportionate results

$offtext

* ------- 1. Declare and Assign Simulation Set ---------------------------

* By including a "base case" in the SIM set a comparator is produced

SETS
* Sets for simulations
 sim          simulations
 simc(sim)    simulations currently run

* Sets for closures
 clos         Set of sets of closure rules for each experiment

* Sets to control experiment flows
 econs        set for parameters controlling experiment & analyses

* Sets for results
 adjres       adjuster results
 scalres      scalar results

  ;

Parameter
* Parameters used to control experiment & analyses

 exp_cont(econs)    values for parameters controlling model content
 
 clos_cont(clos)    closure selection

*---- 1a. Excel workbook sets and data converted to gdx here

$CALL "GDXXRW i=1_2_Expt_data\%expt_data%.xlsx o=1_2_Expt_data\expt_in.gdx index=Layout!A4"

$if errorLevel 1 $abort problems with GDXXRW

*---- 1b. Load sets and parameters from GDX experiment data file

$GDXIN 1_2_Expt_data\expt_in.gdx

* Sets to control simulations
$LOADdc sim simc

* Sets and parameters to control closure rule selection
$LOADdc clos clos_cont

* Sets and parameters to control sensitivity analyses


* Sets to control experiment flows
$LOAD econs exp_cont

$GDXIN

DISPLAY sim, simc, clos, clos, clos_cont, exp_cont, econs ;

* ------- 2. Declare and Assign experiment parameters -------------------

*---- 2a. Declare experiment parameters

Parameter
 tmsim(c,sim)    tariff rate shock
  ;

*---- 2b. Assign experiment parameters

 tmsim(c,"base")  = 0.00 * tm0(c) ;
 tmsim(c,"sim01") = -0.5 * tm0(c) ;

Display tmsim ;

* ------- 3. Declare Result parameters ----------------------------------

$INCLUDE 5_analysis\stg_t_resparm.inc

* ------- 4. Setting LOOPS ------------------------------------------------


*~~~ Setting closure analyses

LOOP(clos,

*~~~~~ 4a. Resetting the model to base values and NO CLOSURE  
*~~ First, set .L values back to initial values for looping over diff closures

$INCLUDE 2_include/stg_t_varinit2.inc

*~~ Second, free all variables that are involved in any closure rule

$INCLUDE 3_close/stg_t_reset.inc

*~~~~~ 4b. Selecting the closure
* The closures run in this LOOP are defined by clos_cont in Excel

IF(clos_cont(clos) = 1,
$ontext
 stg_t_cl_base is a minimal neo classical closure used for model initialisation  
                     CONDITION

     FEX        - Exchange rate                      - FLEX
                - CAPWOR                             - FIX

     Investment - absorption share                   - FIX

     Government - absorption share                   - FIX
                - Tax rates                          - ALL FIX
                - KAPGOV                             - FLEX

     Factors    - Land sector                        - mobile & full
                - Capital                            - mobile & full
                - Unskilled labour                   - mobile & full
                - Skilled labour                     - mobile & full

     Numeraire  - CPI                                - FIX
                - PPI                                - FLEX
$offtext

$include 3_close/stg_t_cl_base.inc

* end of IF statement
) ;

IF(clos_cont(clos) = 2,
$ontext
 stg_t_cl_tyh is a minimal tax replacement closure using INCOME TAXES 
                     CONDITION

     FEX        - Exchange rate                      - FLEX
                - CAPWOR                             - FIX

     Investment - absorption share                   - FIX

     Government - absorption share                   - FIX
                - Income tax rates                   - FLEX multiplicative
                - Tax rates                          - ALL FIX
                - KAPGOV                             - FIX

     Factors    - Land sector                        - mobile & full
                - Capital                            - mobile & full
                - Unskilled labour                   - mobile & full
                - Skilled labour                     - mobile & full

     Numeraire  - CPI                                - FIX
                - PPI                                - FLEX
$offtext

$include 3_close/stg_t_cl_tyh_sol.inc

* end of IF statement
) ;

IF(clos_cont(clos) = 3,
$ontext
 stg_t_cl_ts is a minimal tax replacement closure using INCOME TAXES 
                     CONDITION

     FEX        - Exchange rate                      - FLEX
                - CAPWOR                             - FIX

     Investment - absorption share                   - FIX

     Government - absorption share                   - FIX
                - Sales tax rates                    - FLEX multiplicative
                - Other Tax rates                    - ALL FIX
                - KAPGOV                             - FIX

     Factors    - Land sector                        - mobile & full
                - Capital                            - mobile & full
                - Unskilled labour                   - mobile & full
                - Skilled labour                     - mobile & full

     Numeraire  - CPI                                - FIX
                - PPI                                - FLEX

It is assumed that the closures used for experiments will be set in the
experiment files.
$offtext

$include 3_close/stg_t_cl_ts_sol.inc

* end of IF statement
) ;

* ------- 5. sim loop begins ---------------------------------------------

LOOP(simc(sim),

* ------- 6. Shocks implemented ------------------------------------------

* ... SHOCKS HERE ...

 dabtm(c)  = tmsim(c,simc) ;


* ------- 7. Solve statement ---------------------------------------------

 OPTION DECIMALS = 6 ;
 option MCP        = PATH ;

 stg_t.HOLDFIXED   = 1 ;
 stg_t.TOLINFREP   = 0.0000001 ;
 stg_t.TOLINFEAS   = 0.000000001 ;

 Solve stg_t Using MCP ;

* ------- 8. Storing results ---------------------------------------------

$INCLUDE 5_analysis\stg_t_resassign.inc

* ------- 9. Terminating sim and expclos loops ---------------------------

* The following two lines terminate the experiment loops

*  END of sim LOOP
 ) ;
 
* END of clos LOOP
 ) ;
 
* END of sens LOOP

 
* ------------------ END of stg_t experiment file ------------------------
